/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.account.ebics.schema.h003.DataEncryptionInfoType;
import com.axelor.apps.account.ebics.schema.h003.DataTransferRequestType;
import com.axelor.apps.account.ebics.schema.h003.EbicsRequestDocument;
import com.axelor.apps.account.ebics.schema.h003.MutableHeaderType;
import com.axelor.apps.account.ebics.schema.h003.StandardOrderParamsType;
import com.axelor.apps.account.ebics.schema.h003.StaticHeaderOrderDetailsType;
import com.axelor.apps.account.ebics.schema.h003.StaticHeaderType;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.ebics.certificate.KeyUtil;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.EbicsUtils;
import com.axelor.apps.bankpayment.ebics.client.OrderAttribute;
import com.axelor.apps.bankpayment.ebics.client.OrderType;
import com.axelor.apps.bankpayment.ebics.xml.EbicsXmlFactory;
import com.axelor.apps.bankpayment.ebics.xml.InitializationRequestElement;
import com.axelor.apps.bankpayment.ebics.xml.UserSignature;
import com.axelor.exception.AxelorException;
import java.util.Calendar;
import javax.crypto.spec.SecretKeySpec;

public class SPRRequestElement
extends InitializationRequestElement {
    private SecretKeySpec keySpec;

    public SPRRequestElement(EbicsSession session) throws AxelorException {
        super(session, OrderType.SPR, "SPRRequest.xml");
        this.keySpec = new SecretKeySpec(this.nonce, "EAS");
    }

    @Override
    public void buildInitialization() throws AxelorException {
        EbicsUser ebicsUser = this.session.getUser();
        EbicsPartner ebicsPartner = ebicsUser.getEbicsPartner();
        UserSignature userSignature = new UserSignature(ebicsUser, SPRRequestElement.generateName("SIG"), "A005", " ".getBytes(), " ".getBytes());
        userSignature.build();
        userSignature.validate();
        MutableHeaderType mutable = EbicsXmlFactory.createMutableHeaderType("Initialisation", null);
        StaticHeaderType.Product product = EbicsXmlFactory.createProduct(this.session.getProduct().getLanguage(), this.session.getProduct().getName());
        StaticHeaderType.BankPubKeyDigests.Authentication authentication = EbicsXmlFactory.createAuthentication("X002", "http://www.w3.org/2001/04/xmlenc#sha256", this.decodeHex(KeyUtil.getKeyDigest(this.session.getBankX002Key())));
        StaticHeaderType.BankPubKeyDigests.Encryption encryption = EbicsXmlFactory.createEncryption("E002", "http://www.w3.org/2001/04/xmlenc#sha256", this.decodeHex(KeyUtil.getKeyDigest(this.session.getBankE002Key())));
        StaticHeaderType.BankPubKeyDigests bankPubKeyDigests = EbicsXmlFactory.createBankPubKeyDigests(authentication, encryption);
        StaticHeaderOrderDetailsType.OrderType orderType = EbicsXmlFactory.createOrderType(this.type.getOrderType());
        StandardOrderParamsType standardOrderParamsType = EbicsXmlFactory.createStandardOrderParamsType();
        OrderAttribute orderAttribute = new OrderAttribute(this.type, ebicsPartner.getEbicsTypeSelect());
        orderAttribute.build();
        StaticHeaderOrderDetailsType orderDetails = EbicsXmlFactory.createStaticHeaderOrderDetailsType(ebicsUser.getNextOrderId(), orderAttribute.getOrderAttributes(), orderType, standardOrderParamsType);
        StaticHeaderType xstatic = EbicsXmlFactory.createStaticHeaderType(this.session.getBankID(), this.nonce, 0, ebicsPartner.getPartnerId(), product, ebicsUser.getSecurityMedium(), ebicsUser.getUserId(), Calendar.getInstance(), orderDetails, bankPubKeyDigests);
        EbicsRequestDocument.EbicsRequest.Header header = EbicsXmlFactory.createEbicsRequestHeader(true, mutable, xstatic);
        DataEncryptionInfoType.EncryptionPubKeyDigest encryptionPubKeyDigest = EbicsXmlFactory.createEncryptionPubKeyDigest("E002", "http://www.w3.org/2001/04/xmlenc#sha256", this.decodeHex(KeyUtil.getKeyDigest(this.session.getBankX002Key())));
        DataTransferRequestType.SignatureData signatureData = EbicsXmlFactory.createSignatureData(true, EbicsUtils.encrypt(EbicsUtils.zip(userSignature.prettyPrint()), this.keySpec));
        DataTransferRequestType.DataEncryptionInfo dataEncryptionInfo = EbicsXmlFactory.createDataEncryptionInfo(true, encryptionPubKeyDigest, this.generateTransactionKey());
        DataTransferRequestType dataTransfer = EbicsXmlFactory.createDataTransferRequestType(dataEncryptionInfo, signatureData);
        EbicsRequestDocument.EbicsRequest.Body body = EbicsXmlFactory.createEbicsRequestBody(dataTransfer);
        EbicsRequestDocument.EbicsRequest request = EbicsXmlFactory.createEbicsRequest(1, "H003", header, body);
        this.document = EbicsXmlFactory.createEbicsRequestDocument(request);
    }
}

