/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.account.ebics.schema.h003.DataTransferRequestType;
import com.axelor.apps.account.ebics.schema.h003.EbicsRequestDocument;
import com.axelor.apps.account.ebics.schema.h003.MutableHeaderType;
import com.axelor.apps.account.ebics.schema.h003.StaticHeaderType;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.OrderType;
import com.axelor.apps.bankpayment.ebics.interfaces.ContentFactory;
import com.axelor.apps.bankpayment.ebics.io.IOUtils;
import com.axelor.apps.bankpayment.ebics.xml.EbicsXmlFactory;
import com.axelor.apps.bankpayment.ebics.xml.TransferRequestElement;
import com.axelor.exception.AxelorException;
import java.io.ByteArrayOutputStream;
import org.jdom.JDOMException;

public class UTransferRequestElement
extends TransferRequestElement {
    private ContentFactory content;

    public UTransferRequestElement(EbicsSession session, OrderType orderType, int segmentNumber, boolean lastSegment, byte[] transactionId, ContentFactory content) {
        super(session, UTransferRequestElement.generateName(orderType), orderType, segmentNumber, lastSegment, transactionId);
        this.content = content;
    }

    @Override
    public void buildTransfer() throws AxelorException {
        MutableHeaderType.SegmentNumber segmentNumber = EbicsXmlFactory.createSegmentNumber(this.segmentNumber, this.lastSegment);
        MutableHeaderType mutable = EbicsXmlFactory.createMutableHeaderType("Transfer", segmentNumber);
        StaticHeaderType xstatic = EbicsXmlFactory.createStaticHeaderType(this.session.getBankID(), this.transactionId);
        EbicsRequestDocument.EbicsRequest.Header header = EbicsXmlFactory.createEbicsRequestHeader(true, mutable, xstatic);
        DataTransferRequestType.OrderData orderData = EbicsXmlFactory.createEbicsRequestOrderData(IOUtils.getFactoryContent(this.content));
        DataTransferRequestType dataTransfer = EbicsXmlFactory.createDataTransferRequestType(orderData);
        EbicsRequestDocument.EbicsRequest.Body body = EbicsXmlFactory.createEbicsRequestBody(dataTransfer);
        EbicsRequestDocument.EbicsRequest request = EbicsXmlFactory.createEbicsRequest(1, "H003", header, body);
        this.document = EbicsXmlFactory.createEbicsRequestDocument(request);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.save(bout);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        System.out.println("Requete data ----------------------------------------------------------------------------");
        System.out.println(bout.toString());
    }
}

