/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.bankpayment.db.EbicsCertificate;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.ebics.service.EbicsUserService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import java.math.BigInteger;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSignatureVerify {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private EbicsUser user;
    private byte[] signature;
    private byte[] bankOrderContent;
    private String modulus;
    private String exponent;

    public UserSignatureVerify(EbicsUser user, byte[] bankOrderContent, byte[] signature) {
        this.user = user;
        this.bankOrderContent = bankOrderContent;
        this.signature = signature;
        this.loadCertificate();
    }

    public void verify() throws AxelorException {
        String originalDigestFromSignature;
        String comptedSha256Digest = this.computeSha256Digest();
        if (!comptedSha256Digest.equals(originalDigestFromSignature = this.getOriginalDigestFromSignature())) {
            String message = I18n.get((String)"Computed digest (SHA256) of the bank order file doesn't match with the digest extract from the signature") + " \n";
            message = message + I18n.get((String)"Computed digest (SHA256) of the bank order file :") + " " + comptedSha256Digest + "\n";
            message = message + I18n.get((String)"Original digest extracted from the signature :") + " " + originalDigestFromSignature;
            throw new AxelorException(message, 5, new Object[0]);
        }
    }

    public void loadCertificate() {
        EbicsCertificate certificate = this.user.getA005Certificate();
        this.modulus = certificate.getPublicKeyModulus();
        this.exponent = certificate.getPublicKeyExponent();
    }

    public String computeSha256Digest() {
        this.bankOrderContent = EbicsUserService.removeOSSpecificChars(this.bankOrderContent);
        String sha = DigestUtils.sha256Hex((byte[])this.bankOrderContent);
        this.log.debug("Digest (SHA256) of bank order content : {}", (Object)sha);
        return sha;
    }

    public String getOriginalDigestFromSignature() {
        String hexSignature = this.getHexSignature();
        System.out.println("Signature (HEX STRING) : " + hexSignature);
        String result = new BigInteger(hexSignature, 16).modPow(new BigInteger(this.exponent, 16), new BigInteger(this.modulus, 16)).toString(16);
        this.log.debug("Orignal digest from signature (with padding) : {}", (Object)result);
        result = result.substring(result.length() - 64, result.length());
        this.log.debug("Orignal digest from signature : {}", (Object)result);
        return result;
    }

    public String getHexSignature() {
        return Hex.encodeHexString((byte[])this.signature);
    }
}

