/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service;

import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentSchedule;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.repo.InterbankCodeLineRepository;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.PaymentScheduleLineRepository;
import com.axelor.apps.account.db.repo.ReconcileRepository;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.PaymentScheduleLineServiceImpl;
import com.axelor.apps.account.service.PaymentScheduleService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.account.service.move.MoveToolService;
import com.axelor.apps.account.service.move.MoveValidateService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.account.service.payment.PaymentService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCancelService;
import com.axelor.apps.bankpayment.service.PaymentScheduleLineBankPaymentService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PaymentScheduleLineBankPaymentServiceImpl
extends PaymentScheduleLineServiceImpl
implements PaymentScheduleLineBankPaymentService {
    protected InvoicePaymentCancelService invoicePaymentCancelService;
    protected InterbankCodeLineRepository interbankCodeLineRepo;
    protected ReconcileRepository reconcileRepo;
    protected InvoicePaymentRepository invoicePaymentRepo;

    @Inject
    public PaymentScheduleLineBankPaymentServiceImpl(AppBaseService appBaseService, PaymentScheduleService paymentScheduleService, MoveService moveService, PaymentModeService paymentModeService, SequenceService sequenceService, AccountingSituationService accountingSituationService, MoveToolService moveToolService, PaymentService paymentService, InvoicePaymentCancelService invoicePaymentCancelService, InterbankCodeLineRepository interbankCodeLineRepo, MoveLineRepository moveLineRepo, PaymentScheduleLineRepository paymentScheduleLineRepo, ReconcileRepository reconcileRepo, InvoicePaymentRepository invoicePaymentRepo) {
        super(appBaseService, paymentScheduleService, moveService, paymentModeService, sequenceService, accountingSituationService, moveToolService, paymentService, moveLineRepo, paymentScheduleLineRepo);
        this.invoicePaymentCancelService = invoicePaymentCancelService;
        this.interbankCodeLineRepo = interbankCodeLineRepo;
        this.reconcileRepo = reconcileRepo;
        this.invoicePaymentRepo = invoicePaymentRepo;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void reject(PaymentScheduleLine paymentScheduleLine, InterbankCodeLine rejectionReason, boolean represent) throws AxelorException {
        Preconditions.checkNotNull((Object)paymentScheduleLine, (Object)I18n.get((String)"Payment schedule line cannot be null."));
        PaymentSchedule paymentSchedule = paymentScheduleLine.getPaymentSchedule();
        Preconditions.checkNotNull((Object)paymentSchedule, (Object)I18n.get((String)"Parent payment schedule cannot be null."));
        if (paymentScheduleLine.getStatusSelect() != 3) {
            throw new AxelorException((Model)paymentScheduleLine, 5, I18n.get((String)"Only validated payment schedule lines can be rejected."));
        }
        Move rejectionMove = this.createRejectionMove(paymentScheduleLine);
        if (paymentSchedule.getTypeSelect() == 1) {
            this.cancelInvoicePayments(paymentScheduleLine);
        }
        if (represent) {
            this.representPaymentScheduleLine(paymentScheduleLine);
        }
        if (rejectionReason == null) {
            rejectionReason = this.getDefaultRejectionReason();
        }
        MoveLine rejectionMoveLine = this.moveService.findMoveLineByAccount(rejectionMove, paymentScheduleLine.getAdvanceMoveLine().getAccount());
        paymentScheduleLine.setInterbankCodeLine(rejectionReason);
        paymentScheduleLine.setRejectMoveLine(rejectionMoveLine);
        paymentScheduleLine.setRejectDate(rejectionMove.getDate());
        paymentScheduleLine.setAmountRejected(paymentScheduleLine.getRejectMoveLine().getDebit());
        paymentScheduleLine.setRejectedOk(Boolean.valueOf(true));
        paymentScheduleLine.setStatusSelect(Integer.valueOf(4));
    }

    @Override
    public void reject(String paymentScheduleLineName, InterbankCodeLine rejectionReason, boolean represent) throws AxelorException {
        PaymentScheduleLine paymentScheduleLine = this.paymentScheduleLineRepo.findByName(paymentScheduleLineName);
        this.reject(paymentScheduleLine, rejectionReason, represent);
    }

    @Override
    public InterbankCodeLine getDefaultRejectionReason() {
        return this.interbankCodeLineRepo.findByCode("A3");
    }

    @Transactional(rollbackOn={Exception.class})
    protected Move createRejectionMove(PaymentScheduleLine paymentScheduleLine) throws AxelorException {
        MoveValidateService moveValidateService = this.moveService.getMoveValidateService();
        MoveLineService moveLineService = this.moveService.getMoveLineService();
        Move advanceOrPaymentMove = paymentScheduleLine.getAdvanceOrPaymentMove();
        Move rejectionMove = this.moveService.generateReverse(advanceOrPaymentMove, true, true, false, advanceOrPaymentMove.getDate());
        rejectionMove.setRejectOk(Boolean.valueOf(true));
        moveValidateService.validate(rejectionMove);
        ArrayList moveLineList = new ArrayList();
        moveLineList.addAll(advanceOrPaymentMove.getMoveLineList());
        moveLineList.addAll(rejectionMove.getMoveLineList());
        moveLineService.reconcileMoveLines(moveLineList);
        return rejectionMove;
    }

    @Transactional(rollbackOn={Exception.class})
    protected void cancelInvoicePayments(PaymentScheduleLine paymentScheduleLine) throws AxelorException {
        MoveLineService moveLineService = this.moveService.getMoveLineService();
        PaymentSchedule paymentSchedule = paymentScheduleLine.getPaymentSchedule();
        MoveLine creditMoveLine = paymentScheduleLine.getAdvanceMoveLine();
        Set invoiceSet = (Set)MoreObjects.firstNonNull((Object)paymentSchedule.getInvoiceSet(), Collections.emptySet());
        for (Invoice invoice : invoiceSet) {
            MoveLine debitMoveLine = moveLineService.getDebitCustomerMoveLine(invoice);
            Reconcile reconcile = this.reconcileRepo.findByMoveLines(debitMoveLine, creditMoveLine);
            if (reconcile == null) continue;
            for (InvoicePayment invoicePayment : this.invoicePaymentRepo.findByReconcile(reconcile).fetch()) {
                this.invoicePaymentCancelService.cancel(invoicePayment);
            }
        }
    }

    @Transactional
    protected PaymentScheduleLine representPaymentScheduleLine(PaymentScheduleLine paymentScheduleLine) {
        PaymentSchedule paymentSchedule = paymentScheduleLine.getPaymentSchedule();
        BigDecimal inTaxAmount = paymentScheduleLine.getInTaxAmount();
        int scheduleLineSeq = this.paymentScheduleService.getNextScheduleLineSeq(paymentSchedule);
        LocalDate scheduleDate = paymentScheduleLine.getScheduleDate();
        PaymentScheduleLine representedPaymentScheduleLine = this.createPaymentScheduleLine(paymentSchedule, inTaxAmount, scheduleLineSeq, scheduleDate);
        representedPaymentScheduleLine.setFromReject(Boolean.valueOf(true));
        representedPaymentScheduleLine.setStatusSelect(Integer.valueOf(2));
        return representedPaymentScheduleLine;
    }

    protected void refindPaymentScheduleLines(List<PaymentScheduleLine> paymentScheduleLines, int index) {
        List idList = paymentScheduleLines.subList(Math.max(index, paymentScheduleLines.size()), paymentScheduleLines.size()).stream().map(PaymentScheduleLine::getId).collect(Collectors.toList());
        if (!idList.isEmpty()) {
            List foundPaymentScheduleLines = this.paymentScheduleLineRepo.findByIdList(idList).fetch();
            if (foundPaymentScheduleLines.size() != idList.size()) {
                throw new IllegalStateException(String.format("Expected size: %d, got: %d", idList.size(), foundPaymentScheduleLines.size()));
            }
            for (int i = 0; i < foundPaymentScheduleLines.size(); ++i) {
                paymentScheduleLines.set(index + i, (PaymentScheduleLine)foundPaymentScheduleLines.get(i));
            }
        }
    }

    @Override
    public void reject(long id, InterbankCodeLine rejectionReason, boolean represent) throws AxelorException {
        PaymentScheduleLine paymentScheduleLine = (PaymentScheduleLine)this.paymentScheduleLineRepo.find(Long.valueOf(id));
        this.reject(paymentScheduleLine, rejectionReason, represent);
    }

    @Override
    public int rejectFromIdMap(Map<Long, InterbankCodeLine> idMap, boolean represent) {
        return this.rejectFromMap(idMap, represent, arg_0 -> ((PaymentScheduleLineRepository)this.paymentScheduleLineRepo).find(arg_0));
    }

    @Override
    public int rejectFromNameMap(Map<String, InterbankCodeLine> nameMap, boolean represent) {
        return this.rejectFromMap(nameMap, represent, arg_0 -> ((PaymentScheduleLineRepository)this.paymentScheduleLineRepo).findByName(arg_0));
    }

    protected <T> int rejectFromMap(Map<T, InterbankCodeLine> map, boolean represent, Function<T, PaymentScheduleLine> findFunc) {
        int errorCount = 0;
        for (Map.Entry<T, InterbankCodeLine> entry : map.entrySet()) {
            T key = entry.getKey();
            InterbankCodeLine rejectionReason = entry.getValue();
            PaymentScheduleLine paymentScheduleLine = findFunc.apply(key);
            try {
                this.reject(paymentScheduleLine, rejectionReason, represent);
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)e);
                ++errorCount;
            }
        }
        return errorCount;
    }
}

