/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankorder;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.account.db.Reimbursement;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderLineOrigin;
import com.axelor.apps.bankpayment.db.repo.BankOrderLineOriginRepository;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderLineOriginService;
import com.axelor.db.EntityHelper;
import com.axelor.db.Model;
import com.google.inject.Inject;
import java.time.LocalDate;

public class BankOrderLineOriginServiceImpl
implements BankOrderLineOriginService {
    protected BankOrderLineOriginRepository bankOrderLineOriginRepository;

    @Inject
    public BankOrderLineOriginServiceImpl(BankOrderLineOriginRepository bankOrderLineOriginRepository) {
        this.bankOrderLineOriginRepository = bankOrderLineOriginRepository;
    }

    @Override
    public BankOrderLineOrigin createBankOrderLineOrigin(Model model) {
        Class klass = EntityHelper.getEntityClass((Object)model);
        return this.createBankOrderLineOrigin(klass.getCanonicalName(), model.getId(), this.computeRelatedToSelectName(model), this.computeRelatedToSelectDate(model), this.computeRelatedToSelectDueDate(model));
    }

    protected String computeRelatedToSelectName(Model model) {
        if (model instanceof Invoice) {
            return ((Invoice)model).getInvoiceId();
        }
        if (model instanceof PaymentScheduleLine) {
            return ((PaymentScheduleLine)model).getName();
        }
        if (model instanceof Reimbursement) {
            return ((Reimbursement)model).getRef();
        }
        return null;
    }

    protected LocalDate computeRelatedToSelectDate(Model model) {
        if (model instanceof Invoice) {
            return ((Invoice)model).getInvoiceDate();
        }
        if (model instanceof PaymentScheduleLine) {
            return ((PaymentScheduleLine)model).getScheduleDate();
        }
        if (model instanceof Reimbursement) {
            return null;
        }
        return null;
    }

    protected LocalDate computeRelatedToSelectDueDate(Model model) {
        if (model instanceof Invoice) {
            return ((Invoice)model).getDueDate();
        }
        if (model instanceof PaymentScheduleLine) {
            return ((PaymentScheduleLine)model).getScheduleDate();
        }
        if (model instanceof Reimbursement) {
            return null;
        }
        return null;
    }

    protected BankOrderLineOrigin createBankOrderLineOrigin(String relatedToSelect, Long relatedToSelectId, String relatedToSelectName, LocalDate relatedToSelectDate, LocalDate relatedToSelectDueDate) {
        BankOrderLineOrigin bankOrderLineOrigin = new BankOrderLineOrigin();
        bankOrderLineOrigin.setRelatedToSelect(relatedToSelect);
        bankOrderLineOrigin.setRelatedToSelectId(relatedToSelectId);
        bankOrderLineOrigin.setRelatedToSelectName(relatedToSelectName);
        bankOrderLineOrigin.setRelatedToSelectDate(relatedToSelectDate);
        bankOrderLineOrigin.setRelatedToSelectDueDate(relatedToSelectDueDate);
        return bankOrderLineOrigin;
    }

    @Override
    public boolean existBankOrderLineOrigin(BankOrder bankOrder, Model model) {
        Class klass = EntityHelper.getEntityClass((Object)model);
        Long count = this.bankOrderLineOriginRepository.all().filter("self.relatedToSelect = ?1 AND self.relatedToSelectId = ?2", new Object[]{klass.getCanonicalName(), model.getId()}).count();
        return count != null && count > 0L;
    }
}

