/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankorder;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.db.repo.PaymentScheduleLineRepository;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.db.BankOrderLineOrigin;
import com.axelor.apps.bankpayment.db.repo.BankOrderRepository;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderMergeService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankOrderMergeServiceImpl
implements BankOrderMergeService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected BankOrderRepository bankOrderRepo;
    protected InvoicePaymentRepository invoicePaymentRepo;
    protected BankOrderService bankOrderService;
    protected InvoiceRepository invoiceRepository;
    protected PaymentScheduleLineRepository paymentScheduleLineRepository;

    @Inject
    public BankOrderMergeServiceImpl(BankOrderRepository bankOrderRepo, InvoicePaymentRepository invoicePaymentRepo, BankOrderService bankOrderService, InvoiceRepository invoiceRepository, PaymentScheduleLineRepository paymentScheduleLineRepository) {
        this.bankOrderRepo = bankOrderRepo;
        this.invoicePaymentRepo = invoicePaymentRepo;
        this.bankOrderService = bankOrderService;
        this.invoiceRepository = invoiceRepository;
        this.paymentScheduleLineRepository = paymentScheduleLineRepository;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public BankOrder mergeBankOrders(Collection<BankOrder> bankOrders) throws AxelorException {
        if (bankOrders == null || bankOrders.size() <= 1) {
            throw new AxelorException(5, "Please select at least two bank orders");
        }
        this.checkSameElements(bankOrders);
        BankOrder bankOrder = bankOrders.iterator().next();
        bankOrders.remove((Object)bankOrder);
        bankOrder.setSenderLabel(null);
        bankOrder.setSenderReference(null);
        bankOrder.setBankOrderDate(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate());
        bankOrder.setSignatoryUser(null);
        bankOrder.setSignatoryEbicsUser(null);
        PaymentMode paymentMode = bankOrder.getPaymentMode();
        for (BankOrderLine bankOrderLine : this.getAllBankOrderLineList(bankOrders)) {
            bankOrder.addBankOrderLineListItem(bankOrderLine);
        }
        this.bankOrderRepo.save((Model)((Object)bankOrder));
        for (BankOrder bankOrderToRemove : bankOrders) {
            bankOrderToRemove = (BankOrder)((Object)this.bankOrderRepo.find(bankOrderToRemove.getId()));
            List invoicePaymentList = this.invoicePaymentRepo.findByBankOrder(bankOrderToRemove).fetch();
            for (InvoicePayment invoicePayment : invoicePaymentList) {
                invoicePayment.setBankOrder(bankOrder);
            }
            this.bankOrderRepo.remove((Model)((Object)bankOrderToRemove));
        }
        if (paymentMode.getConsoBankOrderLinePerPartner().booleanValue()) {
            this.consolidatePerPartner(bankOrder);
        }
        this.bankOrderService.updateTotalAmounts(bankOrder);
        return (BankOrder)((Object)this.bankOrderRepo.save((Model)((Object)bankOrder)));
    }

    protected void checkSameElements(Collection<BankOrder> bankOrders) throws AxelorException {
        BankOrder refBankOrder = bankOrders.iterator().next();
        int refStatusSelect = refBankOrder.getStatusSelect();
        int orderTypeSelect = refBankOrder.getOrderTypeSelect();
        PaymentMode refPaymentMode = refBankOrder.getPaymentMode();
        int refPartnerTypeSelect = refBankOrder.getPartnerTypeSelect();
        Company refSenderCompany = refBankOrder.getSenderCompany();
        BankDetails refSenderBankDetails = refBankOrder.getSenderBankDetails();
        Currency refCurrency = refBankOrder.getBankOrderCurrency();
        boolean isMultiCurrency = refBankOrder.getIsMultiCurrency();
        for (BankOrder bankOrder : bankOrders) {
            int statusSelect = bankOrder.getStatusSelect();
            if (statusSelect != 1 && statusSelect != 2) {
                throw new AxelorException((Model)((Object)bankOrder), 5, I18n.get((String)"Please select draft or awaiting signature bank orders only"));
            }
            if (statusSelect != refStatusSelect) {
                throw new AxelorException((Model)((Object)bankOrder), 5, I18n.get((String)"Please select some bank orders that have the same status"));
            }
            if (!bankOrder.getOrderTypeSelect().equals(orderTypeSelect)) {
                throw new AxelorException((Model)((Object)bankOrder), 5, I18n.get((String)"Please select some bank orders that have the same status"));
            }
            if (!bankOrder.getPaymentMode().equals((Object)refPaymentMode)) {
                throw new AxelorException((Model)((Object)bankOrder), 5, I18n.get((String)"Please select some bank orders that have the same payment mode"));
            }
            if (!bankOrder.getPartnerTypeSelect().equals(refPartnerTypeSelect)) {
                throw new AxelorException((Model)((Object)bankOrder), 5, I18n.get((String)"Please select some bank orders that have the same partner type"));
            }
            if (!bankOrder.getSenderCompany().equals((Object)refSenderCompany)) {
                throw new AxelorException((Model)((Object)bankOrder), 5, I18n.get((String)"Please select some bank orders that have the same sender company"));
            }
            if (bankOrder.getSenderBankDetails() == null && refSenderBankDetails != null || bankOrder.getSenderBankDetails() != null && !bankOrder.getSenderBankDetails().equals((Object)refSenderBankDetails)) {
                throw new AxelorException((Model)((Object)bankOrder), 5, I18n.get((String)"Please select some bank orders that have the same sender bank details"));
            }
            if (bankOrder.getIsMultiCurrency() == isMultiCurrency && (bankOrder.getIsMultiCurrency().booleanValue() || bankOrder.getBankOrderCurrency().equals((Object)refCurrency))) continue;
            throw new AxelorException((Model)((Object)bankOrder), 5, I18n.get((String)"Please select some bank orders that have the same currency"));
        }
    }

    protected List<BankOrderLine> getAllBankOrderLineList(Collection<BankOrder> bankOrders) {
        ArrayList bankOrderLineList = Lists.newArrayList();
        for (BankOrder bankOrder : bankOrders) {
            bankOrderLineList.addAll(bankOrder.getBankOrderLineList());
        }
        return bankOrderLineList;
    }

    public void consolidatePerPartner(BankOrder bankOrder) {
        HashMap bankOrderLineMap = new HashMap();
        int counter = 1;
        for (BankOrderLine bankOrderLine : bankOrder.getBankOrderLineList()) {
            ArrayList<Object> keys = new ArrayList<Object>();
            keys.add((Object)bankOrderLine.getPartner());
            keys.add(bankOrderLine.getBankOrderCurrency());
            keys.add(bankOrderLine.getBankOrderDate());
            keys.add((Object)bankOrderLine.getBankOrderEconomicReason());
            keys.add(bankOrderLine.getFeesImputationModeSelect());
            keys.add(bankOrderLine.getPaymentModeSelect());
            keys.add((Object)bankOrderLine.getReceiverBankDetails());
            keys.add((Object)bankOrderLine.getReceiverCompany());
            if (bankOrderLineMap.containsKey(keys)) {
                BankOrderLine consolidateBankOrderLine = (BankOrderLine)((Object)bankOrderLineMap.get(keys));
                if (consolidateBankOrderLine.getBankOrderLineOriginList() == null) {
                    consolidateBankOrderLine.setBankOrderLineOriginList(new ArrayList<BankOrderLineOrigin>());
                }
                if (bankOrderLine.getBankOrderLineOriginList() != null) {
                    bankOrderLine.getBankOrderLineOriginList().stream().forEach(consolidateBankOrderLine::addBankOrderLineOriginListItem);
                }
                consolidateBankOrderLine.setBankOrderAmount(consolidateBankOrderLine.getBankOrderAmount().add(bankOrderLine.getBankOrderAmount()));
                consolidateBankOrderLine.setCompanyCurrencyAmount(consolidateBankOrderLine.getCompanyCurrencyAmount().add(bankOrderLine.getCompanyCurrencyAmount()));
                continue;
            }
            bankOrderLine.setCounter(counter++);
            bankOrderLineMap.put(keys, bankOrderLine);
        }
        bankOrder.getBankOrderLineList().clear();
        for (BankOrderLine bankOrderLine : bankOrderLineMap.values()) {
            Pair<String, LocalDate> lastReferences = this.getLastReferences(bankOrderLine);
            bankOrderLine.setReceiverReference((String)lastReferences.getLeft());
            bankOrderLine.setBankOrderDate((LocalDate)lastReferences.getRight());
            bankOrder.addBankOrderLineListItem(bankOrderLine);
        }
    }

    protected Pair<String, LocalDate> getLastReferences(BankOrderLine bankOrderLine) {
        String lastReferenceId = "";
        LocalDate lastReferenceDate = null;
        for (BankOrderLineOrigin bankOrderLineOrigin : bankOrderLine.getBankOrderLineOriginList()) {
            LocalDate originDate = null;
            String originReferenceId = null;
            switch (bankOrderLineOrigin.getRelatedToSelect()) {
                case "com.axelor.apps.account.db.Invoice": {
                    Invoice invoice = (Invoice)this.invoiceRepository.find(bankOrderLineOrigin.getRelatedToSelectId());
                    originReferenceId = !Strings.isNullOrEmpty((String)invoice.getSupplierInvoiceNb()) ? invoice.getSupplierInvoiceNb() : invoice.getInvoiceId();
                    if (!Strings.isNullOrEmpty((String)invoice.getSupplierInvoiceNb())) {
                        originDate = invoice.getOriginDate();
                        break;
                    }
                    originDate = invoice.getInvoiceDate();
                    break;
                }
                case "com.axelor.apps.account.db.PaymentScheduleLine": {
                    PaymentScheduleLine paymentScheduleLine = (PaymentScheduleLine)this.paymentScheduleLineRepository.find(bankOrderLineOrigin.getRelatedToSelectId());
                    originReferenceId = paymentScheduleLine.getName();
                    originDate = paymentScheduleLine.getScheduleDate();
                    break;
                }
            }
            if (originDate == null || lastReferenceDate != null && !lastReferenceDate.isBefore(originDate)) continue;
            lastReferenceDate = originDate;
            lastReferenceId = originReferenceId;
        }
        return Pair.of((Object)lastReferenceId, lastReferenceDate);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public BankOrder mergeFromInvoicePayments(Collection<InvoicePayment> invoicePayments) throws AxelorException {
        if (invoicePayments == null || invoicePayments.isEmpty()) {
            throw new AxelorException(5, I18n.get((String)"No bank orders found"));
        }
        ArrayList<InvoicePayment> invoicePaymentsWithBankOrders = new ArrayList<InvoicePayment>();
        LinkedHashSet<BankOrder> bankOrders = new LinkedHashSet<BankOrder>();
        for (InvoicePayment invoicePayment : invoicePayments) {
            BankOrder bankOrder = invoicePayment.getBankOrder();
            if (bankOrder == null) continue;
            invoicePaymentsWithBankOrders.add(invoicePayment);
            bankOrders.add(bankOrder);
        }
        if (bankOrders.size() > 1) {
            LocalDate bankOrderDate = ((BankOrder)((Object)bankOrders.iterator().next())).getBankOrderDate();
            BankOrder mergedBankOrder = this.mergeBankOrders(bankOrders);
            mergedBankOrder.setBankOrderDate(bankOrderDate);
            for (InvoicePayment invoicePayment : invoicePaymentsWithBankOrders) {
                invoicePayment.setBankOrder(mergedBankOrder);
            }
            return mergedBankOrder;
        }
        if (!bankOrders.isEmpty()) {
            return (BankOrder)((Object)bankOrders.iterator().next());
        }
        throw new AxelorException(5, I18n.get((String)"No bank orders found"));
    }
}

