/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankorder;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderMoveService;
import com.axelor.apps.bankpayment.service.config.BankPaymentConfigService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.common.ObjectUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankOrderMoveServiceImpl
implements BankOrderMoveService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected MoveService moveService;
    protected PaymentModeService paymentModeService;
    protected AccountingSituationService accountingSituationService;
    protected BankPaymentConfigService bankPaymentConfigService;
    protected PaymentMode paymentMode;
    protected Company senderCompany;
    protected int orderTypeSelect;
    protected int partnerTypeSelect;
    protected Journal journal;
    protected Account senderBankAccount;
    protected BankDetails senderBankDetails;
    protected boolean isMultiDate;
    protected boolean isMultiCurrency;
    protected boolean isDebit;

    @Inject
    public BankOrderMoveServiceImpl(MoveService moveService, PaymentModeService paymentModeService, AccountingSituationService accountingSituationService, BankPaymentConfigService bankPaymentConfigService) {
        this.moveService = moveService;
        this.paymentModeService = paymentModeService;
        this.accountingSituationService = accountingSituationService;
        this.bankPaymentConfigService = bankPaymentConfigService;
    }

    @Override
    public void generateMoves(BankOrder bankOrder) throws AxelorException {
        if (bankOrder.getBankOrderLineList() == null || bankOrder.getBankOrderLineList().isEmpty()) {
            return;
        }
        this.paymentMode = bankOrder.getPaymentMode();
        if (this.paymentMode == null || !this.paymentMode.getGenerateMoveAutoFromBankOrder().booleanValue()) {
            return;
        }
        this.orderTypeSelect = bankOrder.getOrderTypeSelect();
        this.senderCompany = bankOrder.getSenderCompany();
        this.senderBankDetails = bankOrder.getSenderBankDetails();
        this.partnerTypeSelect = bankOrder.getPartnerTypeSelect();
        this.journal = this.paymentModeService.getPaymentModeJournal(this.paymentMode, this.senderCompany, this.senderBankDetails);
        this.senderBankAccount = this.paymentModeService.getPaymentModeAccount(this.paymentMode, this.senderCompany, this.senderBankDetails);
        this.isMultiDate = bankOrder.getIsMultiDate();
        this.isMultiCurrency = bankOrder.getIsMultiCurrency();
        this.isDebit = this.orderTypeSelect == 3 || this.orderTypeSelect == 1;
        for (BankOrderLine bankOrderLine : bankOrder.getBankOrderLineList()) {
            if (!ObjectUtils.isEmpty(bankOrderLine.getBankOrderLineOriginList())) continue;
            this.generateMoves(bankOrderLine);
        }
    }

    protected void generateMoves(BankOrderLine bankOrderLine) throws AxelorException {
        if (bankOrderLine.getSenderMove() == null) {
            bankOrderLine.setSenderMove(this.generateSenderMove(bankOrderLine));
        }
        if (this.partnerTypeSelect == 4 && bankOrderLine.getReceiverMove() == null) {
            bankOrderLine.setReceiverMove(this.generateReceiverMove(bankOrderLine));
        }
    }

    protected Move generateSenderMove(BankOrderLine bankOrderLine) throws AxelorException {
        Partner partner = bankOrderLine.getPartner();
        Move senderMove = this.moveService.getMoveCreateService().createMove(this.journal, this.senderCompany, this.getCurrency(bankOrderLine), partner, this.getDate(bankOrderLine), this.paymentMode, 2);
        MoveLine bankMoveLine = this.moveService.getMoveLineService().createMoveLine(senderMove, partner, this.senderBankAccount, bankOrderLine.getBankOrderAmount(), !this.isDebit, senderMove.getDate(), 1, bankOrderLine.getReceiverReference(), bankOrderLine.getReceiverLabel());
        senderMove.addMoveLineListItem(bankMoveLine);
        MoveLine partnerMoveLine = this.moveService.getMoveLineService().createMoveLine(senderMove, partner, this.getPartnerAccount(partner, this.senderCompany, this.senderCompany), bankOrderLine.getBankOrderAmount(), this.isDebit, senderMove.getDate(), 2, bankOrderLine.getReceiverReference(), bankOrderLine.getReceiverLabel());
        senderMove.addMoveLineListItem(partnerMoveLine);
        return senderMove;
    }

    protected Move generateReceiverMove(BankOrderLine bankOrderLine) throws AxelorException {
        Partner partner = bankOrderLine.getPartner();
        Company receiverCompany = bankOrderLine.getReceiverCompany();
        BankDetails receiverBankDetails = bankOrderLine.getReceiverBankDetails();
        Journal receiverJournal = this.paymentModeService.getPaymentModeJournal(this.paymentMode, receiverCompany, receiverBankDetails);
        Account receiverBankAccount = this.paymentModeService.getPaymentModeAccount(this.paymentMode, receiverCompany, receiverBankDetails);
        Move receiverMove = this.moveService.getMoveCreateService().createMove(receiverJournal, receiverCompany, this.getCurrency(bankOrderLine), partner, this.getDate(bankOrderLine), this.paymentMode, 2);
        MoveLine bankMoveLine = this.moveService.getMoveLineService().createMoveLine(receiverMove, partner, receiverBankAccount, bankOrderLine.getBankOrderAmount(), this.isDebit, receiverMove.getDate(), 1, bankOrderLine.getReceiverReference(), bankOrderLine.getReceiverLabel());
        receiverMove.addMoveLineListItem(bankMoveLine);
        MoveLine partnerMoveLine = this.moveService.getMoveLineService().createMoveLine(receiverMove, partner, this.getPartnerAccount(partner, receiverCompany, receiverMove.getCompany()), bankOrderLine.getBankOrderAmount(), !this.isDebit, receiverMove.getDate(), 2, bankOrderLine.getReceiverReference(), bankOrderLine.getReceiverLabel());
        receiverMove.addMoveLineListItem(partnerMoveLine);
        return receiverMove;
    }

    protected Account getPartnerAccount(Partner partner, Company receiverCompany, Company moveCompany) throws AxelorException {
        AccountingSituation accountingSituation = this.accountingSituationService.getAccountingSituation(partner, receiverCompany);
        switch (this.partnerTypeSelect) {
            case 3: {
                return this.accountingSituationService.getCustomerAccount(partner, receiverCompany);
            }
            case 2: {
                return this.accountingSituationService.getEmployeeAccount(partner, receiverCompany);
            }
            case 1: {
                return this.accountingSituationService.getSupplierAccount(partner, receiverCompany);
            }
            case 4: {
                if (receiverCompany.equals((Object)this.senderCompany)) {
                    return this.bankPaymentConfigService.getInternalBankToBankAccount(this.bankPaymentConfigService.getBankPaymentConfig(moveCompany));
                }
                return this.bankPaymentConfigService.getExternalBankToBankAccount(this.bankPaymentConfigService.getBankPaymentConfig(moveCompany));
            }
        }
        throw new AxelorException((Model)accountingSituation, 4, I18n.get((String)"Please fill partner type for the bank order"), new Object[]{I18n.get((String)"Warning !")});
    }

    protected LocalDate getDate(BankOrderLine bankOrderLine) {
        if (this.isMultiDate) {
            return bankOrderLine.getBankOrderDate();
        }
        return bankOrderLine.getBankOrder().getBankOrderDate();
    }

    protected Currency getCurrency(BankOrderLine bankOrderLine) {
        if (this.isMultiCurrency) {
            return bankOrderLine.getBankOrderCurrency();
        }
        return bankOrderLine.getBankOrder().getBankOrderCurrency();
    }
}

