/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankorder;

import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCancelService;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderFileFormat;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.db.BankPaymentConfig;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.db.repo.BankOrderRepository;
import com.axelor.apps.bankpayment.db.repo.EbicsPartnerRepository;
import com.axelor.apps.bankpayment.ebics.service.EbicsService;
import com.axelor.apps.bankpayment.service.app.AppBankPaymentService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderLineOriginService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderLineService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderMoveService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderService;
import com.axelor.apps.bankpayment.service.bankorder.file.directdebit.BankOrderFile00800101Service;
import com.axelor.apps.bankpayment.service.bankorder.file.directdebit.BankOrderFile00800102Service;
import com.axelor.apps.bankpayment.service.bankorder.file.transfer.BankOrderFile00100102Service;
import com.axelor.apps.bankpayment.service.bankorder.file.transfer.BankOrderFile00100103Service;
import com.axelor.apps.bankpayment.service.bankorder.file.transfer.BankOrderFileAFB160ICTService;
import com.axelor.apps.bankpayment.service.bankorder.file.transfer.BankOrderFileAFB320XCTService;
import com.axelor.apps.bankpayment.service.config.BankPaymentConfigService;
import com.axelor.apps.bankpayment.service.invoice.payment.InvoicePaymentValidateServiceBankPayImpl;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.base.service.BankDetailsService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.auth.db.User;
import com.axelor.common.ObjectUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.mail.db.repo.MailFollowerRepository;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.schema.actions.ActionView;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankOrderServiceImpl
implements BankOrderService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected BankOrderRepository bankOrderRepo;
    protected InvoicePaymentRepository invoicePaymentRepo;
    protected BankOrderLineService bankOrderLineService;
    protected EbicsService ebicsService;
    protected InvoicePaymentCancelService invoicePaymentCancelService;
    protected BankPaymentConfigService bankPaymentConfigService;
    protected SequenceService sequenceService;
    protected BankOrderLineOriginService bankOrderLineOriginService;
    protected BankOrderMoveService bankOrderMoveService;

    @Inject
    public BankOrderServiceImpl(BankOrderRepository bankOrderRepo, InvoicePaymentRepository invoicePaymentRepo, BankOrderLineService bankOrderLineService, EbicsService ebicsService, InvoicePaymentCancelService invoicePaymentCancelService, BankPaymentConfigService bankPaymentConfigService, SequenceService sequenceService, BankOrderLineOriginService bankOrderLineOriginService, BankOrderMoveService bankOrderMoveService) {
        this.bankOrderRepo = bankOrderRepo;
        this.invoicePaymentRepo = invoicePaymentRepo;
        this.bankOrderLineService = bankOrderLineService;
        this.ebicsService = ebicsService;
        this.invoicePaymentCancelService = invoicePaymentCancelService;
        this.bankPaymentConfigService = bankPaymentConfigService;
        this.sequenceService = sequenceService;
        this.bankOrderLineOriginService = bankOrderLineOriginService;
        this.bankOrderMoveService = bankOrderMoveService;
    }

    public void checkPreconditions(BankOrder bankOrder) throws AxelorException {
        LocalDate brankOrderDate = bankOrder.getBankOrderDate();
        if (brankOrderDate != null) {
            if (brankOrderDate.isBefore(LocalDate.now())) {
                throw new AxelorException(5, I18n.get((String)"Bank Order date can't be in the past"));
            }
        } else {
            throw new AxelorException(5, I18n.get((String)"Please fill bank order date"));
        }
        if (bankOrder.getOrderTypeSelect() == 0) {
            throw new AxelorException(5, I18n.get((String)"Please fill bank order type"));
        }
        if (bankOrder.getPartnerTypeSelect() == 0) {
            throw new AxelorException(5, I18n.get((String)"Please fill partner type for the bank order"));
        }
        if (bankOrder.getPaymentMode() == null) {
            throw new AxelorException(5, I18n.get((String)"Please select a payment mode"));
        }
        if (bankOrder.getSenderCompany() == null) {
            throw new AxelorException(5, I18n.get((String)"Please fill the sender company"));
        }
        if (bankOrder.getSenderBankDetails() == null) {
            throw new AxelorException(5, I18n.get((String)"Please fill the bank details"));
        }
        if (!bankOrder.getIsMultiCurrency().booleanValue() && bankOrder.getBankOrderCurrency() == null) {
            throw new AxelorException(5, I18n.get((String)"Please fill currency for the bank order"));
        }
        if (bankOrder.getSignatoryUser() == null) {
            throw new AxelorException(5, I18n.get((String)"Please select a signatory"));
        }
    }

    @Override
    public BigDecimal computeBankOrderTotalAmount(BankOrder bankOrder) throws AxelorException {
        BigDecimal bankOrderTotalAmount = BigDecimal.ZERO;
        List<BankOrderLine> bankOrderLines = bankOrder.getBankOrderLineList();
        if (bankOrderLines != null) {
            for (BankOrderLine bankOrderLine : bankOrderLines) {
                BigDecimal amount = bankOrderLine.getBankOrderAmount();
                if (amount == null) continue;
                bankOrderTotalAmount = bankOrderTotalAmount.add(amount);
            }
        }
        return bankOrderTotalAmount;
    }

    @Override
    public BigDecimal computeCompanyCurrencyTotalAmount(BankOrder bankOrder) throws AxelorException {
        BigDecimal companyCurrencyTotalAmount = BigDecimal.ZERO;
        List<BankOrderLine> bankOrderLines = bankOrder.getBankOrderLineList();
        if (bankOrderLines != null) {
            for (BankOrderLine bankOrderLine : bankOrderLines) {
                BigDecimal amount = bankOrderLine.getCompanyCurrencyAmount();
                if (amount == null) continue;
                companyCurrencyTotalAmount = companyCurrencyTotalAmount.add(amount);
            }
        }
        return companyCurrencyTotalAmount;
    }

    @Override
    public void updateTotalAmounts(BankOrder bankOrder) throws AxelorException {
        if (bankOrder.getOrderTypeSelect().equals(7)) {
            bankOrder.setArithmeticTotal(bankOrder.getBankOrderTotalAmount());
        } else {
            bankOrder.setArithmeticTotal(this.computeBankOrderTotalAmount(bankOrder));
        }
        if (!bankOrder.getIsMultiCurrency().booleanValue()) {
            bankOrder.setBankOrderTotalAmount(bankOrder.getArithmeticTotal());
        }
        bankOrder.setCompanyCurrencyTotalAmount(this.computeCompanyCurrencyTotalAmount(bankOrder));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public BankOrder generateSequence(BankOrder bankOrder) throws AxelorException {
        if (bankOrder.getBankOrderSeq() == null) {
            Sequence sequence = this.getSequence(bankOrder);
            this.setBankOrderSeq(bankOrder, sequence);
            this.bankOrderRepo.save((Model)((Object)bankOrder));
        }
        return bankOrder;
    }

    @Override
    public void checkLines(BankOrder bankOrder) throws AxelorException {
        List<BankOrderLine> bankOrderLines = bankOrder.getBankOrderLineList();
        if (bankOrderLines.isEmpty()) {
            throw new AxelorException((Model)((Object)bankOrder), 5, I18n.get((String)"You can't validate this bank order. you need to fill at least one bank order line"));
        }
        this.validateBankOrderLines(bankOrderLines, bankOrder.getOrderTypeSelect(), bankOrder.getArithmeticTotal());
    }

    public void validateBankOrderLines(List<BankOrderLine> bankOrderLines, int orderType, BigDecimal arithmeticTotal) throws AxelorException {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (BankOrderLine bankOrderLine : bankOrderLines) {
            this.bankOrderLineService.checkPreconditions(bankOrderLine);
            totalAmount = totalAmount.add(bankOrderLine.getBankOrderAmount());
            this.bankOrderLineService.checkBankDetails(bankOrderLine.getReceiverBankDetails(), bankOrderLine.getBankOrder());
        }
        if (!totalAmount.equals(arithmeticTotal)) {
            throw new AxelorException(5, I18n.get((String)"Total amount of bank order lines must be equal to the bank order amount"));
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validatePayment(BankOrder bankOrder) throws AxelorException {
        List invoicePaymentList = this.invoicePaymentRepo.findByBankOrder(bankOrder).fetch();
        InvoicePaymentValidateServiceBankPayImpl invoicePaymentValidateServiceBankPayImpl = (InvoicePaymentValidateServiceBankPayImpl)((Object)Beans.get(InvoicePaymentValidateServiceBankPayImpl.class));
        for (InvoicePayment invoicePayment : invoicePaymentList) {
            if (invoicePayment == null || invoicePayment.getStatusSelect() == 1 || invoicePayment.getInvoice() == null || !this.bankOrderLineOriginService.existBankOrderLineOrigin(bankOrder, (Model)invoicePayment.getInvoice())) continue;
            invoicePaymentValidateServiceBankPayImpl.validateFromBankOrder(invoicePayment, true);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void cancelPayment(BankOrder bankOrder) throws AxelorException {
        List invoicePaymentList = this.invoicePaymentRepo.findByBankOrder(bankOrder).fetch();
        for (InvoicePayment invoicePayment : invoicePaymentList) {
            if (invoicePayment == null || invoicePayment.getStatusSelect() == 2) continue;
            this.invoicePaymentCancelService.cancel(invoicePayment);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void confirm(BankOrder bankOrder) throws AxelorException, JAXBException, IOException, DatatypeConfigurationException {
        this.checkBankDetails(bankOrder.getSenderBankDetails(), bankOrder);
        if (bankOrder.getGeneratedMetaFile() == null) {
            this.checkLines(bankOrder);
        }
        this.setNbOfLines(bankOrder);
        this.setSequenceOnBankOrderLines(bankOrder);
        this.generateFile(bankOrder);
        if (((AppBankPaymentService)Beans.get(AppBankPaymentService.class)).getAppBankPayment().getEnableEbicsModule().booleanValue()) {
            bankOrder.setConfirmationDateTime(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime());
            bankOrder.setStatusSelect(2);
            this.makeEbicsUserFollow(bankOrder);
            this.bankOrderRepo.save((Model)((Object)bankOrder));
        } else {
            this.validate(bankOrder);
        }
    }

    @Override
    @Transactional
    public void sign(BankOrder bankOrder) {
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validate(BankOrder bankOrder) throws AxelorException {
        bankOrder.setValidationDateTime(LocalDateTime.now());
        bankOrder.setStatusSelect(3);
        if (this.bankPaymentConfigService.getBankPaymentConfig(bankOrder.getSenderCompany()).getGenerateMoveOnBankOrderValidation().booleanValue()) {
            this.bankOrderMoveService.generateMoves(bankOrder);
            this.validatePayment(bankOrder);
        }
        this.bankOrderRepo.save((Model)((Object)bankOrder));
    }

    @Override
    public void realize(BankOrder bankOrder) throws AxelorException {
        if (((AppBankPaymentService)Beans.get(AppBankPaymentService.class)).getAppBankPayment().getEnableEbicsModule().booleanValue()) {
            if (bankOrder.getSignatoryEbicsUser() == null) {
                throw new AxelorException((Model)((Object)bankOrder), 1, I18n.get((String)"Signatory EBICS user is missing."));
            }
            if (bankOrder.getSignatoryEbicsUser().getEbicsPartner().getTransportEbicsUser() == null) {
                throw new AxelorException((Model)((Object)bankOrder.getSignatoryEbicsUser().getEbicsPartner()), 1, I18n.get((String)"Please insert a EBICS user for transport in the EBICS partner"));
            }
            this.sendBankOrderFile(bankOrder);
        }
        this.realizeBankOrder(bankOrder);
    }

    protected void sendBankOrderFile(BankOrder bankOrder) throws AxelorException {
        File dataFileToSend = null;
        File signatureFileToSend = null;
        if (bankOrder.getSignatoryEbicsUser().getEbicsPartner().getEbicsTypeSelect() == 1) {
            if (bankOrder.getSignedMetaFile() == null) {
                throw new AxelorException(I18n.get((String)"The bank order is not properly signed. Please correct it and sign it again."), 3, new Object[0]);
            }
            signatureFileToSend = MetaFiles.getPath((MetaFile)bankOrder.getSignedMetaFile()).toFile();
        }
        dataFileToSend = MetaFiles.getPath((MetaFile)bankOrder.getGeneratedMetaFile()).toFile();
        this.sendFile(bankOrder, dataFileToSend, signatureFileToSend);
    }

    @Transactional(rollbackOn={Exception.class})
    protected void realizeBankOrder(BankOrder bankOrder) throws AxelorException {
        AppBaseService appBaseService = (AppBaseService)Beans.get(AppBaseService.class);
        if (!this.bankPaymentConfigService.getBankPaymentConfig(bankOrder.getSenderCompany()).getGenerateMoveOnBankOrderValidation().booleanValue()) {
            this.bankOrderMoveService.generateMoves(bankOrder);
            this.validatePayment(bankOrder);
        }
        bankOrder.setSendingDateTime(appBaseService.getTodayDateTime().toLocalDateTime());
        bankOrder.setStatusSelect(4);
        if (((AppBankPaymentService)Beans.get(AppBankPaymentService.class)).getAppBankPayment().getEnableEbicsModule().booleanValue()) {
            bankOrder.setTestMode(bankOrder.getSignatoryEbicsUser().getEbicsPartner().getTestMode());
        }
        this.bankOrderRepo.save((Model)((Object)bankOrder));
    }

    protected void sendFile(BankOrder bankOrder, File dataFileToSend, File signatureFileToSend) throws AxelorException {
        PaymentMode paymentMode = bankOrder.getPaymentMode();
        if (paymentMode != null && !paymentMode.getAutomaticTransmission().booleanValue()) {
            return;
        }
        EbicsUser signatoryEbicsUser = bankOrder.getSignatoryEbicsUser();
        this.ebicsService.sendFULRequest(signatoryEbicsUser.getEbicsPartner().getTransportEbicsUser(), signatoryEbicsUser, null, dataFileToSend, bankOrder.getBankOrderFileFormat(), signatureFileToSend);
    }

    @Override
    public void setSequenceOnBankOrderLines(BankOrder bankOrder) {
        if (bankOrder.getBankOrderLineList() == null) {
            return;
        }
        String bankOrderSeq = bankOrder.getBankOrderSeq();
        int counter = 1;
        for (BankOrderLine bankOrderLine : bankOrder.getBankOrderLineList()) {
            bankOrderLine.setCounter(counter);
            bankOrderLine.setSequence(bankOrderSeq + "-" + Integer.toString(counter++));
        }
    }

    private void setNbOfLines(BankOrder bankOrder) {
        if (bankOrder.getBankOrderLineList() == null) {
            return;
        }
        bankOrder.setNbOfLines(bankOrder.getBankOrderLineList().size());
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void cancelBankOrder(BankOrder bankOrder) throws AxelorException {
        bankOrder.setStatusSelect(6);
        this.cancelPayment(bankOrder);
        this.bankOrderRepo.save((Model)((Object)bankOrder));
    }

    @Override
    @Transactional
    public EbicsUser getDefaultEbicsUserFromBankDetails(BankDetails bankDetails) {
        EbicsPartner ebicsPartner = (EbicsPartner)((Object)((EbicsPartnerRepository)((Object)Beans.get(EbicsPartnerRepository.class))).all().filter("? MEMBER OF self.bankDetailsSet", new Object[]{bankDetails}).fetchOne());
        if (ebicsPartner != null) {
            return ebicsPartner.getDefaultSignatoryEbicsUser();
        }
        return null;
    }

    @Override
    public String createDomainForBankDetails(BankOrder bankOrder) {
        Currency currency;
        String acceptedIdentifiers;
        String domain = ((BankDetailsService)Beans.get(BankDetailsService.class)).getActiveCompanyBankDetails(bankOrder.getSenderCompany());
        if (bankOrder.getBankOrderFileFormat() != null && (acceptedIdentifiers = bankOrder.getBankOrderFileFormat().getBankDetailsTypeSelect()) != null && !acceptedIdentifiers.equals("")) {
            domain = domain + " AND self.bank.bankDetailsTypeSelect IN (" + acceptedIdentifiers + ")";
        }
        if ((currency = bankOrder.getBankOrderCurrency()) != null && !bankOrder.getBankOrderFileFormat().getAllowOrderCurrDiffFromBankDetails().booleanValue()) {
            String fileFormatCurrencyId = currency.getId().toString();
            domain = domain + " AND (self.currency IS NULL OR self.currency.id = " + fileFormatCurrencyId + ")";
        }
        return domain;
    }

    @Override
    public BankDetails getDefaultBankDetails(BankOrder bankOrder) {
        if (bankOrder.getSenderCompany() == null) {
            return null;
        }
        BankDetails candidateBankDetails = bankOrder.getSenderCompany().getDefaultBankDetails();
        try {
            this.checkBankDetails(candidateBankDetails, bankOrder);
        }
        catch (AxelorException e) {
            return null;
        }
        return candidateBankDetails;
    }

    @Override
    public void checkBankDetails(BankDetails bankDetails, BankOrder bankOrder) throws AxelorException {
        if (bankDetails == null) {
            throw new AxelorException((Model)((Object)bankOrder), 5, I18n.get((String)"Please fill the bank details"));
        }
        if (!bankDetails.getActive().booleanValue()) {
            throw new AxelorException((Model)((Object)bankOrder), 5, I18n.get((String)"The bank details is inactive."));
        }
        if (bankOrder.getBankOrderFileFormat() != null) {
            if (!this.checkBankDetailsTypeCompatible(bankDetails, bankOrder.getBankOrderFileFormat())) {
                throw new AxelorException((Model)((Object)bankOrder), 5, I18n.get((String)"The bank details type is not compatible with the accepted types in file format."));
            }
            if (!bankOrder.getBankOrderFileFormat().getAllowOrderCurrDiffFromBankDetails().booleanValue() && !this.checkBankDetailsCurrencyCompatible(bankDetails, bankOrder)) {
                throw new AxelorException((Model)((Object)bankOrder), 5, I18n.get((String)"The sender bank details currency is not compatible with the currency in bank order."));
            }
        }
        if (bankOrder.getBankOrderFileFormat() != null && bankOrder.getBankOrderFileFormat().getAllowOrderCurrDiffFromBankDetails().booleanValue() && bankDetails.getCurrency() == null) {
            throw new AxelorException(I18n.get((String)"Please fill the sender bank details currency."), 1, new Object[0]);
        }
    }

    @Override
    public boolean checkBankDetailsTypeCompatible(BankDetails bankDetails, BankOrderFileFormat bankOrderFileFormat) {
        String acceptedIdentifiers = bankOrderFileFormat.getBankDetailsTypeSelect();
        if (acceptedIdentifiers != null && !acceptedIdentifiers.equals("")) {
            int i;
            String[] identifiers = acceptedIdentifiers.replaceAll("\\s", "").split(",");
            for (i = 0; i < identifiers.length && bankDetails.getBank().getBankDetailsTypeSelect() != Integer.parseInt(identifiers[i]); ++i) {
            }
            if (i == identifiers.length) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkBankDetailsCurrencyCompatible(BankDetails bankDetails, BankOrder bankOrder) {
        return bankOrder.getBankOrderCurrency() == null || bankDetails.getCurrency() == null || bankDetails.getCurrency() == bankOrder.getBankOrderCurrency();
    }

    @Override
    public File generateFile(BankOrder bankOrder) throws JAXBException, IOException, AxelorException, DatatypeConfigurationException {
        if (bankOrder.getBankOrderLineList() == null || bankOrder.getBankOrderLineList().isEmpty()) {
            return null;
        }
        bankOrder.setFileGenerationDateTime(LocalDateTime.now());
        BankOrderFileFormat bankOrderFileFormat = bankOrder.getBankOrderFileFormat();
        File file = null;
        switch (bankOrderFileFormat.getOrderFileFormatSelect()) {
            case "pain.001.001.02.sct": {
                file = new BankOrderFile00100102Service(bankOrder).generateFile();
                break;
            }
            case "pain.001.001.03.sct": {
                file = new BankOrderFile00100103Service(bankOrder).generateFile();
                break;
            }
            case "pain.xxx.cfonb320.xct": {
                file = new BankOrderFileAFB320XCTService(bankOrder).generateFile();
                break;
            }
            case "pain.xxx.cfonb160.ict": {
                file = new BankOrderFileAFB160ICTService(bankOrder).generateFile();
                break;
            }
            case "pain.008.001.01.sdd": {
                file = new BankOrderFile00800101Service(bankOrder, "CORE").generateFile();
                break;
            }
            case "pain.008.001.01.sbb": {
                file = new BankOrderFile00800101Service(bankOrder, "SBB").generateFile();
                break;
            }
            case "pain.008.001.02.sdd": {
                file = new BankOrderFile00800102Service(bankOrder, "CORE").generateFile();
                break;
            }
            case "pain.008.001.02.sbb": {
                file = new BankOrderFile00800102Service(bankOrder, "SBB").generateFile();
                break;
            }
            default: {
                throw new AxelorException((Model)((Object)bankOrder), 5, I18n.get((String)"Unknown format for file generation"));
            }
        }
        if (file == null) {
            throw new AxelorException((Model)((Object)bankOrder), 5, I18n.get((String)"Anomaly has been detected during file generation for bank order %s"), new Object[]{bankOrder.getBankOrderSeq()});
        }
        MetaFiles metaFiles = (MetaFiles)Beans.get(MetaFiles.class);
        try (FileInputStream is = new FileInputStream(file);){
            metaFiles.attach((InputStream)is, file.getName(), (Model)((Object)bankOrder));
            bankOrder.setGeneratedMetaFile(metaFiles.upload(file));
        }
        return file;
    }

    protected Sequence getSequence(BankOrder bankOrder) throws AxelorException {
        BankPaymentConfig bankPaymentConfig = ((BankPaymentConfigService)Beans.get(BankPaymentConfigService.class)).getBankPaymentConfig(bankOrder.getSenderCompany());
        switch (bankOrder.getOrderTypeSelect()) {
            case 2: {
                return this.bankPaymentConfigService.getSepaDirectDebitSequence(bankPaymentConfig);
            }
            case 1: {
                return this.bankPaymentConfigService.getSepaCreditTransSequence(bankPaymentConfig);
            }
            case 4: {
                return this.bankPaymentConfigService.getIntDirectDebitSequence(bankPaymentConfig);
            }
            case 3: {
                return this.bankPaymentConfigService.getIntCreditTransSequence(bankPaymentConfig);
            }
            case 5: {
                return this.bankPaymentConfigService.getNatTreasuryTransSequence(bankPaymentConfig);
            }
            case 6: {
                return this.bankPaymentConfigService.getIntTreasuryTransSequence(bankPaymentConfig);
            }
        }
        return this.bankPaymentConfigService.getOtherBankOrderSequence(bankPaymentConfig);
    }

    protected void setBankOrderSeq(BankOrder bankOrder, Sequence sequence) throws AxelorException {
        bankOrder.setBankOrderSeq(this.sequenceService.getSequenceNumber(sequence, bankOrder.getBankOrderDate()));
        if (bankOrder.getBankOrderSeq() != null) {
            return;
        }
        throw new AxelorException((Model)((Object)bankOrder), 4, I18n.get((String)"The company %s does not have bank order sequence"), new Object[]{bankOrder.getSenderCompany().getName()});
    }

    protected void makeEbicsUserFollow(BankOrder bankOrder) {
        EbicsUser ebicsUser = bankOrder.getSignatoryEbicsUser();
        if (ebicsUser != null) {
            User signatoryUser = ebicsUser.getAssociatedUser();
            ((MailFollowerRepository)Beans.get(MailFollowerRepository.class)).follow((Model)((Object)bankOrder), signatoryUser);
        }
    }

    @Override
    public void resetReceivers(BankOrder bankOrder) {
        if (ObjectUtils.isEmpty(bankOrder.getBankOrderLineList())) {
            return;
        }
        this.resetPartners(bankOrder);
        this.resetBankDetails(bankOrder);
    }

    private void resetPartners(BankOrder bankOrder) {
        if (bankOrder.getPartnerTypeSelect() == 4) {
            for (BankOrderLine bankOrderLine : bankOrder.getBankOrderLineList()) {
                bankOrderLine.setPartner(null);
            }
            return;
        }
        for (BankOrderLine bankOrderLine : bankOrder.getBankOrderLineList()) {
            boolean keep;
            bankOrderLine.setReceiverCompany(null);
            Partner partner = bankOrderLine.getPartner();
            if (partner == null) continue;
            switch (bankOrder.getPartnerTypeSelect()) {
                case 1: {
                    keep = partner.getIsSupplier();
                    break;
                }
                case 2: {
                    keep = partner.getIsEmployee();
                    break;
                }
                case 3: {
                    keep = partner.getIsCustomer();
                    break;
                }
                default: {
                    keep = false;
                }
            }
            if (keep) continue;
            bankOrderLine.setPartner(null);
        }
    }

    private void resetBankDetails(BankOrder bankOrder) {
        for (BankOrderLine bankOrderLine : bankOrder.getBankOrderLineList()) {
            Collection<BankDetails> bankDetailsCollection;
            if (bankOrderLine.getReceiverBankDetails() == null || !ObjectUtils.isEmpty(bankDetailsCollection = bankOrderLine.getReceiverCompany() != null ? bankOrderLine.getReceiverCompany().getBankDetailsSet() : (bankOrderLine.getPartner() != null ? bankOrderLine.getPartner().getBankDetailsList() : Collections.emptyList())) && bankDetailsCollection.contains((Object)bankOrderLine.getReceiverBankDetails())) continue;
            bankOrderLine.setReceiverBankDetails(null);
        }
    }

    @Override
    public ActionView.ActionViewBuilder buildBankOrderLineView(String gridViewName, String formViewName, String viewDomain) {
        ActionView.ActionViewBuilder actionViewBuilder = ActionView.define((String)I18n.get((String)"Bank Order Lines")).model(BankOrderLine.class.getName()).add("grid", gridViewName).add("form", formViewName).domain(viewDomain);
        return actionViewBuilder;
    }
}

