/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankorder.file.directdebit;

import com.axelor.apps.account.db.Umr;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.service.bankorder.file.directdebit.BankOrderFile008Service;
import com.axelor.apps.bankpayment.service.config.BankPaymentConfigService;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.AccountIdentification3Choice;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.BranchAndFinancialInstitutionIdentification3;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.CashAccount7;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.ChargeBearerType1Code;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.CurrencyAndAmount;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.DirectDebitTransaction1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.DirectDebitTransactionInformation1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.Document;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.FinancialInstitutionIdentification5Choice;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.GenericIdentification3;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.GenericIdentification4;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.GroupHeader1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.Grouping1Code;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.LocalInstrument1Choice;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.MandateRelatedInformation1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.ObjectFactory;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.Pain00800101;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.Party2Choice;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.PartyIdentification8;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.PaymentIdentification1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.PaymentInstructionInformation2;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.PaymentMethod2Code;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.PaymentTypeInformation2;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.PersonIdentification3;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.RemittanceInformation1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.SequenceType1Code;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.ServiceLevel2Code;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01.ServiceLevel3Choice;
import com.axelor.apps.base.db.Bank;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public class BankOrderFile00800101Service
extends BankOrderFile008Service {
    protected ObjectFactory factory;
    protected String sepaType;

    @Inject
    public BankOrderFile00800101Service(BankOrder bankOrder, String sepaType) {
        super(bankOrder);
        this.context = "com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_01";
        this.factory = new ObjectFactory();
        this.sepaType = sepaType;
    }

    @Override
    public File generateFile() throws JAXBException, IOException, AxelorException, DatatypeConfigurationException {
        PartyIdentification8 creditor = this.factory.createPartyIdentification8();
        creditor.setNm(this.senderBankDetails.getOwnerName());
        Document document = this.factory.createDocument();
        Pain00800101 pain00800101 = this.factory.createPain00800101();
        document.setPain00800101(pain00800101);
        GroupHeader1 groupHeader = this.factory.createGroupHeader1();
        this.createGrpHdr(groupHeader, creditor);
        pain00800101.setGrpHdr(groupHeader);
        this.createPmtInf(pain00800101.getPmtInf(), creditor);
        this.fileToCreate = this.factory.createDocument(document);
        return super.generateFile();
    }

    protected void createGrpHdr(GroupHeader1 groupHeader, PartyIdentification8 creditor) throws DatatypeConfigurationException {
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        groupHeader.setMsgId(this.bankOrderSeq);
        groupHeader.setCreDtTm(datatypeFactory.newXMLGregorianCalendar(this.generationDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"))));
        groupHeader.setBtchBookg(true);
        groupHeader.setNbOfTxs(Integer.toString(this.nbOfLines));
        groupHeader.setCtrlSum(this.arithmeticTotal);
        groupHeader.setGrpg(Grouping1Code.MIXD);
        groupHeader.setInitgPty(creditor);
    }

    protected void createPmtInf(List<PaymentInstructionInformation2> paymentInstructionInformationList, PartyIdentification8 creditor) throws AxelorException, DatatypeConfigurationException {
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        PaymentInstructionInformation2 paymentInstructionInformation2 = this.factory.createPaymentInstructionInformation2();
        paymentInstructionInformationList.add(paymentInstructionInformation2);
        paymentInstructionInformation2.setPmtInfId(this.bankOrderSeq);
        paymentInstructionInformation2.setPmtMtd(PaymentMethod2Code.DD);
        PaymentTypeInformation2 paymentTypeInformation2 = this.factory.createPaymentTypeInformation2();
        paymentInstructionInformation2.setPmtTpInf(paymentTypeInformation2);
        ServiceLevel3Choice serviceLevel3Choice = this.factory.createServiceLevel3Choice();
        paymentTypeInformation2.setSvcLvl(serviceLevel3Choice);
        serviceLevel3Choice.setCd(ServiceLevel2Code.SEPA);
        LocalInstrument1Choice localInstrument1Choice = this.factory.createLocalInstrument1Choice();
        switch (this.sepaType) {
            case "CORE": {
                localInstrument1Choice.setCd("CORE");
                break;
            }
            case "SBB": {
                localInstrument1Choice.setCd("SBB");
                break;
            }
            default: {
                throw new AxelorException(4, I18n.get((String)"Unknown SEPA type for file generation"));
            }
        }
        paymentTypeInformation2.setLclInstrm(localInstrument1Choice);
        paymentTypeInformation2.setSeqTp(SequenceType1Code.FRST);
        paymentInstructionInformation2.setReqdColltnDt(datatypeFactory.newXMLGregorianCalendar(this.bankOrderDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))));
        paymentInstructionInformation2.setCdtr(creditor);
        AccountIdentification3Choice accountIdentification3Choice = this.factory.createAccountIdentification3Choice();
        accountIdentification3Choice.setIBAN(this.senderBankDetails.getIban());
        CashAccount7 cashAccount7 = this.factory.createCashAccount7();
        cashAccount7.setId(accountIdentification3Choice);
        paymentInstructionInformation2.setCdtrAcct(cashAccount7);
        FinancialInstitutionIdentification5Choice financialInstitutionIdentification5Choice = this.factory.createFinancialInstitutionIdentification5Choice();
        financialInstitutionIdentification5Choice.setBIC(this.senderBankDetails.getBank().getCode());
        BranchAndFinancialInstitutionIdentification3 branchAndFinancialInstitutionIdentification3 = this.factory.createBranchAndFinancialInstitutionIdentification3();
        branchAndFinancialInstitutionIdentification3.setFinInstnId(financialInstitutionIdentification5Choice);
        paymentInstructionInformation2.setCdtrAgt(branchAndFinancialInstitutionIdentification3);
        paymentInstructionInformation2.setChrgBr(ChargeBearerType1Code.SLEV);
        this.createDrctDbtTxInf(paymentInstructionInformation2.getDrctDbtTxInf(), creditor);
    }

    protected void createDrctDbtTxInf(List<DirectDebitTransactionInformation1> directDebitTransactionInformation1List, PartyIdentification8 creditor) throws DatatypeConfigurationException, AxelorException {
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        for (BankOrderLine bankOrderLine : this.bankOrderLineList) {
            BankDetails receiverBankDetails = bankOrderLine.getReceiverBankDetails();
            Umr receiverUmr = bankOrderLine.getPartner().getActiveUmr();
            if (receiverUmr == null) {
                throw new AxelorException(4, I18n.get((String)"Please add an Active UMR to the partner."));
            }
            DirectDebitTransactionInformation1 directDebitTransactionInformation1 = this.factory.createDirectDebitTransactionInformation1();
            directDebitTransactionInformation1List.add(directDebitTransactionInformation1);
            PaymentIdentification1 paymentIdentification1 = this.factory.createPaymentIdentification1();
            directDebitTransactionInformation1.setPmtId(paymentIdentification1);
            paymentIdentification1.setEndToEndId(bankOrderLine.getSequence());
            CurrencyAndAmount currencyAndAmount = this.factory.createCurrencyAndAmount();
            currencyAndAmount.setCcy("EUR");
            currencyAndAmount.setValue(bankOrderLine.getBankOrderAmount());
            directDebitTransactionInformation1.setInstdAmt(currencyAndAmount);
            DirectDebitTransaction1 directDebitTransaction1 = this.factory.createDirectDebitTransaction1();
            directDebitTransactionInformation1.setDrctDbtTx(directDebitTransaction1);
            MandateRelatedInformation1 mandateRelatedInformation1 = this.factory.createMandateRelatedInformation1();
            directDebitTransaction1.setMndtRltdInf(mandateRelatedInformation1);
            mandateRelatedInformation1.setMndtId(receiverUmr.getUmrNumber());
            mandateRelatedInformation1.setDtOfSgntr(datatypeFactory.newXMLGregorianCalendar(receiverUmr.getMandateSignatureDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))));
            PartyIdentification8 creditorSchemeId = this.factory.createPartyIdentification8();
            directDebitTransaction1.setCdtrSchmeId(creditorSchemeId);
            Party2Choice party2Choice = this.factory.createParty2Choice();
            creditorSchemeId.setId(party2Choice);
            PersonIdentification3 personIdentification3 = this.factory.createPersonIdentification3();
            party2Choice.getPrvtId().add(personIdentification3);
            GenericIdentification4 genericIdentification4 = this.factory.createGenericIdentification4();
            personIdentification3.setOthrId(genericIdentification4);
            genericIdentification4.setId(((BankPaymentConfigService)Beans.get(BankPaymentConfigService.class)).getIcsNumber(this.senderCompany.getBankPaymentConfig()));
            genericIdentification4.setIdTp("SEPA");
            BranchAndFinancialInstitutionIdentification3 branchAndFinancialInstitutionIdentification3 = this.factory.createBranchAndFinancialInstitutionIdentification3();
            FinancialInstitutionIdentification5Choice financialInstitutionIdentification5Choice = this.factory.createFinancialInstitutionIdentification5Choice();
            this.fillBic(financialInstitutionIdentification5Choice, receiverBankDetails.getBank());
            branchAndFinancialInstitutionIdentification3.setFinInstnId(financialInstitutionIdentification5Choice);
            directDebitTransactionInformation1.setDbtrAgt(branchAndFinancialInstitutionIdentification3);
            PartyIdentification8 debtor = this.factory.createPartyIdentification8();
            debtor.setNm(receiverBankDetails.getOwnerName());
            directDebitTransactionInformation1.setDbtr(debtor);
            AccountIdentification3Choice accountIdentification3Choice = this.factory.createAccountIdentification3Choice();
            accountIdentification3Choice.setIBAN(receiverBankDetails.getIban());
            CashAccount7 cashAccount7 = this.factory.createCashAccount7();
            cashAccount7.setId(accountIdentification3Choice);
            directDebitTransactionInformation1.setDbtrAcct(cashAccount7);
            RemittanceInformation1 remittanceInformation1 = this.factory.createRemittanceInformation1();
            directDebitTransactionInformation1.setRmtInf(remittanceInformation1);
            remittanceInformation1.getUstrd().add(bankOrderLine.getReceiverReference());
        }
    }

    protected void fillBic(FinancialInstitutionIdentification5Choice finInstnId, Bank bank) {
        if (this.bankOrderFileFormat.getIbanOnly().booleanValue() || bank == null || Strings.isNullOrEmpty((String)bank.getCode())) {
            GenericIdentification3 genId = new GenericIdentification3();
            genId.setId("NOTPROVIDED");
            finInstnId.setPrtryId(genId);
        } else {
            finInstnId.setBIC(bank.getCode());
        }
    }
}

