/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankorder.file.transfer;

import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.service.bankorder.file.BankOrderFileService;
import com.axelor.apps.bankpayment.service.cfonb.CfonbToolService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;

public abstract class BankOrderFileAFB160Service
extends BankOrderFileService {
    protected CfonbToolService cfonbToolService;
    protected PartnerService partnerService = (PartnerService)Beans.get(PartnerService.class);
    protected final int NB_CHAR_PER_LINE = 160;
    protected final String OPERATION_STANDARD_TRANSFER = "02";
    protected final String OPERATION_TO_CHECK_TRANSFER = "29";
    protected final String OPERATION_INDIVIDUAL_TRANSFER = "22";
    protected final String OPERATION_SCHEDULE_E3_TRANSFER = "27";
    protected final String OPERATION_SCHEDULE_E2_TRANSFER = "28";
    protected final String OPERATION_TREASURY_TRANSFER = "76";

    @Inject
    public BankOrderFileAFB160Service(BankOrder bankOrder) throws AxelorException {
        super(bankOrder);
        this.cfonbToolService = (CfonbToolService)Beans.get(CfonbToolService.class);
        this.fileExtension = "txt";
    }

    @Override
    public File generateFile() throws JAXBException, IOException, AxelorException, DatatypeConfigurationException {
        ArrayList records = Lists.newArrayList();
        records.add(this.createSenderRecord());
        for (BankOrderLine bankOrderLine : this.bankOrderLineList) {
            records.add(this.createDetailRecord(bankOrderLine));
            if (!this.useOptionalFurtherInformationRecord(bankOrderLine)) continue;
            records.add(this.createOptionalFurtherInformationRecord(bankOrderLine));
        }
        records.add(this.createTotalRecord());
        this.fileToCreate = records;
        return super.generateFile();
    }

    protected boolean useOptionalFurtherInformationRecord(BankOrderLine bankOrderLine) {
        return !Strings.isNullOrEmpty((String)bankOrderLine.getPaymentReasonLine1());
    }

    abstract String getB1Area();

    abstract String getB3Area();

    abstract String getC11Area();

    protected String getSenderC13Area() {
        int year = this.bankOrderDate.getYear();
        return this.bankOrderDate.format(DateTimeFormatter.ofPattern("ddMM")) + String.valueOf(year).substring(3);
    }

    abstract String getSenderEArea();

    protected String getDetailD1Area(BankOrderLine bankOrderLine) throws AxelorException {
        if (bankOrderLine.getReceiverBankDetails().getBankAddress() == null) {
            throw new AxelorException(I18n.get((String)"Please fill the bank address in the receiver bank details."), 1, new Object[0]);
        }
        return bankOrderLine.getReceiverBankDetails().getBankAddress().getAddress();
    }

    protected String getDetailD2Area(BankOrderLine bankOrderLine) {
        return "";
    }

    protected BigDecimal getDetailEAreaAmount(BankOrderLine bankOrderLine) {
        if (this.getB1Area().equals("29")) {
            return BigDecimal.ZERO;
        }
        return bankOrderLine.getBankOrderAmount();
    }

    protected String getDetailFArea(BankOrderLine bankOrderLine) {
        return bankOrderLine.getReceiverLabel();
    }

    protected String createSenderRecord() throws AxelorException {
        try {
            String string = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            String senderRecord = this.cfonbToolService.createZone("A", "03", string, "N", 2);
            senderRecord = senderRecord + this.cfonbToolService.createZone("B1", this.getB1Area(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 2);
            StringBuilder stringBuilder = new StringBuilder().append(senderRecord);
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder.append(this.cfonbToolService.createZone("B2", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 8)).toString();
            senderRecord = senderRecord + this.cfonbToolService.createZone("B3", this.getB3Area(), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 6);
            senderRecord = senderRecord + this.cfonbToolService.createZone("C1-1", this.getC11Area(), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 1);
            StringBuilder stringBuilder2 = new StringBuilder().append(senderRecord);
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder2.append(this.cfonbToolService.createZone("C1-2", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 6)).toString();
            StringBuilder stringBuilder3 = new StringBuilder().append(senderRecord);
            String string2 = this.getSenderC13Area();
            String string3 = this.cfonbToolService.STATUS_DEPENDENT;
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder3.append(this.cfonbToolService.createZone("C1-3", string2, string3, "N", 5)).toString();
            senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"C2 - Company name"), this.senderCompany.getName(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 24);
            senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"D1-1 - Bank order sequence"), this.bankOrderSeq, this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 7);
            StringBuilder stringBuilder4 = new StringBuilder().append(senderRecord);
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder4.append(this.cfonbToolService.createZone("D1-2", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 17)).toString();
            StringBuilder stringBuilder5 = new StringBuilder().append(senderRecord);
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder5.append(this.cfonbToolService.createZone("D2-1", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 2)).toString();
            senderRecord = senderRecord + this.cfonbToolService.createZone("D2-2", "E", this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA, 1);
            StringBuilder stringBuilder6 = new StringBuilder().append(senderRecord);
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder6.append(this.cfonbToolService.createZone("D2-3", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 5)).toString();
            StringBuilder stringBuilder7 = new StringBuilder().append(senderRecord);
            String string4 = I18n.get((String)"D3 - Sort code");
            String string5 = this.senderBankDetails.getSortCode();
            String string6 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder7.append(this.cfonbToolService.createZone(string4, string5, string6, "N", 5)).toString();
            senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"D4 - Account number"), this.senderBankDetails.getAccountNbr(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 11);
            senderRecord = senderRecord + this.cfonbToolService.createZone("E", this.getSenderEArea(), this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 16);
            StringBuilder stringBuilder8 = new StringBuilder().append(senderRecord);
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder8.append(this.cfonbToolService.createZone("F", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 31)).toString();
            StringBuilder stringBuilder9 = new StringBuilder().append(senderRecord);
            String string7 = I18n.get((String)"G1 - Bank code");
            String string8 = this.senderBankDetails.getBankCode();
            String string9 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder9.append(this.cfonbToolService.createZone(string7, string8, string9, "N", 5)).toString();
            StringBuilder stringBuilder10 = new StringBuilder().append(senderRecord);
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder10.append(this.cfonbToolService.createZone("G2", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 6)).toString();
            this.cfonbToolService.toUpperCase(senderRecord);
            this.cfonbToolService.testLength(senderRecord, 160);
            return senderRecord;
        }
        catch (Exception e) {
            throw new AxelorException((Throwable)e, 1, I18n.get((String)"Anomaly has been detected during file generation for the sender record of the bank order %s") + ": " + e.getMessage(), new Object[]{this.bankOrderSeq});
        }
    }

    protected String createDetailRecord(BankOrderLine bankOrderLine) throws AxelorException {
        try {
            BankDetails receiverBankDetails = bankOrderLine.getReceiverBankDetails();
            String string = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            String detailRecord = this.cfonbToolService.createZone("A", "06", string, "N", 2);
            detailRecord = detailRecord + this.cfonbToolService.createZone("B1", this.getB1Area(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 2);
            StringBuilder stringBuilder = new StringBuilder().append(detailRecord);
            this.cfonbToolService.getClass();
            detailRecord = stringBuilder.append(this.cfonbToolService.createZone("B2", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 8)).toString();
            detailRecord = detailRecord + this.cfonbToolService.createZone("B3", this.getB3Area(), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 6);
            detailRecord = detailRecord + this.cfonbToolService.createZone(I18n.get((String)"C1 - Sequence"), bankOrderLine.getSequence(), this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 12);
            detailRecord = detailRecord + this.cfonbToolService.createZone(I18n.get((String)"C2 - Receiver company name"), bankOrderLine.getReceiverCompany().getName(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 24);
            detailRecord = detailRecord + this.cfonbToolService.createZone(I18n.get((String)"D1 - Bank address"), this.getDetailD1Area(bankOrderLine), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 24);
            detailRecord = detailRecord + this.cfonbToolService.createZone("D2", this.getDetailD2Area(bankOrderLine), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 8);
            StringBuilder stringBuilder2 = new StringBuilder().append(detailRecord);
            String string2 = I18n.get((String)"D3 - Sort code");
            String string3 = receiverBankDetails.getSortCode();
            String string4 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            detailRecord = stringBuilder2.append(this.cfonbToolService.createZone(string2, string3, string4, "N", 5)).toString();
            detailRecord = detailRecord + this.cfonbToolService.createZone(I18n.get((String)"D4 - Account number"), receiverBankDetails.getAccountNbr(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 11);
            StringBuilder stringBuilder3 = new StringBuilder().append(detailRecord);
            String string5 = I18n.get((String)"E - Bank order amount");
            BigDecimal bigDecimal = this.getDetailEAreaAmount(bankOrderLine);
            String string6 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            detailRecord = stringBuilder3.append(this.cfonbToolService.createZone(string5, bigDecimal, string6, "N", 16)).toString();
            detailRecord = detailRecord + this.cfonbToolService.createZone(I18n.get((String)"F - Receiver label"), this.getDetailFArea(bankOrderLine), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 31);
            StringBuilder stringBuilder4 = new StringBuilder().append(detailRecord);
            String string7 = receiverBankDetails.getBankCode();
            String string8 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            detailRecord = stringBuilder4.append(this.cfonbToolService.createZone("G1", string7, string8, "N", 5)).toString();
            StringBuilder stringBuilder5 = new StringBuilder().append(detailRecord);
            this.cfonbToolService.getClass();
            detailRecord = stringBuilder5.append(this.cfonbToolService.createZone("G2", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 6)).toString();
            this.cfonbToolService.toUpperCase(detailRecord);
            this.cfonbToolService.testLength(detailRecord, 160);
            return detailRecord;
        }
        catch (Exception e) {
            throw new AxelorException((Throwable)e, (Model)((Object)bankOrderLine), 1, I18n.get((String)"Anomaly has been detected during file generation for the detail record of the bank order line %s") + ": " + e.getMessage(), new Object[]{bankOrderLine.getSequence()});
        }
    }

    protected String createOptionalFurtherInformationRecord(BankOrderLine bankOrderLine) throws AxelorException {
        try {
            BankDetails receiverBankDetails = bankOrderLine.getReceiverBankDetails();
            String string = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            String totalRecord = this.cfonbToolService.createZone("A", "07", string, "N", 2);
            totalRecord = totalRecord + this.cfonbToolService.createZone("B1", this.getB1Area(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 2);
            StringBuilder stringBuilder = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder.append(this.cfonbToolService.createZone("B2", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 8)).toString();
            totalRecord = totalRecord + this.cfonbToolService.createZone("B3", this.getB3Area(), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 6);
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"C1 - Sequence"), bankOrderLine.getSequence(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 12);
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"C2 - Receiver company name"), bankOrderLine.getReceiverCompany().getName(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 24);
            if (bankOrderLine.getReceiverBankDetails().getBankAddress() == null) {
                throw new AxelorException(I18n.get((String)"Please fill the bank address in the receiver bank details."), 1, new Object[0]);
            }
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"D1 - Bank address"), receiverBankDetails.getBankAddress().getAddress(), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 24);
            StringBuilder stringBuilder2 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder2.append(this.cfonbToolService.createZone("D2", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 8)).toString();
            StringBuilder stringBuilder3 = new StringBuilder().append(totalRecord);
            String string2 = I18n.get((String)"D3 - Sort code");
            String string3 = receiverBankDetails.getSortCode();
            String string4 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder3.append(this.cfonbToolService.createZone(string2, string3, string4, "N", 5)).toString();
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"D4 - Account number"), receiverBankDetails.getAccountNbr(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 11);
            StringBuilder stringBuilder4 = new StringBuilder().append(totalRecord);
            String string5 = I18n.get((String)"E - Bank order amount");
            BigDecimal bigDecimal = bankOrderLine.getBankOrderAmount();
            String string6 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder4.append(this.cfonbToolService.createZone(string5, bigDecimal, string6, "N", 16)).toString();
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"F - Receiver label"), bankOrderLine.getPaymentReasonLine1(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 31);
            StringBuilder stringBuilder5 = new StringBuilder().append(totalRecord);
            String string7 = I18n.get((String)"G1 - Bank establisment code");
            String string8 = receiverBankDetails.getBankCode();
            String string9 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder5.append(this.cfonbToolService.createZone(string7, string8, string9, "N", 5)).toString();
            StringBuilder stringBuilder6 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder6.append(this.cfonbToolService.createZone("G2", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 6)).toString();
            this.cfonbToolService.toUpperCase(totalRecord);
            this.cfonbToolService.testLength(totalRecord, 160);
            return totalRecord;
        }
        catch (Exception e) {
            throw new AxelorException((Throwable)e, (Model)((Object)bankOrderLine), 1, I18n.get((String)"Anomaly has been detected during file generation for the further information detail record of the bank order line %s") + ": " + e.getMessage(), new Object[]{bankOrderLine.getSequence()});
        }
    }

    protected String createTotalRecord() throws AxelorException {
        try {
            String string = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            String totalRecord = this.cfonbToolService.createZone("A", "08", string, "N", 2);
            StringBuilder stringBuilder = new StringBuilder().append(totalRecord);
            String string2 = this.getB1Area();
            String string3 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder.append(this.cfonbToolService.createZone("B1", string2, string3, "N", 2)).toString();
            StringBuilder stringBuilder2 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder2.append(this.cfonbToolService.createZone("B2", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 8)).toString();
            totalRecord = totalRecord + this.cfonbToolService.createZone("B3", this.getB3Area(), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 6);
            StringBuilder stringBuilder3 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder3.append(this.cfonbToolService.createZone("C1", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 12)).toString();
            StringBuilder stringBuilder4 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder4.append(this.cfonbToolService.createZone("C2", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 24)).toString();
            StringBuilder stringBuilder5 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder5.append(this.cfonbToolService.createZone("D1", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 24)).toString();
            StringBuilder stringBuilder6 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder6.append(this.cfonbToolService.createZone("D2", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 8)).toString();
            StringBuilder stringBuilder7 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder7.append(this.cfonbToolService.createZone("D3", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 5)).toString();
            StringBuilder stringBuilder8 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder8.append(this.cfonbToolService.createZone("D4", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 11)).toString();
            StringBuilder stringBuilder9 = new StringBuilder().append(totalRecord);
            String string4 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder9.append(this.cfonbToolService.createZone("E", this.arithmeticTotal, string4, "N", 16)).toString();
            StringBuilder stringBuilder10 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder10.append(this.cfonbToolService.createZone("F", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 31)).toString();
            StringBuilder stringBuilder11 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder11.append(this.cfonbToolService.createZone("G1", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 5)).toString();
            StringBuilder stringBuilder12 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder12.append(this.cfonbToolService.createZone("G2", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 6)).toString();
            this.cfonbToolService.toUpperCase(totalRecord);
            this.cfonbToolService.testLength(totalRecord, 160);
            return totalRecord;
        }
        catch (Exception e) {
            throw new AxelorException((Throwable)e, 1, I18n.get((String)"Anomaly has been detected during file generation for the total record of the bank order %s") + ": " + e.getMessage(), new Object[]{this.bankOrderSeq});
        }
    }
}

