/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankreconciliation;

import com.axelor.apps.bankpayment.db.BankReconciliation;
import com.axelor.apps.bankpayment.db.BankStatement;
import com.axelor.apps.bankpayment.db.repo.BankReconciliationRepository;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;

public class BankReconciliationCreateService {
    protected BankReconciliationRepository bankReconciliationRepository;
    protected CompanyRepository companyRepository;

    @Inject
    public BankReconciliationCreateService(BankReconciliationRepository bankReconciliationRepository, CompanyRepository companyRepository) {
        this.bankReconciliationRepository = bankReconciliationRepository;
        this.companyRepository = companyRepository;
    }

    @Transactional(rollbackOn={Exception.class})
    public List<BankReconciliation> createAllFromBankStatement(BankStatement bankStatement) throws IOException {
        ArrayList<BankReconciliation> bankReconciliationList = new ArrayList<BankReconciliation>();
        List<BankDetails> bankDetailsList = this.getDistinctBankDetails(bankStatement);
        if (bankDetailsList == null) {
            return bankReconciliationList;
        }
        LocalDate fromDate = bankStatement.getFromDate();
        LocalDate toDate = bankStatement.getToDate();
        for (BankDetails bankDetails : bankDetailsList) {
            Company company = (Company)((Object)this.companyRepository.all().filter("?1 member of self.bankDetailsSet", new Object[]{bankDetails}).fetchOne());
            Currency currency = bankDetails.getCurrency();
            if (currency == null) {
                currency = company.getCurrency();
            }
            BankReconciliation bankReconciliation = this.createBankReconciliation(company, fromDate, toDate, currency, bankDetails, bankStatement);
            this.bankReconciliationRepository.save((Model)((Object)bankReconciliation));
            bankReconciliationList.add(bankReconciliation);
        }
        return bankReconciliationList;
    }

    protected List<BankDetails> getDistinctBankDetails(BankStatement bankStatement) {
        Query q = JPA.em().createQuery("SELECT DISTINCT(BSL.bankDetails) FROM BankStatementLine BSL WHERE BSL.bankStatement = :bankStatement AND BSL.amountRemainToReconcile > 0");
        q.setParameter("bankStatement", (Object)bankStatement);
        return q.getResultList();
    }

    public BankReconciliation createBankReconciliation(Company company, LocalDate fromDate, LocalDate toDate, Currency currency, BankDetails bankDetails, BankStatement bankStatement) throws IOException {
        BankReconciliation bankReconciliation = new BankReconciliation();
        bankReconciliation.setCompany(company);
        bankReconciliation.setFromDate(fromDate);
        bankReconciliation.setToDate(toDate);
        bankReconciliation.setCurrency(currency);
        bankReconciliation.setBankDetails(bankDetails);
        bankReconciliation.setBankStatement(bankStatement);
        bankReconciliation.setName(this.computeName(bankReconciliation));
        return bankReconciliation;
    }

    public String computeName(BankReconciliation bankReconciliation) {
        String name = "";
        if (bankReconciliation.getCompany() != null) {
            name = name + bankReconciliation.getCompany().getCode();
        }
        if (bankReconciliation.getCurrency() != null) {
            if (name != "") {
                name = name + "-";
            }
            name = name + bankReconciliation.getCurrency().getCode();
        }
        if (bankReconciliation.getBankDetails() != null) {
            if (name != "") {
                name = name + "-";
            }
            name = name + bankReconciliation.getBankDetails().getAccountNbr();
        }
        if (bankReconciliation.getFromDate() != null) {
            if (name != "") {
                name = name + "-";
            }
            name = name + bankReconciliation.getFromDate().format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
        }
        if (bankReconciliation.getToDate() != null) {
            if (name != "") {
                name = name + "-";
            }
            name = name + bankReconciliation.getToDate().format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
        }
        return name;
    }
}

