/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankreconciliation;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.service.AccountService;
import com.axelor.apps.bankpayment.db.BankReconciliation;
import com.axelor.apps.bankpayment.db.BankReconciliationLine;
import com.axelor.apps.bankpayment.db.BankStatement;
import com.axelor.apps.bankpayment.db.BankStatementFileFormat;
import com.axelor.apps.bankpayment.db.repo.BankReconciliationRepository;
import com.axelor.apps.bankpayment.service.bankreconciliation.load.BankReconciliationLoadService;
import com.axelor.apps.bankpayment.service.bankreconciliation.load.afb120.BankReconciliationLoadAFB120Service;
import com.axelor.apps.base.service.BankDetailsService;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;

public class BankReconciliationService {
    protected BankReconciliationRepository bankReconciliationRepository;
    protected AccountService accountService;

    @Inject
    public BankReconciliationService(BankReconciliationRepository bankReconciliationRepository, AccountService accountService) {
        this.bankReconciliationRepository = bankReconciliationRepository;
        this.accountService = accountService;
    }

    @Transactional
    public void compute(BankReconciliation bankReconciliation) {
        BigDecimal totalPaid = BigDecimal.ZERO;
        BigDecimal totalCashed = BigDecimal.ZERO;
        for (BankReconciliationLine bankReconciliationLine : bankReconciliation.getBankReconciliationLineList()) {
            totalPaid = totalPaid.add(bankReconciliationLine.getDebit());
            totalCashed = totalCashed.add(bankReconciliationLine.getCredit());
        }
        bankReconciliation.setTotalPaid(totalPaid);
        bankReconciliation.setTotalCashed(totalCashed);
        Account cashAccount = bankReconciliation.getCashAccount();
        if (cashAccount != null) {
            bankReconciliation.setAccountBalance(this.accountService.computeBalance(cashAccount, AccountService.BALANCE_TYPE_DEBIT_BALANCE.intValue()));
        }
        bankReconciliation.setComputedBalance(bankReconciliation.getAccountBalance().add(totalCashed).subtract(totalPaid));
    }

    public String createDomainForBankDetails(BankReconciliation bankReconciliation) {
        return ((BankDetailsService)Beans.get(BankDetailsService.class)).getActiveCompanyBankDetails(bankReconciliation.getCompany(), bankReconciliation.getCurrency());
    }

    @Transactional
    public void loadBankStatement(BankReconciliation bankReconciliation) {
        this.loadBankStatement(bankReconciliation, true);
    }

    @Transactional
    public void loadBankStatement(BankReconciliation bankReconciliation, boolean includeBankStatement) {
        BankStatement bankStatement = bankReconciliation.getBankStatement();
        BankStatementFileFormat bankStatementFileFormat = bankStatement.getBankStatementFileFormat();
        switch (bankStatementFileFormat.getStatementFileFormatSelect()) {
            case "camt.xxx.cfonb120.rep": 
            case "camt.xxx.cfonb120.stm": {
                ((BankReconciliationLoadAFB120Service)Beans.get(BankReconciliationLoadAFB120Service.class)).loadBankStatement(bankReconciliation, includeBankStatement);
                break;
            }
            default: {
                ((BankReconciliationLoadService)Beans.get(BankReconciliationLoadService.class)).loadBankStatement(bankReconciliation, includeBankStatement);
            }
        }
        this.compute(bankReconciliation);
        this.bankReconciliationRepository.save((Model)((Object)bankReconciliation));
    }
}

