/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankstatement;

import com.axelor.apps.bankpayment.db.BankStatement;
import com.axelor.apps.bankpayment.db.BankStatementFileFormat;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class BankStatementCreateService {
    public BankStatement createBankStatement(File file, LocalDate fromDate, LocalDate toDate, BankStatementFileFormat bankStatementFileFormat, EbicsPartner ebicsPartner, LocalDateTime executionDateTime) throws IOException {
        BankStatement bankStatement = new BankStatement();
        bankStatement.setFromDate(fromDate);
        bankStatement.setToDate(toDate);
        bankStatement.setBankStatementFileFormat(bankStatementFileFormat);
        bankStatement.setEbicsPartner(ebicsPartner);
        bankStatement.setGetDateTime(executionDateTime);
        bankStatement.setBankStatementFile(((MetaFiles)Beans.get(MetaFiles.class)).upload(file));
        bankStatement.setName(this.computeName(bankStatement));
        bankStatement.setStatusSelect(1);
        return bankStatement;
    }

    protected String computeName(BankStatement bankStatement) {
        String name = "";
        if (bankStatement.getEbicsPartner() != null) {
            name = name + bankStatement.getEbicsPartner().getPartnerId();
        }
        if (bankStatement.getBankStatementFileFormat() != null) {
            if (name != "") {
                name = name + "-";
            }
            name = name + bankStatement.getBankStatementFileFormat().getName();
        }
        try {
            if (bankStatement.getFromDate() != null) {
                if (name != "") {
                    name = name + "-";
                }
                name = name + bankStatement.getFromDate().format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
            }
            if (bankStatement.getToDate() != null) {
                if (name != "") {
                    name = name + "-";
                }
                name = name + bankStatement.getToDate().format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }
}

