/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankstatement.file.afb120;

import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.account.db.repo.InterbankCodeLineRepository;
import com.axelor.apps.bankpayment.db.BankStatementLineAFB120;
import com.axelor.apps.bankpayment.db.repo.BankStatementLineAFB120Repository;
import com.axelor.apps.bankpayment.service.bankstatement.BankStatementService;
import com.axelor.apps.bankpayment.service.bankstatement.file.BankStatementFileService;
import com.axelor.apps.bankpayment.service.bankstatement.file.afb120.BankStatementLineAFB120Service;
import com.axelor.apps.bankpayment.service.cfonb.CfonbToolService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.repo.BankDetailsRepository;
import com.axelor.apps.base.db.repo.CurrencyRepository;
import com.axelor.apps.tool.file.FileTool;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankStatementFileAFB120Service
extends BankStatementFileService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected BankStatementLineAFB120Service bankStatementLineAFB120Service;
    protected BankStatementLineAFB120Repository bankStatementLineAFB120Repository;
    protected CfonbToolService cfonbToolService = (CfonbToolService)Beans.get(CfonbToolService.class);
    protected CurrencyRepository currencyRepository = (CurrencyRepository)Beans.get(CurrencyRepository.class);
    protected BankDetailsRepository bankDetailsRepository = (BankDetailsRepository)((Object)Beans.get(BankDetailsRepository.class));
    protected InterbankCodeLineRepository interbankCodeLineRepository = (InterbankCodeLineRepository)Beans.get(InterbankCodeLineRepository.class);
    protected static final String PREVIOUS_BALANCE_OPERATION_CODE = "01";
    protected static final String MOVEMENT_OPERATION_CODE = "04";
    protected static final String COMPLEMENT_MOVEMENT_OPERATION_CODE = "05";
    protected static final String NEW_BALANCE_OPERATION_CODE = "07";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("ddMMyy");

    @Inject
    public BankStatementFileAFB120Service(BankStatementService bankStatementService) {
        super(bankStatementService);
        this.bankStatementLineAFB120Service = (BankStatementLineAFB120Service)Beans.get(BankStatementLineAFB120Service.class);
        this.bankStatementLineAFB120Repository = (BankStatementLineAFB120Repository)((Object)Beans.get(BankStatementLineAFB120Repository.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() throws IOException, AxelorException {
        super.process();
        List<Map<String, Object>> structuredContentFile = this.readFile();
        int sequence = 0;
        this.findBankStatement();
        for (Map<String, Object> structuredContentLine : structuredContentFile) {
            try {
                this.createBankStatementLine(structuredContentLine, sequence++);
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)new Exception(String.format("Line %s : %s", sequence, e), e), (String)"import");
                this.findBankStatement();
            }
            finally {
                if (sequence % 10 != 0) continue;
                JPA.clear();
                this.findBankStatement();
            }
        }
        JPA.clear();
    }

    @Transactional
    public void createBankStatementLine(Map<String, Object> structuredContentLine, int sequence) {
        String description = (String)structuredContentLine.get("description");
        if (structuredContentLine.containsKey("additionalInformation") && structuredContentLine.get("additionalInformation") != null) {
            description = description + "\n" + (String)structuredContentLine.get("additionalInformation");
        }
        BankDetails bankDetails = null;
        if (structuredContentLine.containsKey("bankDetails") && structuredContentLine.get("bankDetails") != null) {
            bankDetails = (BankDetails)((Object)this.bankDetailsRepository.find(((BankDetails)((Object)structuredContentLine.get("bankDetails"))).getId()));
        }
        Currency currency = null;
        if (structuredContentLine.containsKey("currency") && structuredContentLine.get("currency") != null) {
            currency = (Currency)this.currencyRepository.find(((Currency)structuredContentLine.get("currency")).getId());
        }
        InterbankCodeLine operationInterbankCodeLine = null;
        if (structuredContentLine.containsKey("operationInterbankCodeLine") && structuredContentLine.get("operationInterbankCodeLine") != null) {
            operationInterbankCodeLine = (InterbankCodeLine)this.interbankCodeLineRepository.find(((InterbankCodeLine)structuredContentLine.get("operationInterbankCodeLine")).getId());
        }
        InterbankCodeLine rejectInterbankCodeLine = null;
        if (structuredContentLine.containsKey("rejectInterbankCodeLine") && structuredContentLine.get("rejectInterbankCodeLine") != null) {
            rejectInterbankCodeLine = (InterbankCodeLine)this.interbankCodeLineRepository.find(((InterbankCodeLine)structuredContentLine.get("rejectInterbankCodeLine")).getId());
        }
        BankStatementLineAFB120 bankStatementLineAFB120 = this.bankStatementLineAFB120Service.createBankStatementLine(this.findBankStatement(), sequence, bankDetails, (BigDecimal)structuredContentLine.get("debit"), (BigDecimal)structuredContentLine.get("credit"), currency, description, (LocalDate)structuredContentLine.get("operationDate"), (LocalDate)structuredContentLine.get("valueDate"), operationInterbankCodeLine, rejectInterbankCodeLine, (String)structuredContentLine.get("origin"), (String)structuredContentLine.get("reference"), (Integer)structuredContentLine.get("lineType"), (String)structuredContentLine.get("unavailabilityIndexSelect"), (String)structuredContentLine.get("commissionExemptionIndexSelect"));
        this.bankStatementLineAFB120Repository.save((Model)((Object)bankStatementLineAFB120));
    }

    protected List<Map<String, Object>> readFile() throws IOException, AxelorException {
        ArrayList structuredContent = Lists.newArrayList();
        List fileContent = FileTool.reader((String)this.file.getPath());
        for (String lineContent : fileContent) {
            this.log.info("Read line : {}", (Object)lineContent);
            String lineData = null;
            block13: for (int i = 0; i < lineContent.length(); i += 120) {
                String operationCode;
                lineData = lineContent.substring(i, i + 120);
                String string = this.cfonbToolService.STATUS_MANDATORY;
                this.cfonbToolService.getClass();
                switch (operationCode = this.cfonbToolService.readZone("Record code", lineData, string, "N", 1, 2)) {
                    case "01": {
                        structuredContent.add(this.readPreviousBalanceRecord(lineData));
                        continue block13;
                    }
                    case "04": {
                        structuredContent.add(this.readMovementRecord(lineData));
                        continue block13;
                    }
                    case "05": {
                        Map movementLine = (Map)structuredContent.get(structuredContent.size() - 1);
                        String additionalInformation = "";
                        if (movementLine.containsKey("additionalInformation")) {
                            additionalInformation = (String)movementLine.get("additionalInformation") + "\n";
                        }
                        additionalInformation = additionalInformation + (String)this.readAdditionalMovementRecord(lineData).get("additionalInformation");
                        movementLine.put("additionalInformation", additionalInformation);
                        continue block13;
                    }
                    case "07": {
                        structuredContent.add(this.readNewBalanceRecord(lineData));
                        continue block13;
                    }
                }
            }
        }
        return structuredContent;
    }

    protected Map<String, Object> readPreviousBalanceRecord(String lineContent) throws AxelorException {
        HashMap structuredLineContent = Maps.newHashMap();
        structuredLineContent.put("lineType", 1);
        String string = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        String bankCode = this.cfonbToolService.readZone("1-B : bank code", lineContent, string, "N", 3, 5);
        String string2 = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        String sortCode = this.cfonbToolService.readZone("1-D : sort code", lineContent, string2, "N", 12, 5);
        String currencyCode = this.cfonbToolService.readZone("1-E : currency code", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA, 17, 3);
        structuredLineContent.put("currency", this.getCurrency(currencyCode));
        String string3 = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        int decimalDigitNumber = Integer.parseInt(this.cfonbToolService.readZone("1-F : decimal number", lineContent, string3, "N", 20, 1));
        String accountNumber = this.cfonbToolService.readZone("1-H : account number", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 22, 11);
        structuredLineContent.put("bankDetails", this.getBankDetails(accountNumber, bankCode, sortCode));
        String string4 = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        String date = this.cfonbToolService.readZone("1-J : date", lineContent, string4, "N", 35, 6);
        structuredLineContent.put("operationDate", this.getDate(date));
        String amountStr = this.cfonbToolService.readZone("1-L : amount", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 91, 14);
        BigDecimal amount = this.getAmount(amountStr, decimalDigitNumber);
        if (amount.signum() == 1) {
            structuredLineContent.put("debit", BigDecimal.ZERO);
            structuredLineContent.put("credit", amount.abs());
        } else {
            structuredLineContent.put("credit", BigDecimal.ZERO);
            structuredLineContent.put("debit", amount.abs());
        }
        return structuredLineContent;
    }

    protected Map<String, Object> readMovementRecord(String lineContent) throws AxelorException {
        HashMap structuredLineContent = Maps.newHashMap();
        structuredLineContent.put("lineType", 2);
        String string = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        String bankCode = this.cfonbToolService.readZone("2-B : bank code", lineContent, string, "N", 3, 5);
        String string2 = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        String sortCode = this.cfonbToolService.readZone("2-D : sort code", lineContent, string2, "N", 12, 5);
        String currencyCode = this.cfonbToolService.readZone("2-E : currency code", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA, 17, 3);
        structuredLineContent.put("currency", this.getCurrency(currencyCode));
        String string3 = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        int decimalDigitNumber = Integer.parseInt(this.cfonbToolService.readZone("2-F : decimal number", lineContent, string3, "N", 20, 1));
        String accountNumber = this.cfonbToolService.readZone("2-H : account number", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 22, 11);
        structuredLineContent.put("bankDetails", this.getBankDetails(accountNumber, bankCode, sortCode));
        String operationInterbankCode = this.cfonbToolService.readZone("2-I : interbank operation code", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 33, 2);
        structuredLineContent.put("operationInterbankCodeLine", this.getInterbankCodeLine(operationInterbankCode));
        String string4 = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        String movementDate = this.cfonbToolService.readZone("2-J : operation date", lineContent, string4, "N", 35, 6);
        structuredLineContent.put("operationDate", this.getDate(movementDate));
        String string5 = this.cfonbToolService.STATUS_DEPENDENT;
        this.cfonbToolService.getClass();
        String rejectInterbankCodeLine = this.cfonbToolService.readZone("2-K : interbank reject code", lineContent, string5, "N", 41, 2);
        structuredLineContent.put("rejectInterbankCodeLine", this.getInterbankCodeLine(rejectInterbankCodeLine));
        String string6 = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        String valueDate = this.cfonbToolService.readZone("2-L : value date", lineContent, string6, "N", 43, 6);
        structuredLineContent.put("valueDate", this.getDate(valueDate));
        structuredLineContent.put("description", this.cfonbToolService.readZone("2-M : label", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 49, 31));
        structuredLineContent.put("origin", this.cfonbToolService.readZone("2-O : move number", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 82, 7));
        structuredLineContent.put("commissionExemptionIndexSelect", this.cfonbToolService.readZone("2-P : turnover commission exemption index", lineContent, this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 89, 1));
        structuredLineContent.put("unavailabilityIndexSelect", this.cfonbToolService.readZone("2-Q : unavailability index", lineContent, this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 90, 1));
        String amountStr = this.cfonbToolService.readZone("2-R : amount", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 91, 14);
        BigDecimal amount = this.getAmount(amountStr, decimalDigitNumber);
        if (amount.signum() == 1) {
            structuredLineContent.put("debit", BigDecimal.ZERO);
            structuredLineContent.put("credit", amount.abs());
        } else {
            structuredLineContent.put("credit", BigDecimal.ZERO);
            structuredLineContent.put("debit", amount.abs());
        }
        structuredLineContent.put("reference", this.cfonbToolService.readZone("2-S : reference zone", lineContent, this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 105, 16));
        return structuredLineContent;
    }

    protected Map<String, Object> readAdditionalMovementRecord(String lineContent) throws AxelorException {
        String additionalInformationType;
        HashMap structuredLineContent = Maps.newHashMap();
        String string = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        String bankCode = this.cfonbToolService.readZone("2b-B : bank code", lineContent, string, "N", 3, 5);
        String string2 = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        String sortCode = this.cfonbToolService.readZone("2b-D : sort code", lineContent, string2, "N", 12, 5);
        String currencyCode = this.cfonbToolService.readZone("2b-E : currency code", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA, 17, 3);
        structuredLineContent.put("currency", this.getCurrency(currencyCode));
        String string3 = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        this.cfonbToolService.readZone("2b-F : decimal number", lineContent, string3, "N", 20, 1);
        String accountNumber = this.cfonbToolService.readZone("2b-H : account number", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 22, 11);
        structuredLineContent.put("bankDetails", this.getBankDetails(accountNumber, bankCode, sortCode));
        String operationInterbankCode = this.cfonbToolService.readZone("2b-I : interbank operation code", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 33, 2);
        structuredLineContent.put("operationInterbankCodeLine", this.getInterbankCodeLine(operationInterbankCode));
        String string4 = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        String date = this.cfonbToolService.readZone("2b-J : operation date", lineContent, string4, "N", 35, 6);
        structuredLineContent.put("operationDate", this.getDate(date));
        switch (additionalInformationType = this.cfonbToolService.readZone("2b-L : qualifying of additional information zone", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 46, 3)) {
            case "LIB": {
                structuredLineContent.put("additionalInformation", this.cfonbToolService.readZone("2b-M : additional informations", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 49, 70));
                break;
            }
            case "MMO": {
                String origineCurrencyCode = this.cfonbToolService.readZone("2b-M-1 : currency code", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 49, 3);
                int decimalDigitNumber = Integer.parseInt(this.cfonbToolService.readZone("2b-M-2 : decimal digit number", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 52, 1));
                String amountInCurrency = this.cfonbToolService.readZone("2b-M-3 : original amount", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 53, 14);
                String integerPartOfAmount = amountInCurrency.substring(0, amountInCurrency.length() - decimalDigitNumber);
                String decimalPartOfAmount = amountInCurrency.substring(amountInCurrency.length() - decimalDigitNumber);
                String correctAmount = integerPartOfAmount + "." + decimalPartOfAmount;
                structuredLineContent.put("additionalInformation", correctAmount + " " + origineCurrencyCode);
                break;
            }
            default: {
                structuredLineContent.put("additionalInformation", this.cfonbToolService.readZone("2b-M : additional informations", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 49, 70));
            }
        }
        return structuredLineContent;
    }

    protected Map<String, Object> readNewBalanceRecord(String lineContent) throws AxelorException {
        HashMap structuredLineContent = Maps.newHashMap();
        structuredLineContent.put("lineType", 3);
        String string = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        String bankCode = this.cfonbToolService.readZone("3-B : bank code", lineContent, string, "N", 3, 5);
        String string2 = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        String sortCode = this.cfonbToolService.readZone("3-D : sort code", lineContent, string2, "N", 12, 5);
        String currencyCode = this.cfonbToolService.readZone("3-E : currency code", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA, 17, 3);
        structuredLineContent.put("currency", this.getCurrency(currencyCode));
        String string3 = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        int nbDecimalDigit = Integer.parseInt(this.cfonbToolService.readZone("3-F : decimal number", lineContent, string3, "N", 20, 1));
        String accountNumber = this.cfonbToolService.readZone("3-H : account number", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 22, 11);
        structuredLineContent.put("bankDetails", this.getBankDetails(accountNumber, bankCode, sortCode));
        String string4 = this.cfonbToolService.STATUS_MANDATORY;
        this.cfonbToolService.getClass();
        String date = this.cfonbToolService.readZone("3-J : date", lineContent, string4, "N", 35, 6);
        structuredLineContent.put("operationDate", this.getDate(date));
        String amountStr = this.cfonbToolService.readZone("3-L : amount", lineContent, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 91, 14);
        BigDecimal amount = this.getAmount(amountStr, nbDecimalDigit);
        if (amount.signum() == 1) {
            structuredLineContent.put("debit", BigDecimal.ZERO);
            structuredLineContent.put("credit", amount.abs());
        } else {
            structuredLineContent.put("credit", BigDecimal.ZERO);
            structuredLineContent.put("debit", amount.abs());
        }
        return structuredLineContent;
    }

    protected Currency getCurrency(String isoCode) {
        return this.currencyRepository.findByCode(isoCode);
    }

    protected BankDetails getBankDetails(String accountNumber, String bankCode, String sortCode) {
        return (BankDetails)((Object)this.bankDetailsRepository.all().filter("self.accountNbr = ?1 and self.bankCode = ?2 and self.sortCode = ?3", new Object[]{accountNumber, bankCode, sortCode}).fetchOne());
    }

    protected LocalDate getDate(String date) {
        return LocalDate.parse(date, DATE_FORMATTER);
    }

    protected BigDecimal getAmount(String amount, int decimalDigitNumber) {
        String signHex = amount.substring(amount.length() - 1);
        String lastDigit = "";
        String sign = "";
        switch (signHex) {
            case "{": {
                lastDigit = "0";
                sign = "+";
                break;
            }
            case "A": {
                lastDigit = "1";
                sign = "+";
                break;
            }
            case "B": {
                lastDigit = "2";
                sign = "+";
                break;
            }
            case "C": {
                lastDigit = "3";
                sign = "+";
                break;
            }
            case "D": {
                lastDigit = "4";
                sign = "+";
                break;
            }
            case "E": {
                lastDigit = "5";
                sign = "+";
                break;
            }
            case "F": {
                lastDigit = "6";
                sign = "+";
                break;
            }
            case "G": {
                lastDigit = "7";
                sign = "+";
                break;
            }
            case "H": {
                lastDigit = "8";
                sign = "+";
                break;
            }
            case "I": {
                lastDigit = "9";
                sign = "+";
                break;
            }
            case "}": {
                lastDigit = "0";
                sign = "-";
                break;
            }
            case "J": {
                lastDigit = "1";
                sign = "-";
                break;
            }
            case "K": {
                lastDigit = "2";
                sign = "-";
                break;
            }
            case "L": {
                lastDigit = "3";
                sign = "-";
                break;
            }
            case "M": {
                lastDigit = "4";
                sign = "-";
                break;
            }
            case "N": {
                lastDigit = "5";
                sign = "-";
                break;
            }
            case "O": {
                lastDigit = "6";
                sign = "-";
                break;
            }
            case "P": {
                lastDigit = "7";
                sign = "-";
                break;
            }
            case "Q": {
                lastDigit = "8";
                sign = "-";
                break;
            }
            case "R": {
                lastDigit = "9";
                sign = "-";
                break;
            }
        }
        String completeAmount = sign + amount.substring(0, amount.length() - 1) + lastDigit;
        String integerPartOfAmount = completeAmount.substring(0, completeAmount.length() - decimalDigitNumber);
        String decimalPartOfAmount = completeAmount.substring(completeAmount.length() - decimalDigitNumber);
        String correctAmount = integerPartOfAmount + "." + decimalPartOfAmount;
        return new BigDecimal(correctAmount);
    }

    protected InterbankCodeLine getInterbankCodeLine(String code) {
        return null;
    }
}

