/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankstatement.file.afb120;

import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.bankpayment.db.BankStatement;
import com.axelor.apps.bankpayment.db.BankStatementLine;
import com.axelor.apps.bankpayment.db.BankStatementLineAFB120;
import com.axelor.apps.bankpayment.service.bankstatement.BankStatementLineService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Currency;
import com.axelor.db.mapper.Mapper;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;

public class BankStatementLineAFB120Service
extends BankStatementLineService {
    @Inject
    public BankStatementLineAFB120Service() {
    }

    public BankStatementLineAFB120 createBankStatementLine(BankStatement bankStatement, int sequence, BankDetails bankDetails, BigDecimal debit, BigDecimal credit, Currency currency, String description, LocalDate operationDate, LocalDate valueDate, InterbankCodeLine operationInterbankCodeLine, InterbankCodeLine rejectInterbankCodeLine, String origin, String reference, int lineType, String unavailabilityIndexSelect, String commissionExemptionIndexSelect) {
        BankStatementLine bankStatementLine = super.createBankStatementLine(bankStatement, sequence, bankDetails, debit, credit, currency, description, operationDate, valueDate, operationInterbankCodeLine, rejectInterbankCodeLine, origin, reference);
        BankStatementLineAFB120 bankStatementLineAFB120 = (BankStatementLineAFB120)((Object)Mapper.toBean(BankStatementLineAFB120.class, (Map)Mapper.toMap((Object)((Object)bankStatementLine))));
        bankStatementLineAFB120.setLineTypeSelect(lineType);
        if (lineType != 2) {
            bankStatementLineAFB120.setAmountRemainToReconcile(BigDecimal.ZERO);
        }
        if (!Strings.isNullOrEmpty((String)unavailabilityIndexSelect)) {
            bankStatementLineAFB120.setUnavailabilityIndexSelect(Integer.parseInt(unavailabilityIndexSelect));
        }
        if (!Strings.isNullOrEmpty((String)commissionExemptionIndexSelect)) {
            bankStatementLineAFB120.setCommissionExemptionIndexSelect(Integer.parseInt(commissionExemptionIndexSelect));
        }
        return bankStatementLineAFB120;
    }
}

