/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.batch;

import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCreateService;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderMergeService;
import com.axelor.apps.bankpayment.service.batch.BatchDirectDebit;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.repo.BankDetailsRepository;
import com.axelor.apps.base.db.repo.BlockingRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.JPA;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchDirectDebitCustomerInvoice
extends BatchDirectDebit {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    protected void process() {
        List<InvoicePayment> invoicePaymentList;
        AccountingBatch accountingBatch = this.batch.getAccountingBatch();
        ArrayList<String> filterList = new ArrayList<String>();
        ArrayList<Pair<String, Object>> bindingList = new ArrayList<Pair<String, Object>>();
        filterList.add("self.operationTypeSelect = :operationTypeSelect");
        bindingList.add(Pair.of((Object)"operationTypeSelect", (Object)3));
        filterList.add("self.statusSelect = :statusSelect");
        bindingList.add(Pair.of((Object)"statusSelect", (Object)3));
        filterList.add("self.amountRemaining > 0");
        filterList.add("self.hasPendingPayments = FALSE");
        LocalDate dueDate = accountingBatch.getDueDate() != null ? accountingBatch.getDueDate() : ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate();
        filterList.add("self.dueDate <= :dueDate");
        bindingList.add(Pair.of((Object)"dueDate", (Object)dueDate));
        if (accountingBatch.getCompany() != null) {
            filterList.add("self.company = :company");
            bindingList.add(Pair.of((Object)"company", (Object)((Object)accountingBatch.getCompany())));
        }
        filterList.add("self.partner.id NOT IN (SELECT DISTINCT partner.id FROM Partner partner LEFT JOIN partner.blockingList blocking WHERE blocking.blockingSelect = :blockingSelect AND blocking.blockingToDate >= :blockingToDate)");
        bindingList.add(Pair.of((Object)"blockingSelect", (Object)BlockingRepository.DEBIT_BLOCKING));
        bindingList.add(Pair.of((Object)"blockingToDate", (Object)((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate()));
        if (accountingBatch.getBankDetails() != null) {
            HashSet bankDetailsSet = Sets.newHashSet((Object[])new BankDetails[]{accountingBatch.getBankDetails()});
            if (accountingBatch.getIncludeOtherBankAccounts().booleanValue() && this.appBaseService.getAppBase().getManageMultiBanks().booleanValue()) {
                bankDetailsSet.addAll(accountingBatch.getCompany().getBankDetailsSet());
            }
            filterList.add("self.companyBankDetails IN (:bankDetailsSet)");
            bindingList.add((Pair<String, Object>)Pair.of((Object)"bankDetailsSet", (Object)bankDetailsSet));
        }
        if (accountingBatch.getPaymentMode() != null) {
            filterList.add("self.paymentMode = :paymentMode");
            bindingList.add((Pair<String, Object>)Pair.of((Object)"paymentMode", (Object)((Object)accountingBatch.getPaymentMode())));
        }
        if (!(invoicePaymentList = this.processQuery(filterList, bindingList)).isEmpty()) {
            try {
                BankOrder bankOrder = ((BankOrderMergeService)Beans.get(BankOrderMergeService.class)).mergeFromInvoicePayments(invoicePaymentList);
                this.findBatch().setBankOrder(bankOrder);
            }
            catch (AxelorException e) {
                TraceBackService.trace((AxelorException)e, (String)"directDebit", (long)this.batch.getId());
                LOG.error(e.getMessage());
            }
        }
    }

    private List<InvoicePayment> processQuery(List<String> filterList, List<Pair<String, Object>> bindingList) {
        List invoiceList;
        ArrayList<InvoicePayment> doneList = new ArrayList<InvoicePayment>();
        ArrayList anomalyList = Lists.newArrayList((Object[])new Long[]{0L});
        filterList.add("self.id NOT IN (:anomalyList)");
        bindingList.add((Pair<String, Object>)Pair.of((Object)"anomalyList", (Object)anomalyList));
        String filter = Joiner.on((String)" AND ").join((Iterable)Lists.transform(filterList, (Function)new Function<String, String>(){

            public String apply(String input) {
                return String.format("(%s)", input);
            }
        }));
        Query query = ((InvoiceRepository)Beans.get(InvoiceRepository.class)).all().filter(filter);
        for (Pair<String, Object> binding : bindingList) {
            query.bind((String)binding.getLeft(), binding.getRight());
        }
        HashSet<Long> treatedSet = new HashSet<Long>();
        InvoicePaymentCreateService invoicePaymentCreateService = (InvoicePaymentCreateService)Beans.get(InvoicePaymentCreateService.class);
        BankDetailsRepository bankDetailsRepo = (BankDetailsRepository)((Object)Beans.get(BankDetailsRepository.class));
        BankDetails companyBankDetails = this.getCompanyBankDetails(this.batch.getAccountingBatch());
        while (!(invoiceList = query.fetch(10)).isEmpty()) {
            if (!JPA.em().contains((Object)companyBankDetails)) {
                companyBankDetails = (BankDetails)((Object)bankDetailsRepo.find(companyBankDetails.getId()));
            }
            for (Invoice invoice : invoiceList) {
                if (treatedSet.contains(invoice.getId())) {
                    throw new IllegalArgumentException("Invoice payment generation error");
                }
                treatedSet.add(invoice.getId());
                try {
                    doneList.add(invoicePaymentCreateService.createInvoicePayment(invoice, companyBankDetails));
                    this.incrementDone();
                }
                catch (Exception e) {
                    this.incrementAnomaly();
                    anomalyList.add(invoice.getId());
                    query.bind("anomalyList", (Object)anomalyList);
                    TraceBackService.trace((Throwable)e, (String)"directDebit", (long)this.batch.getId());
                    LOG.error(e.getMessage());
                    break;
                }
            }
            JPA.clear();
        }
        return doneList;
    }
}

