/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.config;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.bankpayment.db.BankPaymentConfig;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Sequence;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.common.base.Strings;

public class BankPaymentConfigService {
    public BankPaymentConfig getBankPaymentConfig(Company company) throws AxelorException {
        BankPaymentConfig bankPaymentConfig = company.getBankPaymentConfig();
        if (bankPaymentConfig == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure bank payment's information for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
        return bankPaymentConfig;
    }

    public Account getExternalBankToBankAccount(BankPaymentConfig bankPaymentConfig) throws AxelorException {
        if (bankPaymentConfig.getExternalBankToBankAccount() == null) {
            throw new AxelorException((Model)((Object)bankPaymentConfig), 4, I18n.get((String)"%s : Please, configure an account for the bank order for the external bank to bank transfer for the company %s"), new Object[]{I18n.get((String)"Warning !"), bankPaymentConfig.getCompany().getName()});
        }
        return bankPaymentConfig.getExternalBankToBankAccount();
    }

    public Account getInternalBankToBankAccount(BankPaymentConfig bankPaymentConfig) throws AxelorException {
        if (bankPaymentConfig.getInternalBankToBankAccount() == null) {
            throw new AxelorException((Model)((Object)bankPaymentConfig), 4, I18n.get((String)"%s : Please, configure an account for the bank order for the internal bank to bank transfer for the company %s"), new Object[]{I18n.get((String)"Warning !"), bankPaymentConfig.getCompany().getName()});
        }
        return bankPaymentConfig.getInternalBankToBankAccount();
    }

    public Sequence getSepaCreditTransSequence(BankPaymentConfig bankPaymentConfig) throws AxelorException {
        if (bankPaymentConfig.getSepaCreditTransSequence() == null) {
            throw new AxelorException((Model)((Object)bankPaymentConfig), 4, I18n.get((String)"%s : Please, configure a sequence for the SEPA Credit Transfers and the company %s"), new Object[]{I18n.get((String)"Warning !"), bankPaymentConfig.getCompany().getName()});
        }
        return bankPaymentConfig.getSepaCreditTransSequence();
    }

    public Sequence getSepaDirectDebitSequence(BankPaymentConfig bankPaymentConfig) throws AxelorException {
        if (bankPaymentConfig.getSepaDirectDebitSequence() == null) {
            throw new AxelorException((Model)((Object)bankPaymentConfig), 4, I18n.get((String)"%s : Please, configure a sequence for the SEPA Direct Debits and the company %s"), new Object[]{I18n.get((String)"Warning !"), bankPaymentConfig.getCompany().getName()});
        }
        return bankPaymentConfig.getSepaDirectDebitSequence();
    }

    public Sequence getIntCreditTransSequence(BankPaymentConfig bankPaymentConfig) throws AxelorException {
        if (bankPaymentConfig.getIntCreditTransSequence() == null) {
            throw new AxelorException((Model)((Object)bankPaymentConfig), 4, I18n.get((String)"%s : Please, configure a sequence for the International Credit Transfers and the company %s"), new Object[]{I18n.get((String)"Warning !"), bankPaymentConfig.getCompany().getName()});
        }
        return bankPaymentConfig.getIntCreditTransSequence();
    }

    public Sequence getIntDirectDebitSequence(BankPaymentConfig bankPaymentConfig) throws AxelorException {
        if (bankPaymentConfig.getIntDirectDebitSequence() == null) {
            throw new AxelorException((Model)((Object)bankPaymentConfig), 4, I18n.get((String)"%s : Please, configure a sequence for the International Direct Debits and the company %s"), new Object[]{I18n.get((String)"Warning !"), bankPaymentConfig.getCompany().getName()});
        }
        return bankPaymentConfig.getIntDirectDebitSequence();
    }

    public Sequence getNatTreasuryTransSequence(BankPaymentConfig bankPaymentConfig) throws AxelorException {
        if (bankPaymentConfig.getNatTreasuryTransSequence() == null) {
            throw new AxelorException((Model)((Object)bankPaymentConfig), 4, I18n.get((String)"%s : Please, configure a sequence for the International Treasury Transfers and the company %s"), new Object[]{I18n.get((String)"Warning !"), bankPaymentConfig.getCompany().getName()});
        }
        return bankPaymentConfig.getNatTreasuryTransSequence();
    }

    public Sequence getIntTreasuryTransSequence(BankPaymentConfig bankPaymentConfig) throws AxelorException {
        if (bankPaymentConfig.getIntTreasuryTransSequence() == null) {
            throw new AxelorException((Model)((Object)bankPaymentConfig), 4, I18n.get((String)"%s : Please, configure a sequence for the National Treasury Transfers and the company %s"), new Object[]{I18n.get((String)"Warning !"), bankPaymentConfig.getCompany().getName()});
        }
        return bankPaymentConfig.getIntTreasuryTransSequence();
    }

    public Sequence getOtherBankOrderSequence(BankPaymentConfig bankPaymentConfig) throws AxelorException {
        if (bankPaymentConfig.getOtherBankOrderSequence() == null) {
            throw new AxelorException((Model)((Object)bankPaymentConfig), 4, I18n.get((String)"%s : Please, configure a sequence for the Other Bank Orders and the company %s"), new Object[]{I18n.get((String)"Warning !"), bankPaymentConfig.getCompany().getName()});
        }
        return bankPaymentConfig.getOtherBankOrderSequence();
    }

    public User getDefaultSignatoryUser(BankPaymentConfig bankPaymentConfig) throws AxelorException {
        if (bankPaymentConfig.getDefaultSignatoryUser() == null) {
            throw new AxelorException((Model)((Object)bankPaymentConfig), 4, I18n.get((String)"%s : Please, configure a default signer for the company %s"), new Object[]{I18n.get((String)"Warning !"), bankPaymentConfig.getCompany().getName()});
        }
        return bankPaymentConfig.getDefaultSignatoryUser();
    }

    public String getIcsNumber(BankPaymentConfig bankPaymentConfig) throws AxelorException {
        if (Strings.isNullOrEmpty((String)bankPaymentConfig.getIcsNumber())) {
            throw new AxelorException((Model)((Object)bankPaymentConfig), 4, I18n.get((String)"%s : Please configure an ICS number for the company %s."), new Object[]{I18n.get((String)"Warning !"), bankPaymentConfig.getCompany().getName()});
        }
        return bankPaymentConfig.getIcsNumber();
    }
}

