/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.invoice.payment;

import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveCancelService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCancelServiceImpl;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentToolService;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.service.app.AppBankPaymentService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoicePaymentCancelServiceBankPayImpl
extends InvoicePaymentCancelServiceImpl {
    protected BankOrderService bankOrderService;
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Inject
    public InvoicePaymentCancelServiceBankPayImpl(AccountConfigService accountConfigService, InvoicePaymentRepository invoicePaymentRepository, MoveCancelService moveCancelService, ReconcileService reconcileService, BankOrderService bankOrderService, InvoicePaymentToolService invoicePaymentToolService) {
        super(accountConfigService, invoicePaymentRepository, moveCancelService, reconcileService, invoicePaymentToolService);
        this.bankOrderService = bankOrderService;
    }

    @Transactional(rollbackOn={Exception.class})
    public void cancel(InvoicePayment invoicePayment) throws AxelorException {
        if (!((AppBankPaymentService)Beans.get(AppBankPaymentService.class)).isApp("bank-payment")) {
            super.cancel(invoicePayment);
            return;
        }
        BankOrder paymentBankOrder = invoicePayment.getBankOrder();
        if (paymentBankOrder != null) {
            if (paymentBankOrder.getStatusSelect() == 4 || paymentBankOrder.getStatusSelect() == 5) {
                throw new AxelorException((Model)((Object)invoicePayment), 1, I18n.get((String)"The bank order linked to this invoice payment has already been carried out/rejected, and thus can't be canceled"));
            }
            if (paymentBankOrder.getStatusSelect() != 6) {
                this.bankOrderService.cancelBankOrder(paymentBankOrder);
                this.updateCancelStatus(invoicePayment);
            }
        }
        super.cancel(invoicePayment);
    }
}

