/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.move;

import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.AccountCustomerService;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.move.MoveRemoveService;
import com.axelor.apps.bankpayment.service.app.AppBankPaymentService;
import com.axelor.apps.tool.service.ArchivingToolService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.math.BigDecimal;

public class MoveRemoveServiceBankPaymentImpl
extends MoveRemoveService {
    @Inject
    public MoveRemoveServiceBankPaymentImpl(MoveRepository moveRepo, MoveLineRepository moveLineRepo, ArchivingToolService archivingToolService, ReconcileService reconcileService, AccountingSituationService accountingSituationService, AccountCustomerService accountCustomerService) {
        super(moveRepo, moveLineRepo, archivingToolService, reconcileService, accountingSituationService, accountCustomerService);
    }

    protected String checkDaybookMoveLine(MoveLine moveLine) throws AxelorException {
        String errorMessage = super.checkDaybookMoveLine(moveLine);
        if (((AppBankPaymentService)Beans.get(AppBankPaymentService.class)).isApp("bank-payment") && moveLine.getBankReconciledAmount().compareTo(BigDecimal.ZERO) > 0) {
            errorMessage = errorMessage + String.format(I18n.get((String)"This move line %s can not be archived because its bank reconciliation amount is superior to 0."), moveLine.getName());
        }
        return errorMessage;
    }
}

