/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.web;

import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderLineService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class BankOrderLineController {
    public void setBankDetailsDomain(ActionRequest request, ActionResponse response) {
        BankOrderLine bankOrderLine = (BankOrderLine)((Object)request.getContext().asType(BankOrderLine.class));
        BankOrder bankOrder = (BankOrder)((Object)request.getContext().getParent().asType(BankOrder.class));
        String domain = ((BankOrderLineService)Beans.get(BankOrderLineService.class)).createDomainForBankDetails(bankOrderLine, bankOrder);
        if (domain.equals("")) {
            response.setAttr("receiverBankDetails", "domain", (Object)"self.id IN (0)");
        } else {
            response.setAttr("receiverBankDetails", "domain", (Object)domain);
        }
    }

    public void fillBankDetail(ActionRequest request, ActionResponse response) {
        BankOrderLine bankOrderLine = (BankOrderLine)((Object)request.getContext().asType(BankOrderLine.class));
        BankOrder bankOrder = (BankOrder)((Object)request.getContext().getParent().asType(BankOrder.class));
        BankDetails bankDetails = ((BankOrderLineService)Beans.get(BankOrderLineService.class)).getDefaultBankDetails(bankOrderLine, bankOrder);
        response.setValue("receiverBankDetails", (Object)bankDetails);
    }

    public void computeCompanyCurrencyAmount(ActionRequest request, ActionResponse response) {
        BankOrderLine bankOrderLine = (BankOrderLine)((Object)request.getContext().asType(BankOrderLine.class));
        BankOrder bankOrder = (BankOrder)((Object)request.getContext().getParent().asType(BankOrder.class));
        try {
            response.setValue("companyCurrencyAmount", (Object)((BankOrderLineService)Beans.get(BankOrderLineService.class)).computeCompanyCurrencyAmount(bankOrder, bankOrderLine));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

