/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.bankpayment.db.BankReconciliation;
import com.axelor.apps.bankpayment.db.BankReconciliationLine;
import com.axelor.apps.bankpayment.db.repo.BankReconciliationLineRepository;
import com.axelor.apps.bankpayment.db.repo.BankReconciliationRepository;
import com.axelor.apps.bankpayment.service.bankreconciliation.BankReconciliationService;
import com.axelor.apps.bankpayment.service.bankreconciliation.BankReconciliationValidateService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;

@Singleton
public class BankReconciliationController {
    public void loadBankStatement(ActionRequest request, ActionResponse response) {
        try {
            BankReconciliation bankReconciliation = (BankReconciliation)((Object)request.getContext().asType(BankReconciliation.class));
            ((BankReconciliationService)Beans.get(BankReconciliationService.class)).loadBankStatement((BankReconciliation)((Object)((BankReconciliationRepository)((Object)Beans.get(BankReconciliationRepository.class))).find(bankReconciliation.getId())));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void loadOtherBankStatement(ActionRequest request, ActionResponse response) {
        try {
            BankReconciliation bankReconciliation = (BankReconciliation)((Object)request.getContext().asType(BankReconciliation.class));
            bankReconciliation = (BankReconciliation)((Object)((BankReconciliationRepository)((Object)Beans.get(BankReconciliationRepository.class))).find(bankReconciliation.getId()));
            bankReconciliation.setIncludeOtherBankStatements(true);
            ((BankReconciliationService)Beans.get(BankReconciliationService.class)).loadBankStatement(bankReconciliation, false);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void compute(ActionRequest request, ActionResponse response) {
        try {
            BankReconciliation bankReconciliation = (BankReconciliation)((Object)request.getContext().asType(BankReconciliation.class));
            ((BankReconciliationService)Beans.get(BankReconciliationService.class)).compute((BankReconciliation)((Object)((BankReconciliationRepository)((Object)Beans.get(BankReconciliationRepository.class))).find(bankReconciliation.getId())));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validate(ActionRequest request, ActionResponse response) {
        try {
            BankReconciliation bankReconciliation = (BankReconciliation)((Object)request.getContext().asType(BankReconciliation.class));
            ((BankReconciliationValidateService)Beans.get(BankReconciliationValidateService.class)).validate((BankReconciliation)((Object)((BankReconciliationRepository)((Object)Beans.get(BankReconciliationRepository.class))).find(bankReconciliation.getId())));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validateMultipleReconcile(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            Map bankReconciliationContext = (Map)context.get((Object)"_bankReconciliation");
            BankReconciliation bankReconciliation = (BankReconciliation)((Object)((BankReconciliationRepository)((Object)Beans.get(BankReconciliationRepository.class))).find(((Integer)bankReconciliationContext.get("id")).longValue()));
            List moveLinesToReconcileContext = (List)context.get((Object)"toReconcileMoveLineSet");
            Map selectedBankReconciliationLineContext = (Map)context.get((Object)"_selectedBankReconciliationLine");
            BankReconciliationLine bankReconciliationLine = (BankReconciliationLine)((Object)((BankReconciliationLineRepository)((Object)Beans.get(BankReconciliationLineRepository.class))).find(((Integer)selectedBankReconciliationLineContext.get("id")).longValue()));
            ((BankReconciliationValidateService)Beans.get(BankReconciliationValidateService.class)).validateMultipleBankReconciles(bankReconciliation, bankReconciliationLine, moveLinesToReconcileContext);
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void setBankDetailsDomain(ActionRequest request, ActionResponse response) {
        BankReconciliation bankReconciliation = (BankReconciliation)((Object)request.getContext().asType(BankReconciliation.class));
        String domain = ((BankReconciliationService)Beans.get(BankReconciliationService.class)).createDomainForBankDetails(bankReconciliation);
        if (domain.equals("")) {
            response.setAttr("bankDetails", "domain", (Object)"self.id IN (0)");
        } else {
            response.setAttr("bankDetails", "domain", (Object)domain);
        }
    }

    public void printBankReconciliation(ActionRequest request, ActionResponse response) {
        BankReconciliation bankReconciliation = (BankReconciliation)((Object)request.getContext().asType(BankReconciliation.class));
        try {
            String fileLink = ReportFactory.createReport((String)"BankReconciliation.rptdesign", (String)"Bank Reconciliation-${date}").addParam("BankReconciliationId", (Object)bankReconciliation.getId()).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addFormat("pdf").toAttach((Model)((Object)bankReconciliation)).generate().getFileLink();
            response.setView(ActionView.define((String)"Bank Reconciliation").add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

