/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.web;

import com.axelor.apps.bankpayment.db.BankReconciliation;
import com.axelor.apps.bankpayment.db.BankStatement;
import com.axelor.apps.bankpayment.db.repo.BankStatementRepository;
import com.axelor.apps.bankpayment.service.bankreconciliation.BankReconciliationCreateService;
import com.axelor.apps.bankpayment.service.bankstatement.BankStatementService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Joiner;
import com.google.inject.Singleton;
import java.util.List;

@Singleton
public class BankStatementController {
    public void runImport(ActionRequest request, ActionResponse response) {
        try {
            BankStatement bankStatement = (BankStatement)((Object)request.getContext().asType(BankStatement.class));
            bankStatement = (BankStatement)((Object)((BankStatementRepository)((Object)Beans.get(BankStatementRepository.class))).find(bankStatement.getId()));
            ((BankStatementService)Beans.get(BankStatementService.class)).runImport(bankStatement, true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        response.setReload(true);
    }

    public void print(ActionRequest request, ActionResponse response) {
        try {
            BankStatement bankStatement = (BankStatement)((Object)request.getContext().asType(BankStatement.class));
            bankStatement = (BankStatement)((Object)((BankStatementRepository)((Object)Beans.get(BankStatementRepository.class))).find(bankStatement.getId()));
            String name = bankStatement.getName();
            String fileLink = ((BankStatementService)Beans.get(BankStatementService.class)).print(bankStatement);
            response.setView(ActionView.define((String)name).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        response.setReload(true);
    }

    public void runBankReconciliation(ActionRequest request, ActionResponse response) {
        try {
            BankStatement bankStatement = (BankStatement)((Object)request.getContext().asType(BankStatement.class));
            bankStatement = (BankStatement)((Object)((BankStatementRepository)((Object)Beans.get(BankStatementRepository.class))).find(bankStatement.getId()));
            List<BankReconciliation> bankReconciliationList = ((BankReconciliationCreateService)Beans.get(BankReconciliationCreateService.class)).createAllFromBankStatement(bankStatement);
            if (bankReconciliationList != null) {
                response.setView(ActionView.define((String)I18n.get((String)"Bank reconciliations")).model(BankReconciliation.class.getName()).add("grid", "bank-reconciliation-grid").add("form", "bank-reconciliation-form").domain("self.id in (" + Joiner.on((String)",").join(bankReconciliationList.stream().map(BankReconciliation::getId).toArray()) + ")").map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        response.setReload(true);
    }
}

