/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.web;

import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.account.db.repo.InterbankCodeLineRepository;
import com.axelor.apps.bankpayment.service.PaymentScheduleLineBankPaymentService;
import com.axelor.apps.base.db.Wizard;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Singleton
public class PaymentScheduleLineController {
    public void showRejectWizard(ActionRequest request, ActionResponse response) {
        try {
            Number id = (Number)request.getContext().get((Object)"id");
            List idList = id != null ? Lists.newArrayList((Object[])new Number[]{id}) : (List)MoreObjects.firstNonNull((Object)((List)request.getContext().get((Object)"_ids")), Collections.emptyList());
            if (idList.isEmpty()) {
                response.setError(I18n.get((String)"Please select at least one record."));
                return;
            }
            ActionView.ActionViewBuilder view = ActionView.define((String)I18n.get((String)"Payment schedule lines to reject")).model(Wizard.class.getName()).add("form", "payment-schedule-line-reject-wizard-form").param("popup", "reload").param("show-toolbar", Boolean.FALSE.toString()).param("show-confirm", Boolean.FALSE.toString()).param("popup-save", Boolean.FALSE.toString()).context("idList", idList);
            response.setView(view.map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void reject(ActionRequest request, ActionResponse response) {
        try {
            List idList = (List)MoreObjects.firstNonNull((Object)((List)request.getContext().get((Object)"idList")), Collections.emptyList());
            boolean represent = (Boolean)request.getContext().get((Object)"represent");
            Map interbankCodeLineMap = (Map)request.getContext().get((Object)"interbankCodeLine");
            InterbankCodeLine interbankCodeLine = interbankCodeLineMap != null ? (InterbankCodeLine)((InterbankCodeLineRepository)Beans.get(InterbankCodeLineRepository.class)).find(Long.valueOf(((Number)interbankCodeLineMap.get("id")).longValue())) : null;
            LinkedHashMap<Long, InterbankCodeLine> idMap = new LinkedHashMap<Long, InterbankCodeLine>();
            idList.stream().map(Number::longValue).forEach(id -> idMap.put((Long)id, interbankCodeLine));
            PaymentScheduleLineBankPaymentService paymentScheduleLineBankPaymentService = (PaymentScheduleLineBankPaymentService)Beans.get(PaymentScheduleLineBankPaymentService.class);
            if (idMap.size() == 1) {
                Map.Entry entry = idMap.entrySet().iterator().next();
                long id2 = (Long)entry.getKey();
                InterbankCodeLine rejectionReason = (InterbankCodeLine)entry.getValue();
                paymentScheduleLineBankPaymentService.reject(id2, rejectionReason, represent);
            } else {
                int errorCount = paymentScheduleLineBankPaymentService.rejectFromIdMap(idMap, represent);
                if (errorCount != 0) {
                    response.setError(String.format(I18n.get((String)"%d errors occurred. Please check tracebacks for details."), errorCount));
                    return;
                }
            }
            response.setFlash(String.format(I18n.get((String)"%d line successfully rejected", (String)"%d lines successfully rejected", (int)idMap.size()), idMap.size()));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

