/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AnalyticJournal;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.Year;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_ACCOUNTING_REPORT", uniqueConstraints={@UniqueConstraint(columnNames={"ref", "company"})}, indexes={@Index(columnList="ref"), @Index(columnList="company"), @Index(columnList="currency"), @Index(columnList="period"), @Index(columnList="journal"), @Index(columnList="payment_mode"), @Index(columnList="year"), @Index(columnList="analytic_journal")})
public class AccountingReport
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_ACCOUNTING_REPORT_SEQ")
    @SequenceGenerator(name="ACCOUNT_ACCOUNTING_REPORT_SEQ", sequenceName="ACCOUNT_ACCOUNTING_REPORT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Ref.")
    @NameColumn
    private String ref;
    @Widget(title="From")
    private LocalDate dateFrom;
    @Widget(title="To")
    private LocalDate dateTo;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Period")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Period period;
    @Widget(title="Journal")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal journal;
    @Widget(title="Payment Mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Accounting.Accounts")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Account> accountSet;
    @Widget(title="Export type", selection="iadministration.export.type.select")
    private String exportTypeSelect;
    @Widget(title="Printing output")
    @NotNull
    private Integer typeSelect = 0;
    @Widget(title="Partners")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Partner> partnerSet;
    @Widget(title="Fiscal year")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Year year;
    @Widget(title="Closing date")
    @NotNull
    @Column(name="date_val")
    private LocalDate date;
    @Widget(title="Last print date", readonly=true)
    private ZonedDateTime publicationDateTime;
    @Widget(title="Global")
    private Boolean global = Boolean.FALSE;
    @Widget(title="Subtotal by partner")
    private Boolean globalByPartner = Boolean.FALSE;
    @Widget(title="Subtotal by date")
    private Boolean globalByDate = Boolean.FALSE;
    @Widget(title="Analytic Journal")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticJournal analyticJournal;
    @Widget(title="Detailed")
    private Boolean detailed = Boolean.FALSE;
    @Widget(title="Status", readonly=true, selection="iaccount.accounting.report.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Total Debit", readonly=true)
    private BigDecimal totalDebit = BigDecimal.ZERO;
    @Widget(title="Total Credit", readonly=true)
    private BigDecimal totalCredit = BigDecimal.ZERO;
    @Widget(title="Balance", readonly=true)
    private BigDecimal balance = BigDecimal.ZERO;
    @Widget(title="Batchs")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Display closing accounting moves")
    private Boolean displayClosingAccountingMoves = Boolean.FALSE;
    @Widget(title="Display opening accounting moves")
    private Boolean displayOpeningAccountingMoves = Boolean.TRUE;
    @Widget(title="Display only not completely lettered move lines")
    private Boolean displayOnlyNotCompletelyLetteredMoveLines = Boolean.FALSE;
    @Widget(title="Display cumulative balance on printing")
    private Boolean displayCumulativeBalance = Boolean.FALSE;
    @Widget(title="Display column with accounting number")
    private Boolean displayCodeAccountColumnOnPrinting = Boolean.FALSE;
    @Widget(title="Display column with accounting name")
    private Boolean displayNameAccountColumnOnPrinting = Boolean.FALSE;
    @Widget(title="Display moveline sequence")
    private Boolean displayMoveLineSequenceOnPrinting = Boolean.FALSE;
    @Widget(title="Bank details")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<BankDetails> bankDetailsSet;
    @Widget(title="Journals")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Journal> journalSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public LocalDate getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(LocalDate dateFrom) {
        this.dateFrom = dateFrom;
    }

    public LocalDate getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(LocalDate dateTo) {
        this.dateTo = dateTo;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public Set<Account> getAccountSet() {
        return this.accountSet;
    }

    public void setAccountSet(Set<Account> accountSet) {
        this.accountSet = accountSet;
    }

    public void addAccountSetItem(Account item) {
        if (this.getAccountSet() == null) {
            this.setAccountSet(new HashSet());
        }
        this.getAccountSet().add(item);
    }

    public void removeAccountSetItem(Account item) {
        if (this.getAccountSet() == null) {
            return;
        }
        this.getAccountSet().remove(item);
    }

    public void clearAccountSet() {
        if (this.getAccountSet() != null) {
            this.getAccountSet().clear();
        }
    }

    public String getExportTypeSelect() {
        return this.exportTypeSelect;
    }

    public void setExportTypeSelect(String exportTypeSelect) {
        this.exportTypeSelect = exportTypeSelect;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Set<Partner> getPartnerSet() {
        return this.partnerSet;
    }

    public void setPartnerSet(Set<Partner> partnerSet) {
        this.partnerSet = partnerSet;
    }

    public void addPartnerSetItem(Partner item) {
        if (this.getPartnerSet() == null) {
            this.setPartnerSet(new HashSet());
        }
        this.getPartnerSet().add(item);
    }

    public void removePartnerSetItem(Partner item) {
        if (this.getPartnerSet() == null) {
            return;
        }
        this.getPartnerSet().remove(item);
    }

    public void clearPartnerSet() {
        if (this.getPartnerSet() != null) {
            this.getPartnerSet().clear();
        }
    }

    public Year getYear() {
        return this.year;
    }

    public void setYear(Year year) {
        this.year = year;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public ZonedDateTime getPublicationDateTime() {
        return this.publicationDateTime;
    }

    public void setPublicationDateTime(ZonedDateTime publicationDateTime) {
        this.publicationDateTime = publicationDateTime;
    }

    public Boolean getGlobal() {
        return this.global == null ? Boolean.FALSE : this.global;
    }

    public void setGlobal(Boolean global) {
        this.global = global;
    }

    public Boolean getGlobalByPartner() {
        return this.globalByPartner == null ? Boolean.FALSE : this.globalByPartner;
    }

    public void setGlobalByPartner(Boolean globalByPartner) {
        this.globalByPartner = globalByPartner;
    }

    public Boolean getGlobalByDate() {
        return this.globalByDate == null ? Boolean.FALSE : this.globalByDate;
    }

    public void setGlobalByDate(Boolean globalByDate) {
        this.globalByDate = globalByDate;
    }

    public AnalyticJournal getAnalyticJournal() {
        return this.analyticJournal;
    }

    public void setAnalyticJournal(AnalyticJournal analyticJournal) {
        this.analyticJournal = analyticJournal;
    }

    public Boolean getDetailed() {
        return this.detailed == null ? Boolean.FALSE : this.detailed;
    }

    public void setDetailed(Boolean detailed) {
        this.detailed = detailed;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public BigDecimal getTotalDebit() {
        return this.totalDebit == null ? BigDecimal.ZERO : this.totalDebit;
    }

    public void setTotalDebit(BigDecimal totalDebit) {
        this.totalDebit = totalDebit;
    }

    public BigDecimal getTotalCredit() {
        return this.totalCredit == null ? BigDecimal.ZERO : this.totalCredit;
    }

    public void setTotalCredit(BigDecimal totalCredit) {
        this.totalCredit = totalCredit;
    }

    public BigDecimal getBalance() {
        return this.balance == null ? BigDecimal.ZERO : this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove(item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public Boolean getDisplayClosingAccountingMoves() {
        return this.displayClosingAccountingMoves == null ? Boolean.FALSE : this.displayClosingAccountingMoves;
    }

    public void setDisplayClosingAccountingMoves(Boolean displayClosingAccountingMoves) {
        this.displayClosingAccountingMoves = displayClosingAccountingMoves;
    }

    public Boolean getDisplayOpeningAccountingMoves() {
        return this.displayOpeningAccountingMoves == null ? Boolean.FALSE : this.displayOpeningAccountingMoves;
    }

    public void setDisplayOpeningAccountingMoves(Boolean displayOpeningAccountingMoves) {
        this.displayOpeningAccountingMoves = displayOpeningAccountingMoves;
    }

    public Boolean getDisplayOnlyNotCompletelyLetteredMoveLines() {
        return this.displayOnlyNotCompletelyLetteredMoveLines == null ? Boolean.FALSE : this.displayOnlyNotCompletelyLetteredMoveLines;
    }

    public void setDisplayOnlyNotCompletelyLetteredMoveLines(Boolean displayOnlyNotCompletelyLetteredMoveLines) {
        this.displayOnlyNotCompletelyLetteredMoveLines = displayOnlyNotCompletelyLetteredMoveLines;
    }

    public Boolean getDisplayCumulativeBalance() {
        return this.displayCumulativeBalance == null ? Boolean.FALSE : this.displayCumulativeBalance;
    }

    public void setDisplayCumulativeBalance(Boolean displayCumulativeBalance) {
        this.displayCumulativeBalance = displayCumulativeBalance;
    }

    public Boolean getDisplayCodeAccountColumnOnPrinting() {
        return this.displayCodeAccountColumnOnPrinting == null ? Boolean.FALSE : this.displayCodeAccountColumnOnPrinting;
    }

    public void setDisplayCodeAccountColumnOnPrinting(Boolean displayCodeAccountColumnOnPrinting) {
        this.displayCodeAccountColumnOnPrinting = displayCodeAccountColumnOnPrinting;
    }

    public Boolean getDisplayNameAccountColumnOnPrinting() {
        return this.displayNameAccountColumnOnPrinting == null ? Boolean.FALSE : this.displayNameAccountColumnOnPrinting;
    }

    public void setDisplayNameAccountColumnOnPrinting(Boolean displayNameAccountColumnOnPrinting) {
        this.displayNameAccountColumnOnPrinting = displayNameAccountColumnOnPrinting;
    }

    public Boolean getDisplayMoveLineSequenceOnPrinting() {
        return this.displayMoveLineSequenceOnPrinting == null ? Boolean.FALSE : this.displayMoveLineSequenceOnPrinting;
    }

    public void setDisplayMoveLineSequenceOnPrinting(Boolean displayMoveLineSequenceOnPrinting) {
        this.displayMoveLineSequenceOnPrinting = displayMoveLineSequenceOnPrinting;
    }

    public Set<BankDetails> getBankDetailsSet() {
        return this.bankDetailsSet;
    }

    public void setBankDetailsSet(Set<BankDetails> bankDetailsSet) {
        this.bankDetailsSet = bankDetailsSet;
    }

    public void addBankDetailsSetItem(BankDetails item) {
        if (this.getBankDetailsSet() == null) {
            this.setBankDetailsSet(new HashSet());
        }
        this.getBankDetailsSet().add(item);
    }

    public void removeBankDetailsSetItem(BankDetails item) {
        if (this.getBankDetailsSet() == null) {
            return;
        }
        this.getBankDetailsSet().remove(item);
    }

    public void clearBankDetailsSet() {
        if (this.getBankDetailsSet() != null) {
            this.getBankDetailsSet().clear();
        }
    }

    public Set<Journal> getJournalSet() {
        return this.journalSet;
    }

    public void setJournalSet(Set<Journal> journalSet) {
        this.journalSet = journalSet;
    }

    public void addJournalSetItem(Journal item) {
        if (this.getJournalSet() == null) {
            this.setJournalSet(new HashSet());
        }
        this.getJournalSet().add(item);
    }

    public void removeJournalSetItem(Journal item) {
        if (this.getJournalSet() == null) {
            return;
        }
        this.getJournalSet().remove(item);
    }

    public void clearJournalSet() {
        if (this.getJournalSet() != null) {
            this.getJournalSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccountingReport)) {
            return false;
        }
        AccountingReport other = (AccountingReport)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("ref", (Object)this.getRef()).add("dateFrom", (Object)this.getDateFrom()).add("dateTo", (Object)this.getDateTo()).add("exportTypeSelect", (Object)this.getExportTypeSelect()).add("typeSelect", (Object)this.getTypeSelect()).add("date", (Object)this.getDate()).add("publicationDateTime", (Object)this.getPublicationDateTime()).add("global", (Object)this.getGlobal()).add("globalByPartner", (Object)this.getGlobalByPartner()).add("globalByDate", (Object)this.getGlobalByDate()).add("detailed", (Object)this.getDetailed()).omitNullValues().toString();
    }
}

