/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.DebtRecovery;
import com.axelor.apps.account.db.ReportedBalanceLine;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.message.db.Template;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="ACCOUNT_ACCOUNTING_SITUATION", indexes={@Index(columnList="company"), @Index(columnList="partner"), @Index(columnList="customer_account"), @Index(columnList="supplier_account"), @Index(columnList="employee_account"), @Index(columnList="company_in_bank_details"), @Index(columnList="company_out_bank_details"), @Index(columnList="invoice_message_template"), @Index(columnList="invoice_message_template_on_validate"), @Index(columnList="pfp_validator_user"), @Index(columnList="name")})
public class AccountingSituation
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_ACCOUNTING_SITUATION_SEQ")
    @SequenceGenerator(name="ACCOUNT_ACCOUNTING_SITUATION_SEQ", sequenceName="ACCOUNT_ACCOUNTING_SITUATION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Payer partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Customer account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account customerAccount;
    @Widget(title="Supplier account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account supplierAccount;
    @Widget(title="Employee account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account employeeAccount;
    @Widget(title="Total balance", readonly=true)
    private BigDecimal balanceCustAccount = BigDecimal.ZERO;
    @Widget(title="Due balance", readonly=true)
    private BigDecimal balanceDueCustAccount = BigDecimal.ZERO;
    @Widget(title="Due balance recoverable", readonly=true)
    private BigDecimal balanceDueDebtRecoveryCustAccount = BigDecimal.ZERO;
    @Widget(title="Partner situation must be updated")
    private Boolean custAccountMustBeUpdateOk = Boolean.FALSE;
    @Widget(title="Debt recovery")
    @OneToOne(fetch=FetchType.LAZY, mappedBy="accountingSituation", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DebtRecovery debtRecovery;
    @Widget(title="Company bank for in payment mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails companyInBankDetails;
    @Widget(title="Company bank for out payment mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails companyOutBankDetails;
    @Widget(title="Batchs")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Send email on invoice ventilation")
    private Boolean invoiceAutomaticMail = Boolean.FALSE;
    @Widget(title="Message template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template invoiceMessageTemplate;
    @Widget(title="Send email on invoice validate")
    private Boolean invoiceAutomaticMailOnValidate = Boolean.FALSE;
    @Widget(title="Message template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template invoiceMessageTemplateOnValidate;
    @Widget(title="Reported balance lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="accountingSituation", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ReportedBalanceLine> reportedBalanceLineList;
    @Widget(title="PFP Validator")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User pfpValidatorUser;
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String name;
    @Widget(title="Accepted Credit")
    @Digits(integer=18, fraction=2)
    private BigDecimal acceptedCredit = BigDecimal.ZERO;
    @Widget(title="Used Credit", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal usedCredit = BigDecimal.ZERO;
    @Widget(title="Insurance date credit")
    private LocalDate insurCreditDate;
    @Widget(title="Comment")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public AccountingSituation() {
    }

    public AccountingSituation(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Account getCustomerAccount() {
        return this.customerAccount;
    }

    public void setCustomerAccount(Account customerAccount) {
        this.customerAccount = customerAccount;
    }

    public Account getSupplierAccount() {
        return this.supplierAccount;
    }

    public void setSupplierAccount(Account supplierAccount) {
        this.supplierAccount = supplierAccount;
    }

    public Account getEmployeeAccount() {
        return this.employeeAccount;
    }

    public void setEmployeeAccount(Account employeeAccount) {
        this.employeeAccount = employeeAccount;
    }

    public BigDecimal getBalanceCustAccount() {
        return this.balanceCustAccount == null ? BigDecimal.ZERO : this.balanceCustAccount;
    }

    public void setBalanceCustAccount(BigDecimal balanceCustAccount) {
        this.balanceCustAccount = balanceCustAccount;
    }

    public BigDecimal getBalanceDueCustAccount() {
        return this.balanceDueCustAccount == null ? BigDecimal.ZERO : this.balanceDueCustAccount;
    }

    public void setBalanceDueCustAccount(BigDecimal balanceDueCustAccount) {
        this.balanceDueCustAccount = balanceDueCustAccount;
    }

    public BigDecimal getBalanceDueDebtRecoveryCustAccount() {
        return this.balanceDueDebtRecoveryCustAccount == null ? BigDecimal.ZERO : this.balanceDueDebtRecoveryCustAccount;
    }

    public void setBalanceDueDebtRecoveryCustAccount(BigDecimal balanceDueDebtRecoveryCustAccount) {
        this.balanceDueDebtRecoveryCustAccount = balanceDueDebtRecoveryCustAccount;
    }

    public Boolean getCustAccountMustBeUpdateOk() {
        return this.custAccountMustBeUpdateOk == null ? Boolean.FALSE : this.custAccountMustBeUpdateOk;
    }

    public void setCustAccountMustBeUpdateOk(Boolean custAccountMustBeUpdateOk) {
        this.custAccountMustBeUpdateOk = custAccountMustBeUpdateOk;
    }

    public DebtRecovery getDebtRecovery() {
        return this.debtRecovery;
    }

    public void setDebtRecovery(DebtRecovery debtRecovery) {
        this.debtRecovery = debtRecovery;
    }

    public BankDetails getCompanyInBankDetails() {
        return this.companyInBankDetails;
    }

    public void setCompanyInBankDetails(BankDetails companyInBankDetails) {
        this.companyInBankDetails = companyInBankDetails;
    }

    public BankDetails getCompanyOutBankDetails() {
        return this.companyOutBankDetails;
    }

    public void setCompanyOutBankDetails(BankDetails companyOutBankDetails) {
        this.companyOutBankDetails = companyOutBankDetails;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove(item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public Boolean getInvoiceAutomaticMail() {
        return this.invoiceAutomaticMail == null ? Boolean.FALSE : this.invoiceAutomaticMail;
    }

    public void setInvoiceAutomaticMail(Boolean invoiceAutomaticMail) {
        this.invoiceAutomaticMail = invoiceAutomaticMail;
    }

    public Template getInvoiceMessageTemplate() {
        return this.invoiceMessageTemplate;
    }

    public void setInvoiceMessageTemplate(Template invoiceMessageTemplate) {
        this.invoiceMessageTemplate = invoiceMessageTemplate;
    }

    public Boolean getInvoiceAutomaticMailOnValidate() {
        return this.invoiceAutomaticMailOnValidate == null ? Boolean.FALSE : this.invoiceAutomaticMailOnValidate;
    }

    public void setInvoiceAutomaticMailOnValidate(Boolean invoiceAutomaticMailOnValidate) {
        this.invoiceAutomaticMailOnValidate = invoiceAutomaticMailOnValidate;
    }

    public Template getInvoiceMessageTemplateOnValidate() {
        return this.invoiceMessageTemplateOnValidate;
    }

    public void setInvoiceMessageTemplateOnValidate(Template invoiceMessageTemplateOnValidate) {
        this.invoiceMessageTemplateOnValidate = invoiceMessageTemplateOnValidate;
    }

    public List<ReportedBalanceLine> getReportedBalanceLineList() {
        return this.reportedBalanceLineList;
    }

    public void setReportedBalanceLineList(List<ReportedBalanceLine> reportedBalanceLineList) {
        this.reportedBalanceLineList = reportedBalanceLineList;
    }

    public void addReportedBalanceLineListItem(ReportedBalanceLine item) {
        if (this.getReportedBalanceLineList() == null) {
            this.setReportedBalanceLineList(new ArrayList());
        }
        this.getReportedBalanceLineList().add(item);
        item.setAccountingSituation(this);
    }

    public void removeReportedBalanceLineListItem(ReportedBalanceLine item) {
        if (this.getReportedBalanceLineList() == null) {
            return;
        }
        this.getReportedBalanceLineList().remove(item);
    }

    public void clearReportedBalanceLineList() {
        if (this.getReportedBalanceLineList() != null) {
            this.getReportedBalanceLineList().clear();
        }
    }

    public User getPfpValidatorUser() {
        return this.pfpValidatorUser;
    }

    public void setPfpValidatorUser(User pfpValidatorUser) {
        this.pfpValidatorUser = pfpValidatorUser;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        String name = "";
        if (this.partner != null) {
            if (this.partner.getFullName() != null) {
                name = this.partner.getPartnerSeq() != null ? name + this.partner.getFullName() + " (" + this.partner.getPartnerSeq() + ")" : name + this.partner.getFullName();
            } else if (this.partner.getPartnerSeq() != null) {
                name = name + "(" + this.partner.getPartnerSeq() + ")";
            }
        }
        if (this.company != null) {
            name = name + (name.isEmpty() ? "" : "-") + this.company.getName();
        }
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getAcceptedCredit() {
        return this.acceptedCredit == null ? BigDecimal.ZERO : this.acceptedCredit;
    }

    public void setAcceptedCredit(BigDecimal acceptedCredit) {
        this.acceptedCredit = acceptedCredit;
    }

    public BigDecimal getUsedCredit() {
        return this.usedCredit == null ? BigDecimal.ZERO : this.usedCredit;
    }

    public void setUsedCredit(BigDecimal usedCredit) {
        this.usedCredit = usedCredit;
    }

    public LocalDate getInsurCreditDate() {
        return this.insurCreditDate;
    }

    public void setInsurCreditDate(LocalDate insurCreditDate) {
        this.insurCreditDate = insurCreditDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccountingSituation)) {
            return false;
        }
        AccountingSituation other = (AccountingSituation)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("balanceCustAccount", (Object)this.getBalanceCustAccount()).add("balanceDueCustAccount", (Object)this.getBalanceDueCustAccount()).add("balanceDueDebtRecoveryCustAccount", (Object)this.getBalanceDueDebtRecoveryCustAccount()).add("custAccountMustBeUpdateOk", (Object)this.getCustAccountMustBeUpdateOk()).add("invoiceAutomaticMail", (Object)this.getInvoiceAutomaticMail()).add("invoiceAutomaticMailOnValidate", (Object)this.getInvoiceAutomaticMailOnValidate()).add("acceptedCredit", (Object)this.getAcceptedCredit()).add("usedCredit", (Object)this.getUsedCredit()).add("insurCreditDate", (Object)this.getInsurCreditDate()).omitNullValues().toString();
    }
}

