/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrderDuration;
import com.axelor.apps.production.db.ProdHumanResource;
import com.axelor.apps.production.db.ProdProcessLine;
import com.axelor.apps.production.db.ProdProduct;
import com.axelor.apps.production.db.WorkCenter;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="PRODUCTION_OPERATION_ORDER", indexes={@Index(columnList="name"), @Index(columnList="manuf_order"), @Index(columnList="work_center"), @Index(columnList="machine_work_center"), @Index(columnList="prod_process_line"), @Index(columnList="bar_code")})
public class OperationOrder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_OPERATION_ORDER_SEQ")
    @SequenceGenerator(name="PRODUCTION_OPERATION_ORDER_SEQ", sequenceName="PRODUCTION_OPERATION_ORDER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Priority")
    private Integer priority = 0;
    @Widget(title="Name")
    private String name;
    @Widget(title="Operation name")
    private String operationName;
    @Widget(title="Manufacturing order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ManufOrder manufOrder;
    @Widget(title="Work center")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WorkCenter workCenter;
    @Widget(title="Machine")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WorkCenter machineWorkCenter;
    @Widget(title="Human resources")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="operationOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProdHumanResource> prodHumanResourceList;
    @Widget(title="Products to consume")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="toConsumeOperationOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProdProduct> toConsumeProdProductList;
    @Widget(title="Consumed products")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="consumedOperationOrder", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<StockMoveLine> consumedStockMoveLineList;
    @Widget(title="Differences")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="diffConsumeOperationOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProdProduct> diffConsumeProdProductList;
    @Widget(title="Status", selection="production.manuf.order.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Operation")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProdProcessLine prodProcessLine;
    @Widget(title="Planned start")
    private LocalDateTime plannedStartDateT;
    @Widget(title="Planned end")
    private LocalDateTime plannedEndDateT;
    @Widget(title="Real start")
    private LocalDateTime realStartDateT;
    @Widget(title="Real end")
    private LocalDateTime realEndDateT;
    @Widget(title="Stock move in")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="inOperationOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<StockMove> inStockMoveList;
    @Widget(title="Planned duration (hh:mm:ss)")
    private Long plannedDuration = 0L;
    @Widget(title="Real duration (hh:mm:ss)")
    private Long realDuration = 0L;
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private Boolean isWithDifference = Boolean.FALSE;
    @Widget(title="Operation Order Durations")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="operationOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<OperationOrderDuration> operationOrderDurationList;
    @Widget(title="Comments")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String comments;
    @Widget(title="Barcode", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile barCode;
    @Widget(title="To invoice")
    private Boolean isToInvoice = Boolean.FALSE;
    @Widget(title="Timesheet lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="operationOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TimesheetLine> timesheetLineList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public OperationOrder() {
    }

    public OperationOrder(Integer priority, String name, String operationName, ManufOrder manufOrder, WorkCenter workCenter, WorkCenter machineWorkCenter, Integer statusSelect, ProdProcessLine prodProcessLine) {
        this.priority = priority;
        this.name = name;
        this.operationName = operationName;
        this.manufOrder = manufOrder;
        this.workCenter = workCenter;
        this.machineWorkCenter = machineWorkCenter;
        this.statusSelect = statusSelect;
        this.prodProcessLine = prodProcessLine;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public ManufOrder getManufOrder() {
        return this.manufOrder;
    }

    public void setManufOrder(ManufOrder manufOrder) {
        this.manufOrder = manufOrder;
    }

    public WorkCenter getWorkCenter() {
        return this.workCenter;
    }

    public void setWorkCenter(WorkCenter workCenter) {
        this.workCenter = workCenter;
    }

    public WorkCenter getMachineWorkCenter() {
        return this.machineWorkCenter;
    }

    public void setMachineWorkCenter(WorkCenter machineWorkCenter) {
        this.machineWorkCenter = machineWorkCenter;
    }

    public List<ProdHumanResource> getProdHumanResourceList() {
        return this.prodHumanResourceList;
    }

    public void setProdHumanResourceList(List<ProdHumanResource> prodHumanResourceList) {
        this.prodHumanResourceList = prodHumanResourceList;
    }

    public void addProdHumanResourceListItem(ProdHumanResource item) {
        if (this.getProdHumanResourceList() == null) {
            this.setProdHumanResourceList(new ArrayList());
        }
        this.getProdHumanResourceList().add(item);
        item.setOperationOrder(this);
    }

    public void removeProdHumanResourceListItem(ProdHumanResource item) {
        if (this.getProdHumanResourceList() == null) {
            return;
        }
        this.getProdHumanResourceList().remove(item);
    }

    public void clearProdHumanResourceList() {
        if (this.getProdHumanResourceList() != null) {
            this.getProdHumanResourceList().clear();
        }
    }

    public List<ProdProduct> getToConsumeProdProductList() {
        return this.toConsumeProdProductList;
    }

    public void setToConsumeProdProductList(List<ProdProduct> toConsumeProdProductList) {
        this.toConsumeProdProductList = toConsumeProdProductList;
    }

    public void addToConsumeProdProductListItem(ProdProduct item) {
        if (this.getToConsumeProdProductList() == null) {
            this.setToConsumeProdProductList(new ArrayList());
        }
        this.getToConsumeProdProductList().add(item);
        item.setToConsumeOperationOrder(this);
    }

    public void removeToConsumeProdProductListItem(ProdProduct item) {
        if (this.getToConsumeProdProductList() == null) {
            return;
        }
        this.getToConsumeProdProductList().remove(item);
    }

    public void clearToConsumeProdProductList() {
        if (this.getToConsumeProdProductList() != null) {
            this.getToConsumeProdProductList().clear();
        }
    }

    public List<StockMoveLine> getConsumedStockMoveLineList() {
        return this.consumedStockMoveLineList;
    }

    public void setConsumedStockMoveLineList(List<StockMoveLine> consumedStockMoveLineList) {
        this.consumedStockMoveLineList = consumedStockMoveLineList;
    }

    public void addConsumedStockMoveLineListItem(StockMoveLine item) {
        if (this.getConsumedStockMoveLineList() == null) {
            this.setConsumedStockMoveLineList(new ArrayList());
        }
        this.getConsumedStockMoveLineList().add(item);
        item.setConsumedOperationOrder(this);
    }

    public void removeConsumedStockMoveLineListItem(StockMoveLine item) {
        if (this.getConsumedStockMoveLineList() == null) {
            return;
        }
        this.getConsumedStockMoveLineList().remove(item);
        item.setConsumedOperationOrder(null);
    }

    public void clearConsumedStockMoveLineList() {
        if (this.getConsumedStockMoveLineList() != null) {
            for (StockMoveLine item : this.getConsumedStockMoveLineList()) {
                item.setConsumedOperationOrder(null);
            }
            this.getConsumedStockMoveLineList().clear();
        }
    }

    public List<ProdProduct> getDiffConsumeProdProductList() {
        return this.diffConsumeProdProductList;
    }

    public void setDiffConsumeProdProductList(List<ProdProduct> diffConsumeProdProductList) {
        this.diffConsumeProdProductList = diffConsumeProdProductList;
    }

    public void addDiffConsumeProdProductListItem(ProdProduct item) {
        if (this.getDiffConsumeProdProductList() == null) {
            this.setDiffConsumeProdProductList(new ArrayList());
        }
        this.getDiffConsumeProdProductList().add(item);
        item.setDiffConsumeOperationOrder(this);
    }

    public void removeDiffConsumeProdProductListItem(ProdProduct item) {
        if (this.getDiffConsumeProdProductList() == null) {
            return;
        }
        this.getDiffConsumeProdProductList().remove(item);
    }

    public void clearDiffConsumeProdProductList() {
        if (this.getDiffConsumeProdProductList() != null) {
            this.getDiffConsumeProdProductList().clear();
        }
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public ProdProcessLine getProdProcessLine() {
        return this.prodProcessLine;
    }

    public void setProdProcessLine(ProdProcessLine prodProcessLine) {
        this.prodProcessLine = prodProcessLine;
    }

    public LocalDateTime getPlannedStartDateT() {
        return this.plannedStartDateT;
    }

    public void setPlannedStartDateT(LocalDateTime plannedStartDateT) {
        this.plannedStartDateT = plannedStartDateT;
    }

    public LocalDateTime getPlannedEndDateT() {
        return this.plannedEndDateT;
    }

    public void setPlannedEndDateT(LocalDateTime plannedEndDateT) {
        this.plannedEndDateT = plannedEndDateT;
    }

    public LocalDateTime getRealStartDateT() {
        return this.realStartDateT;
    }

    public void setRealStartDateT(LocalDateTime realStartDateT) {
        this.realStartDateT = realStartDateT;
    }

    public LocalDateTime getRealEndDateT() {
        return this.realEndDateT;
    }

    public void setRealEndDateT(LocalDateTime realEndDateT) {
        this.realEndDateT = realEndDateT;
    }

    public List<StockMove> getInStockMoveList() {
        return this.inStockMoveList;
    }

    public void setInStockMoveList(List<StockMove> inStockMoveList) {
        this.inStockMoveList = inStockMoveList;
    }

    public void addInStockMoveListItem(StockMove item) {
        if (this.getInStockMoveList() == null) {
            this.setInStockMoveList(new ArrayList());
        }
        this.getInStockMoveList().add(item);
        item.setInOperationOrder(this);
    }

    public void removeInStockMoveListItem(StockMove item) {
        if (this.getInStockMoveList() == null) {
            return;
        }
        this.getInStockMoveList().remove(item);
    }

    public void clearInStockMoveList() {
        if (this.getInStockMoveList() != null) {
            this.getInStockMoveList().clear();
        }
    }

    public Long getPlannedDuration() {
        return this.plannedDuration == null ? 0L : this.plannedDuration;
    }

    public void setPlannedDuration(Long plannedDuration) {
        this.plannedDuration = plannedDuration;
    }

    public Long getRealDuration() {
        return this.realDuration == null ? 0L : this.realDuration;
    }

    public void setRealDuration(Long realDuration) {
        this.realDuration = realDuration;
    }

    public Boolean getIsWithDifference() {
        try {
            this.isWithDifference = this.computeIsWithDifference();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("NPE in function field: getIsWithDifference()", (Throwable)e);
        }
        return this.isWithDifference;
    }

    protected Boolean computeIsWithDifference() {
        if (this.diffConsumeProdProductList == null || this.diffConsumeProdProductList.isEmpty()) {
            return false;
        }
        return true;
    }

    public void setIsWithDifference(Boolean isWithDifference) {
        this.isWithDifference = isWithDifference;
    }

    public List<OperationOrderDuration> getOperationOrderDurationList() {
        return this.operationOrderDurationList;
    }

    public void setOperationOrderDurationList(List<OperationOrderDuration> operationOrderDurationList) {
        this.operationOrderDurationList = operationOrderDurationList;
    }

    public void addOperationOrderDurationListItem(OperationOrderDuration item) {
        if (this.getOperationOrderDurationList() == null) {
            this.setOperationOrderDurationList(new ArrayList());
        }
        this.getOperationOrderDurationList().add(item);
        item.setOperationOrder(this);
    }

    public void removeOperationOrderDurationListItem(OperationOrderDuration item) {
        if (this.getOperationOrderDurationList() == null) {
            return;
        }
        this.getOperationOrderDurationList().remove(item);
    }

    public void clearOperationOrderDurationList() {
        if (this.getOperationOrderDurationList() != null) {
            this.getOperationOrderDurationList().clear();
        }
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public MetaFile getBarCode() {
        return this.barCode;
    }

    public void setBarCode(MetaFile barCode) {
        this.barCode = barCode;
    }

    public Boolean getIsToInvoice() {
        return this.isToInvoice == null ? Boolean.FALSE : this.isToInvoice;
    }

    public void setIsToInvoice(Boolean isToInvoice) {
        this.isToInvoice = isToInvoice;
    }

    public List<TimesheetLine> getTimesheetLineList() {
        return this.timesheetLineList;
    }

    public void setTimesheetLineList(List<TimesheetLine> timesheetLineList) {
        this.timesheetLineList = timesheetLineList;
    }

    public void addTimesheetLineListItem(TimesheetLine item) {
        if (this.getTimesheetLineList() == null) {
            this.setTimesheetLineList(new ArrayList());
        }
        this.getTimesheetLineList().add(item);
        item.setOperationOrder(this);
    }

    public void removeTimesheetLineListItem(TimesheetLine item) {
        if (this.getTimesheetLineList() == null) {
            return;
        }
        this.getTimesheetLineList().remove(item);
    }

    public void clearTimesheetLineList() {
        if (this.getTimesheetLineList() != null) {
            this.getTimesheetLineList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OperationOrder)) {
            return false;
        }
        OperationOrder other = (OperationOrder)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("priority", (Object)this.getPriority()).add("name", (Object)this.getName()).add("operationName", (Object)this.getOperationName()).add("statusSelect", (Object)this.getStatusSelect()).add("plannedStartDateT", (Object)this.getPlannedStartDateT()).add("plannedEndDateT", (Object)this.getPlannedEndDateT()).add("realStartDateT", (Object)this.getRealStartDateT()).add("realEndDateT", (Object)this.getRealEndDateT()).add("plannedDuration", (Object)this.getPlannedDuration()).add("realDuration", (Object)this.getRealDuration()).add("isToInvoice", (Object)this.getIsToInvoice()).omitNullValues().toString();
    }
}

