/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.base.db.Country;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.stock.db.CustomsCodeNomenclature;
import com.axelor.apps.stock.db.LogisticalFormLine;
import com.axelor.apps.stock.db.NatureOfTransaction;
import com.axelor.apps.stock.db.Regime;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="STOCK_STOCK_MOVE_LINE", indexes={@Index(columnList="stock_move"), @Index(columnList="planned_stock_move"), @Index(columnList="product"), @Index(columnList="unit"), @Index(columnList="tracking_number"), @Index(columnList="product_model"), @Index(columnList="productName"), @Index(columnList="name"), @Index(columnList="customs_code_nomenclature"), @Index(columnList="country_of_origin"), @Index(columnList="sale_order_line"), @Index(columnList="purchase_order_line"), @Index(columnList="consumed_manuf_order"), @Index(columnList="produced_manuf_order"), @Index(columnList="consumed_operation_order")})
@Track(fields={@TrackField(name="realQty"), @TrackField(name="requestedReservedQty"), @TrackField(name="reservedQty")})
public class StockMoveLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_STOCK_MOVE_LINE_SEQ")
    @SequenceGenerator(name="STOCK_STOCK_MOVE_LINE_SEQ", sequenceName="STOCK_STOCK_MOVE_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Stock move", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockMove stockMove;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockMove plannedStockMove;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Filter on available products")
    @Transient
    private Boolean filterOnAvailableProducts = Boolean.TRUE;
    @Widget(title="Expected Qty")
    @DecimalMin(value="0")
    @Digits(integer=10, fraction=10)
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Real Qty")
    @DecimalMin(value="0")
    @Digits(integer=10, fraction=10)
    private BigDecimal realQty = BigDecimal.ZERO;
    @Widget(hidden=true)
    @Digits(integer=10, fraction=10)
    private BigDecimal oldQty = BigDecimal.ZERO;
    @Widget(title="Available qty")
    @Digits(integer=10, fraction=10)
    @Transient
    private BigDecimal availableQty = BigDecimal.ZERO;
    @Widget(title="Available qty for product")
    @Digits(integer=10, fraction=10)
    @Transient
    private BigDecimal availableQtyForProduct = BigDecimal.ZERO;
    @Widget(title="Availability")
    @Transient
    private String availableStatus;
    @Widget(title="Status", selection="stock.move.line.available.status.select")
    @Transient
    private Integer availableStatusSelect = 0;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Net mass")
    @Digits(integer=10, fraction=10)
    private BigDecimal netMass = BigDecimal.ZERO;
    @Widget(title="Total net mass")
    private BigDecimal totalNetMass = BigDecimal.ZERO;
    @Widget(title="Tracking Nbr.")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TrackingNumber trackingNumber;
    @Widget(title="Conformity", selection="stock.move.line.conformity.select")
    private Integer conformitySelect = 0;
    @Widget(title="Shipped qty")
    @Digits(integer=10, fraction=10)
    private BigDecimal shippedQty = BigDecimal.ZERO;
    @Widget(title="Shipped date")
    private LocalDate shippedDate;
    @Widget(title="Product model")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product productModel;
    @Widget(title="Title")
    @NameColumn
    @NotNull
    private String productName;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Unit price")
    @Digits(integer=10, fraction=10)
    private BigDecimal unitPriceUntaxed = BigDecimal.ZERO;
    @Widget(title="Unit price")
    @Digits(integer=10, fraction=10)
    private BigDecimal unitPriceTaxed = BigDecimal.ZERO;
    @Widget(title="Company Unit price W.T.")
    @Digits(integer=10, fraction=10)
    private BigDecimal companyUnitPriceUntaxed = BigDecimal.ZERO;
    @Widget(title="Price used for WAP", readonly=true)
    @Digits(integer=10, fraction=10)
    @Column(nullable=true)
    private BigDecimal wapPrice;
    @Widget(title="Purchase price", help="Purchase price in company currency, used for declaration of exchange.")
    @Digits(integer=10, fraction=10)
    private BigDecimal companyPurchasePrice = BigDecimal.ZERO;
    @Widget(title="Product type", selection="product.product.type.select")
    private String productTypeSelect;
    @Widget(title="Seq.")
    private Integer sequence = 0;
    @Widget(title="Ref.")
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String name;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CustomsCodeNomenclature customsCodeNomenclature;
    private String customsCode;
    @Widget(title="Logistical form lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="stockMoveLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<LogisticalFormLine> logisticalFormLineList;
    @Widget(title="Type", selection="line.type.select")
    private Integer lineTypeSelect = 0;
    @Basic
    @Type(type="com.axelor.db.hibernate.type.ValueEnumType")
    private Regime regime;
    @Basic
    @Type(type="com.axelor.db.hibernate.type.ValueEnumType")
    private NatureOfTransaction natureOfTransaction;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Country countryOfOrigin;
    @Widget(title="Sales order line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrderLine saleOrderLine;
    @Widget(title="Purchase order line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PurchaseOrderLine purchaseOrderLine;
    @Widget(title="Allocated Qty")
    @Digits(integer=10, fraction=10)
    private BigDecimal reservedQty = BigDecimal.ZERO;
    @Widget(title="Requested reserved qty")
    @Digits(integer=10, fraction=10)
    private BigDecimal requestedReservedQty = BigDecimal.ZERO;
    @Widget(title="Invoiced Qty")
    @Digits(integer=10, fraction=10)
    private BigDecimal qtyInvoiced = BigDecimal.ZERO;
    @Widget(title="Quantity requested", readonly=true)
    private Boolean isQtyRequested = Boolean.FALSE;
    @Transient
    private Boolean isMergedStockMoveLine = Boolean.FALSE;
    @Widget(readonly=true)
    private LocalDateTime reservationDateTime;
    @Widget(title="Manufacturing order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ManufOrder consumedManufOrder;
    @Widget(title="Manufacturing order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ManufOrder producedManufOrder;
    @Widget(title="Operation order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private OperationOrder consumedOperationOrder;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public StockMoveLine() {
    }

    public StockMoveLine(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public StockMove getStockMove() {
        return this.stockMove;
    }

    public void setStockMove(StockMove stockMove) {
        this.stockMove = stockMove;
    }

    public StockMove getPlannedStockMove() {
        return this.plannedStockMove;
    }

    public void setPlannedStockMove(StockMove plannedStockMove) {
        this.plannedStockMove = plannedStockMove;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Boolean getFilterOnAvailableProducts() {
        return this.filterOnAvailableProducts == null ? Boolean.FALSE : this.filterOnAvailableProducts;
    }

    public void setFilterOnAvailableProducts(Boolean filterOnAvailableProducts) {
        this.filterOnAvailableProducts = filterOnAvailableProducts;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public BigDecimal getRealQty() {
        return this.realQty == null ? BigDecimal.ZERO : this.realQty;
    }

    public void setRealQty(BigDecimal realQty) {
        this.realQty = realQty;
    }

    public BigDecimal getOldQty() {
        return this.oldQty == null ? BigDecimal.ZERO : this.oldQty;
    }

    public void setOldQty(BigDecimal oldQty) {
        this.oldQty = oldQty;
    }

    public BigDecimal getAvailableQty() {
        return this.availableQty == null ? BigDecimal.ZERO : this.availableQty;
    }

    public void setAvailableQty(BigDecimal availableQty) {
        this.availableQty = availableQty;
    }

    public BigDecimal getAvailableQtyForProduct() {
        return this.availableQtyForProduct == null ? BigDecimal.ZERO : this.availableQtyForProduct;
    }

    public void setAvailableQtyForProduct(BigDecimal availableQtyForProduct) {
        this.availableQtyForProduct = availableQtyForProduct;
    }

    public String getAvailableStatus() {
        return this.availableStatus;
    }

    public void setAvailableStatus(String availableStatus) {
        this.availableStatus = availableStatus;
    }

    public Integer getAvailableStatusSelect() {
        return this.availableStatusSelect == null ? 0 : this.availableStatusSelect;
    }

    public void setAvailableStatusSelect(Integer availableStatusSelect) {
        this.availableStatusSelect = availableStatusSelect;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public BigDecimal getNetMass() {
        return this.netMass == null ? BigDecimal.ZERO : this.netMass;
    }

    public void setNetMass(BigDecimal netMass) {
        this.netMass = netMass;
    }

    public BigDecimal getTotalNetMass() {
        return this.totalNetMass == null ? BigDecimal.ZERO : this.totalNetMass;
    }

    public void setTotalNetMass(BigDecimal totalNetMass) {
        this.totalNetMass = totalNetMass;
    }

    public TrackingNumber getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(TrackingNumber trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public Integer getConformitySelect() {
        return this.conformitySelect == null ? 0 : this.conformitySelect;
    }

    public void setConformitySelect(Integer conformitySelect) {
        this.conformitySelect = conformitySelect;
    }

    public BigDecimal getShippedQty() {
        return this.shippedQty == null ? BigDecimal.ZERO : this.shippedQty;
    }

    public void setShippedQty(BigDecimal shippedQty) {
        this.shippedQty = shippedQty;
    }

    public LocalDate getShippedDate() {
        return this.shippedDate;
    }

    public void setShippedDate(LocalDate shippedDate) {
        this.shippedDate = shippedDate;
    }

    public Product getProductModel() {
        return this.productModel;
    }

    public void setProductModel(Product productModel) {
        this.productModel = productModel;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigDecimal getUnitPriceUntaxed() {
        return this.unitPriceUntaxed == null ? BigDecimal.ZERO : this.unitPriceUntaxed;
    }

    public void setUnitPriceUntaxed(BigDecimal unitPriceUntaxed) {
        this.unitPriceUntaxed = unitPriceUntaxed;
    }

    public BigDecimal getUnitPriceTaxed() {
        return this.unitPriceTaxed == null ? BigDecimal.ZERO : this.unitPriceTaxed;
    }

    public void setUnitPriceTaxed(BigDecimal unitPriceTaxed) {
        this.unitPriceTaxed = unitPriceTaxed;
    }

    public BigDecimal getCompanyUnitPriceUntaxed() {
        return this.companyUnitPriceUntaxed == null ? BigDecimal.ZERO : this.companyUnitPriceUntaxed;
    }

    public void setCompanyUnitPriceUntaxed(BigDecimal companyUnitPriceUntaxed) {
        this.companyUnitPriceUntaxed = companyUnitPriceUntaxed;
    }

    public BigDecimal getWapPrice() {
        return this.wapPrice;
    }

    public void setWapPrice(BigDecimal wapPrice) {
        this.wapPrice = wapPrice;
    }

    public BigDecimal getCompanyPurchasePrice() {
        return this.companyPurchasePrice == null ? BigDecimal.ZERO : this.companyPurchasePrice;
    }

    public void setCompanyPurchasePrice(BigDecimal companyPurchasePrice) {
        this.companyPurchasePrice = companyPurchasePrice;
    }

    public String getProductTypeSelect() {
        return this.productTypeSelect;
    }

    public void setProductTypeSelect(String productTypeSelect) {
        this.productTypeSelect = productTypeSelect;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        if (this.stockMove != null && this.stockMove.getStockMoveSeq() != null) {
            return this.stockMove.getStockMoveSeq() + "-" + Integer.toString(this.sequence);
        }
        return Integer.toString(this.sequence);
    }

    public void setName(String name) {
        this.name = name;
    }

    public CustomsCodeNomenclature getCustomsCodeNomenclature() {
        return this.customsCodeNomenclature;
    }

    public void setCustomsCodeNomenclature(CustomsCodeNomenclature customsCodeNomenclature) {
        this.customsCodeNomenclature = customsCodeNomenclature;
    }

    public String getCustomsCode() {
        return this.customsCode;
    }

    public void setCustomsCode(String customsCode) {
        this.customsCode = customsCode;
    }

    public List<LogisticalFormLine> getLogisticalFormLineList() {
        return this.logisticalFormLineList;
    }

    public void setLogisticalFormLineList(List<LogisticalFormLine> logisticalFormLineList) {
        this.logisticalFormLineList = logisticalFormLineList;
    }

    public void addLogisticalFormLineListItem(LogisticalFormLine item) {
        if (this.getLogisticalFormLineList() == null) {
            this.setLogisticalFormLineList(new ArrayList());
        }
        this.getLogisticalFormLineList().add(item);
        item.setStockMoveLine(this);
    }

    public void removeLogisticalFormLineListItem(LogisticalFormLine item) {
        if (this.getLogisticalFormLineList() == null) {
            return;
        }
        this.getLogisticalFormLineList().remove(item);
    }

    public void clearLogisticalFormLineList() {
        if (this.getLogisticalFormLineList() != null) {
            this.getLogisticalFormLineList().clear();
        }
    }

    public Integer getLineTypeSelect() {
        return this.lineTypeSelect == null ? 0 : this.lineTypeSelect;
    }

    public void setLineTypeSelect(Integer lineTypeSelect) {
        this.lineTypeSelect = lineTypeSelect;
    }

    public Regime getRegime() {
        return this.regime;
    }

    public void setRegime(Regime regime) {
        this.regime = regime;
    }

    public NatureOfTransaction getNatureOfTransaction() {
        return this.natureOfTransaction;
    }

    public void setNatureOfTransaction(NatureOfTransaction natureOfTransaction) {
        this.natureOfTransaction = natureOfTransaction;
    }

    public Country getCountryOfOrigin() {
        return this.countryOfOrigin;
    }

    public void setCountryOfOrigin(Country countryOfOrigin) {
        this.countryOfOrigin = countryOfOrigin;
    }

    public SaleOrderLine getSaleOrderLine() {
        return this.saleOrderLine;
    }

    public void setSaleOrderLine(SaleOrderLine saleOrderLine) {
        this.saleOrderLine = saleOrderLine;
    }

    public PurchaseOrderLine getPurchaseOrderLine() {
        return this.purchaseOrderLine;
    }

    public void setPurchaseOrderLine(PurchaseOrderLine purchaseOrderLine) {
        this.purchaseOrderLine = purchaseOrderLine;
    }

    public BigDecimal getReservedQty() {
        return this.reservedQty == null ? BigDecimal.ZERO : this.reservedQty;
    }

    public void setReservedQty(BigDecimal reservedQty) {
        this.reservedQty = reservedQty;
    }

    public BigDecimal getRequestedReservedQty() {
        return this.requestedReservedQty == null ? BigDecimal.ZERO : this.requestedReservedQty;
    }

    public void setRequestedReservedQty(BigDecimal requestedReservedQty) {
        this.requestedReservedQty = requestedReservedQty;
    }

    public BigDecimal getQtyInvoiced() {
        return this.qtyInvoiced == null ? BigDecimal.ZERO : this.qtyInvoiced;
    }

    public void setQtyInvoiced(BigDecimal qtyInvoiced) {
        this.qtyInvoiced = qtyInvoiced;
    }

    public Boolean getIsQtyRequested() {
        return this.isQtyRequested == null ? Boolean.FALSE : this.isQtyRequested;
    }

    public void setIsQtyRequested(Boolean isQtyRequested) {
        this.isQtyRequested = isQtyRequested;
    }

    public Boolean getIsMergedStockMoveLine() {
        return this.isMergedStockMoveLine == null ? Boolean.FALSE : this.isMergedStockMoveLine;
    }

    public void setIsMergedStockMoveLine(Boolean isMergedStockMoveLine) {
        this.isMergedStockMoveLine = isMergedStockMoveLine;
    }

    public LocalDateTime getReservationDateTime() {
        return this.reservationDateTime;
    }

    public void setReservationDateTime(LocalDateTime reservationDateTime) {
        this.reservationDateTime = reservationDateTime;
    }

    public ManufOrder getConsumedManufOrder() {
        return this.consumedManufOrder;
    }

    public void setConsumedManufOrder(ManufOrder consumedManufOrder) {
        this.consumedManufOrder = consumedManufOrder;
    }

    public ManufOrder getProducedManufOrder() {
        return this.producedManufOrder;
    }

    public void setProducedManufOrder(ManufOrder producedManufOrder) {
        this.producedManufOrder = producedManufOrder;
    }

    public OperationOrder getConsumedOperationOrder() {
        return this.consumedOperationOrder;
    }

    public void setConsumedOperationOrder(OperationOrder consumedOperationOrder) {
        this.consumedOperationOrder = consumedOperationOrder;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StockMoveLine)) {
            return false;
        }
        StockMoveLine other = (StockMoveLine)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("filterOnAvailableProducts", (Object)this.getFilterOnAvailableProducts()).add("qty", (Object)this.getQty()).add("realQty", (Object)this.getRealQty()).add("oldQty", (Object)this.getOldQty()).add("availableQty", (Object)this.getAvailableQty()).add("availableQtyForProduct", (Object)this.getAvailableQtyForProduct()).add("availableStatus", (Object)this.getAvailableStatus()).add("availableStatusSelect", (Object)this.getAvailableStatusSelect()).add("netMass", (Object)this.getNetMass()).add("totalNetMass", (Object)this.getTotalNetMass()).add("conformitySelect", (Object)this.getConformitySelect()).omitNullValues().toString();
    }
}

