/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db.repo;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Country;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.db.JpaRepository;
import com.axelor.db.Query;
import java.time.LocalDate;

public class StockMoveLineRepository
extends JpaRepository<StockMoveLine> {
    public static final int CONFORMITY_NONE = 1;
    public static final int CONFORMITY_COMPLIANT = 2;
    public static final int CONFORMITY_NON_COMPLIANT = 3;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_TITLE = 1;
    public static final int STATUS_AVAILABLE = 1;
    public static final int STATUS_AVAILABLE_FOR_PRODUCT = 2;
    public static final int STATUS_MISSING = 3;

    public StockMoveLineRepository() {
        super(StockMoveLine.class);
    }

    public StockMoveLine findByName(String name) {
        return (StockMoveLine)Query.of(StockMoveLine.class).filter("self.name = :name").bind("name", (Object)name).fetchOne();
    }

    public Query<StockMoveLine> findAllBySaleOrder(SaleOrder saleOrder) {
        return Query.of(StockMoveLine.class).filter("self.stockMove.originTypeSelect LIKE 'com.axelor.apps.sale.db.SaleOrder' AND self.stockMove.originId = :saleOrder.id").bind("saleOrder", (Object)saleOrder);
    }

    public Query<StockMoveLine> findAllBySaleOrderAndStatusSelect(SaleOrder saleOrder, Integer statusSelect) {
        return Query.of(StockMoveLine.class).filter("self.stockMove.originTypeSelect LIKE 'com.axelor.apps.sale.db.SaleOrder' AND self.stockMove.originId = :saleOrder.id AND self.stockMove.statusSelect = :statusSelect").bind("saleOrder", (Object)saleOrder).bind("statusSelect", (Object)statusSelect);
    }

    public Query<StockMoveLine> findForDeclarationOfExchanges(LocalDate fromDate, LocalDate toDate, String productTypeSelect, int stockMoveTypeSelect, Country country, Company company) {
        return Query.of(StockMoveLine.class).filter("self.stockMove.realDate BETWEEN :fromDate AND :toDate\t\t  AND self.product.usedInDEB is true\t\t   AND self.product.productTypeSelect = :productTypeSelect\t\t  AND self.stockMove.typeSelect = :stockMoveTypeSelect\t\t  AND self.stockMove.statusSelect = 3\t\t   AND self.stockMove.company = :company\t\t   AND (COALESCE(self.stockMove.fromAddress.addressL7Country, self.stockMove.fromStockLocation.address.addressL7Country) = :country\t\t  OR COALESCE(self.stockMove.toAddress.addressL7Country, self.stockMove.toStockLocation.address.addressL7Country) = :country)\t\t  AND COALESCE(self.stockMove.fromAddress.addressL7Country, self.stockMove.fromStockLocation.address.addressL7Country)\t\t  != COALESCE(self.stockMove.toAddress.addressL7Country, self.stockMove.toStockLocation.address.addressL7Country)\t\t  AND COALESCE(self.stockMove.fromAddress.addressL7Country.economicArea, self.stockMove.fromStockLocation.address.addressL7Country.economicArea)\t\t  = COALESCE(self.stockMove.toAddress.addressL7Country.economicArea, self.stockMove.toStockLocation.address.addressL7Country.economicArea)").bind("fromDate", (Object)fromDate).bind("toDate", (Object)toDate).bind("productTypeSelect", (Object)productTypeSelect).bind("stockMoveTypeSelect", (Object)stockMoveTypeSelect).bind("country", (Object)country).bind("company", (Object)company).order("stockMove.realDate").order("id");
    }
}

