/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Role;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaMenu;
import com.axelor.meta.db.MetaView;
import com.axelor.studio.db.AppBuilder;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="META_JSON_MODEL", indexes={@Index(columnList="title"), @Index(columnList="menu"), @Index(columnList="menu_parent"), @Index(columnList="action"), @Index(columnList="grid_view"), @Index(columnList="form_view"), @Index(columnList="app_builder")})
public class MetaJsonModel
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_JSON_MODEL_SEQ")
    @SequenceGenerator(name="META_JSON_MODEL_SEQ", sequenceName="META_JSON_MODEL_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @NotNull
    @Column(unique=true)
    private String name;
    @NameColumn
    @NotNull
    private String title;
    private String onNew;
    private String onSave;
    private String nameField;
    private String formWidth;
    private String orderBy;
    @Widget(copyable=false)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaMenu menu;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaMenu menuParent;
    private String menuIcon;
    private String menuBackground;
    private Integer menuOrder = 0;
    private String menuTitle;
    private Boolean menuTop = Boolean.FALSE;
    @Widget(copyable=false)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaAction action;
    @Widget(copyable=false)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaView gridView;
    @Widget(copyable=false)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaView formView;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="jsonModel", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="sequence, id")
    private List<MetaJsonField> fields;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roles;
    @Widget(title="App builder")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBuilder appBuilder;
    @Widget(title="Show process tracking")
    private Boolean showProcessTracking = Boolean.FALSE;

    public MetaJsonModel() {
    }

    public MetaJsonModel(String name, String nameField) {
        this.name = name;
        this.nameField = nameField;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOnNew() {
        return this.onNew;
    }

    public void setOnNew(String onNew) {
        this.onNew = onNew;
    }

    public String getOnSave() {
        return this.onSave;
    }

    public void setOnSave(String onSave) {
        this.onSave = onSave;
    }

    public String getNameField() {
        return this.nameField;
    }

    public void setNameField(String nameField) {
        this.nameField = nameField;
    }

    public String getFormWidth() {
        return this.formWidth;
    }

    public void setFormWidth(String formWidth) {
        this.formWidth = formWidth;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public MetaMenu getMenu() {
        return this.menu;
    }

    public void setMenu(MetaMenu menu) {
        this.menu = menu;
    }

    public MetaMenu getMenuParent() {
        return this.menuParent;
    }

    public void setMenuParent(MetaMenu menuParent) {
        this.menuParent = menuParent;
    }

    public String getMenuIcon() {
        return this.menuIcon;
    }

    public void setMenuIcon(String menuIcon) {
        this.menuIcon = menuIcon;
    }

    public String getMenuBackground() {
        return this.menuBackground;
    }

    public void setMenuBackground(String menuBackground) {
        this.menuBackground = menuBackground;
    }

    public Integer getMenuOrder() {
        return this.menuOrder == null ? 0 : this.menuOrder;
    }

    public void setMenuOrder(Integer menuOrder) {
        this.menuOrder = menuOrder;
    }

    public String getMenuTitle() {
        return this.menuTitle;
    }

    public void setMenuTitle(String menuTitle) {
        this.menuTitle = menuTitle;
    }

    public Boolean getMenuTop() {
        return this.menuTop == null ? Boolean.FALSE : this.menuTop;
    }

    public void setMenuTop(Boolean menuTop) {
        this.menuTop = menuTop;
    }

    public MetaAction getAction() {
        return this.action;
    }

    public void setAction(MetaAction action) {
        this.action = action;
    }

    public MetaView getGridView() {
        return this.gridView;
    }

    public void setGridView(MetaView gridView) {
        this.gridView = gridView;
    }

    public MetaView getFormView() {
        return this.formView;
    }

    public void setFormView(MetaView formView) {
        this.formView = formView;
    }

    public List<MetaJsonField> getFields() {
        return this.fields;
    }

    public void setFields(List<MetaJsonField> fields) {
        this.fields = fields;
    }

    public void addField(MetaJsonField item) {
        if (this.getFields() == null) {
            this.setFields(new ArrayList());
        }
        this.getFields().add(item);
        item.setJsonModel(this);
    }

    public void removeField(MetaJsonField item) {
        if (this.getFields() == null) {
            return;
        }
        this.getFields().remove(item);
    }

    public void clearFields() {
        if (this.getFields() != null) {
            this.getFields().clear();
        }
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void addRole(Role item) {
        if (this.getRoles() == null) {
            this.setRoles(new HashSet());
        }
        this.getRoles().add(item);
    }

    public void removeRole(Role item) {
        if (this.getRoles() == null) {
            return;
        }
        this.getRoles().remove(item);
    }

    public void clearRoles() {
        if (this.getRoles() != null) {
            this.getRoles().clear();
        }
    }

    public AppBuilder getAppBuilder() {
        return this.appBuilder;
    }

    public void setAppBuilder(AppBuilder appBuilder) {
        this.appBuilder = appBuilder;
    }

    public Boolean getShowProcessTracking() {
        return this.showProcessTracking == null ? Boolean.FALSE : this.showProcessTracking;
    }

    public void setShowProcessTracking(Boolean showProcessTracking) {
        this.showProcessTracking = showProcessTracking;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaJsonModel)) {
            return false;
        }
        MetaJsonModel other = (MetaJsonModel)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(64822908, this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("title", (Object)this.getTitle()).add("onNew", (Object)this.getOnNew()).add("onSave", (Object)this.getOnSave()).add("nameField", (Object)this.getNameField()).add("formWidth", (Object)this.getFormWidth()).add("orderBy", (Object)this.getOrderBy()).add("menuIcon", (Object)this.getMenuIcon()).add("menuBackground", (Object)this.getMenuBackground()).add("menuOrder", (Object)this.getMenuOrder()).add("menuTitle", (Object)this.getMenuTitle()).omitNullValues().toString();
    }
}

