/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Budget;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_BUDGET_LINE", indexes={@Index(columnList="budget")})
public class BudgetLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_BUDGET_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_BUDGET_LINE_SEQ", sequenceName="ACCOUNT_BUDGET_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="From")
    private LocalDate fromDate;
    @Widget(title="To")
    private LocalDate toDate;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Budget budget;
    @Widget(title="Expected amount")
    @Digits(integer=18, fraction=2)
    private BigDecimal amountExpected = BigDecimal.ZERO;
    @Widget(title="Realized amount")
    @Digits(integer=18, fraction=2)
    private BigDecimal amountRealized = BigDecimal.ZERO;
    @Widget(title="Committed amount")
    @Digits(integer=18, fraction=2)
    private BigDecimal amountCommitted = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    public BigDecimal getAmountExpected() {
        return this.amountExpected == null ? BigDecimal.ZERO : this.amountExpected;
    }

    public void setAmountExpected(BigDecimal amountExpected) {
        this.amountExpected = amountExpected;
    }

    public BigDecimal getAmountRealized() {
        return this.amountRealized == null ? BigDecimal.ZERO : this.amountRealized;
    }

    public void setAmountRealized(BigDecimal amountRealized) {
        this.amountRealized = amountRealized;
    }

    public BigDecimal getAmountCommitted() {
        return this.amountCommitted == null ? BigDecimal.ZERO : this.amountCommitted;
    }

    public void setAmountCommitted(BigDecimal amountCommitted) {
        this.amountCommitted = amountCommitted;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BudgetLine)) {
            return false;
        }
        BudgetLine other = (BudgetLine)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("amountExpected", (Object)this.getAmountExpected()).add("amountRealized", (Object)this.getAmountRealized()).add("amountCommitted", (Object)this.getAmountCommitted()).omitNullValues().toString();
    }
}

