/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AccountManagement;
import com.axelor.apps.bankpayment.db.BankOrderFileFormat;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_PAYMENT_MODE", indexes={@Index(columnList="code"), @Index(columnList="bank_order_file_format")})
public class PaymentMode
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_PAYMENT_MODE_SEQ")
    @SequenceGenerator(name="ACCOUNT_PAYMENT_MODE_SEQ", sequenceName="ACCOUNT_PAYMENT_MODE_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Label", translatable=true)
    @NotNull
    @Column(unique=true)
    private String name;
    @Widget(title="Code")
    @NotNull
    private String code;
    @Widget(title="Type", selection="iaccount.payment.mode.type.select")
    private Integer typeSelect = 0;
    @Widget(title="In / Out", selection="iaccount.payment.mode.in.out.select")
    private Integer inOutSelect = 0;
    @Widget(title="Accounting settings")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="paymentMode", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AccountManagement> accountManagementList;
    private Boolean validatePaymentByDepositSlipPublication = Boolean.FALSE;
    @Widget(title="Generate Bank order")
    private Boolean generateBankOrder = Boolean.FALSE;
    @Widget(title="Confirm auto. the bank orders")
    private Boolean autoConfirmBankOrder = Boolean.FALSE;
    @Widget(title="Transmit automatically to Bank")
    private Boolean automaticTransmission = Boolean.FALSE;
    @Widget(title="Order Type", selection="bankpayment.bank.order.type.select")
    private Integer orderTypeSelect = 0;
    private String bankOrderExportFolderPath;
    @Widget(title="File format")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankOrderFileFormat bankOrderFileFormat;
    @Widget(title="Generate account move from the bank order")
    private Boolean generateMoveAutoFromBankOrder = Boolean.FALSE;
    @Widget(title="Consolidate bank order lines per partner")
    private Boolean consoBankOrderLinePerPartner = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public PaymentMode() {
    }

    public PaymentMode(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Integer getInOutSelect() {
        return this.inOutSelect == null ? 0 : this.inOutSelect;
    }

    public void setInOutSelect(Integer inOutSelect) {
        this.inOutSelect = inOutSelect;
    }

    public List<AccountManagement> getAccountManagementList() {
        return this.accountManagementList;
    }

    public void setAccountManagementList(List<AccountManagement> accountManagementList) {
        this.accountManagementList = accountManagementList;
    }

    public void addAccountManagementListItem(AccountManagement item) {
        if (this.getAccountManagementList() == null) {
            this.setAccountManagementList(new ArrayList());
        }
        this.getAccountManagementList().add(item);
        item.setPaymentMode(this);
    }

    public void removeAccountManagementListItem(AccountManagement item) {
        if (this.getAccountManagementList() == null) {
            return;
        }
        this.getAccountManagementList().remove(item);
    }

    public void clearAccountManagementList() {
        if (this.getAccountManagementList() != null) {
            this.getAccountManagementList().clear();
        }
    }

    public Boolean getValidatePaymentByDepositSlipPublication() {
        return this.validatePaymentByDepositSlipPublication == null ? Boolean.FALSE : this.validatePaymentByDepositSlipPublication;
    }

    public void setValidatePaymentByDepositSlipPublication(Boolean validatePaymentByDepositSlipPublication) {
        this.validatePaymentByDepositSlipPublication = validatePaymentByDepositSlipPublication;
    }

    public Boolean getGenerateBankOrder() {
        return this.generateBankOrder == null ? Boolean.FALSE : this.generateBankOrder;
    }

    public void setGenerateBankOrder(Boolean generateBankOrder) {
        this.generateBankOrder = generateBankOrder;
    }

    public Boolean getAutoConfirmBankOrder() {
        return this.autoConfirmBankOrder == null ? Boolean.FALSE : this.autoConfirmBankOrder;
    }

    public void setAutoConfirmBankOrder(Boolean autoConfirmBankOrder) {
        this.autoConfirmBankOrder = autoConfirmBankOrder;
    }

    public Boolean getAutomaticTransmission() {
        return this.automaticTransmission == null ? Boolean.FALSE : this.automaticTransmission;
    }

    public void setAutomaticTransmission(Boolean automaticTransmission) {
        this.automaticTransmission = automaticTransmission;
    }

    public Integer getOrderTypeSelect() {
        return this.orderTypeSelect == null ? 0 : this.orderTypeSelect;
    }

    public void setOrderTypeSelect(Integer orderTypeSelect) {
        this.orderTypeSelect = orderTypeSelect;
    }

    public String getBankOrderExportFolderPath() {
        return this.bankOrderExportFolderPath;
    }

    public void setBankOrderExportFolderPath(String bankOrderExportFolderPath) {
        this.bankOrderExportFolderPath = bankOrderExportFolderPath;
    }

    public BankOrderFileFormat getBankOrderFileFormat() {
        return this.bankOrderFileFormat;
    }

    public void setBankOrderFileFormat(BankOrderFileFormat bankOrderFileFormat) {
        this.bankOrderFileFormat = bankOrderFileFormat;
    }

    public Boolean getGenerateMoveAutoFromBankOrder() {
        return this.generateMoveAutoFromBankOrder == null ? Boolean.FALSE : this.generateMoveAutoFromBankOrder;
    }

    public void setGenerateMoveAutoFromBankOrder(Boolean generateMoveAutoFromBankOrder) {
        this.generateMoveAutoFromBankOrder = generateMoveAutoFromBankOrder;
    }

    public Boolean getConsoBankOrderLinePerPartner() {
        return this.consoBankOrderLinePerPartner == null ? Boolean.FALSE : this.consoBankOrderLinePerPartner;
    }

    public void setConsoBankOrderLinePerPartner(Boolean consoBankOrderLinePerPartner) {
        this.consoBankOrderLinePerPartner = consoBankOrderLinePerPartner;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PaymentMode)) {
            return false;
        }
        PaymentMode other = (PaymentMode)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(127276201, this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("typeSelect", (Object)this.getTypeSelect()).add("inOutSelect", (Object)this.getInOutSelect()).add("validatePaymentByDepositSlipPublication", (Object)this.getValidatePaymentByDepositSlipPublication()).add("generateBankOrder", (Object)this.getGenerateBankOrder()).add("autoConfirmBankOrder", (Object)this.getAutoConfirmBankOrder()).add("automaticTransmission", (Object)this.getAutomaticTransmission()).add("orderTypeSelect", (Object)this.getOrderTypeSelect()).add("bankOrderExportFolderPath", (Object)this.getBankOrderExportFolderPath()).add("generateMoveAutoFromBankOrder", (Object)this.getGenerateMoveAutoFromBankOrder()).omitNullValues().toString();
    }
}

