/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.StopReason;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="BASE_BLOCKING", indexes={@Index(columnList="partner"), @Index(columnList="blocking_reason"), @Index(columnList="blocking_by_user"), @Index(columnList="name")})
public class Blocking
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_BLOCKING_SEQ")
    @SequenceGenerator(name="BASE_BLOCKING_SEQ", sequenceName="BASE_BLOCKING_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Companies")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Company> companySet;
    @Widget(title="Partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Blocking Type", selection="base.blocking.select")
    private Integer blockingSelect = 1;
    @Widget(title="Block until")
    private LocalDate blockingToDate;
    @Widget(title="Blocking reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StopReason blockingReason;
    @Widget(title="Blocking done by")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User blockingByUser;
    @Widget(title="Reference", search={"partner"})
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String name;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Blocking() {
    }

    public Blocking(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Set<Company> getCompanySet() {
        return this.companySet;
    }

    public void setCompanySet(Set<Company> companySet) {
        this.companySet = companySet;
    }

    public void addCompanySetItem(Company item) {
        if (this.getCompanySet() == null) {
            this.setCompanySet(new HashSet());
        }
        this.getCompanySet().add(item);
    }

    public void removeCompanySetItem(Company item) {
        if (this.getCompanySet() == null) {
            return;
        }
        this.getCompanySet().remove(item);
    }

    public void clearCompanySet() {
        if (this.getCompanySet() != null) {
            this.getCompanySet().clear();
        }
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Integer getBlockingSelect() {
        return this.blockingSelect == null ? 0 : this.blockingSelect;
    }

    public void setBlockingSelect(Integer blockingSelect) {
        this.blockingSelect = blockingSelect;
    }

    public LocalDate getBlockingToDate() {
        return this.blockingToDate;
    }

    public void setBlockingToDate(LocalDate blockingToDate) {
        this.blockingToDate = blockingToDate;
    }

    public StopReason getBlockingReason() {
        return this.blockingReason;
    }

    public void setBlockingReason(StopReason blockingReason) {
        this.blockingReason = blockingReason;
    }

    public User getBlockingByUser() {
        return this.blockingByUser;
    }

    public void setBlockingByUser(User blockingByUser) {
        this.blockingByUser = blockingByUser;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        return this.partner != null ? this.partner.getName() : "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Blocking)) {
            return false;
        }
        Blocking other = (Blocking)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("blockingSelect", (Object)this.getBlockingSelect()).add("blockingToDate", (Object)this.getBlockingToDate()).omitNullValues().toString();
    }
}

