/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="STOCK_STOCK_LOCATION", indexes={@Index(columnList="name"), @Index(columnList="parent_stock_location"), @Index(columnList="company"), @Index(columnList="partner"), @Index(columnList="address")})
public class StockLocation
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_STOCK_LOCATION_SEQ")
    @SequenceGenerator(name="STOCK_STOCK_LOCATION_SEQ", sequenceName="STOCK_STOCK_LOCATION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Parent stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation parentStockLocation;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Deported stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Type", selection="stock.stock.location.type.select")
    @NotNull
    private Integer typeSelect = 0;
    @Widget(title="Stock location lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="stockLocation", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<StockLocationLine> stockLocationLineList;
    @Widget(title="Details stock location lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="detailsStockLocation", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<StockLocationLine> detailsStockLocationLineList;
    @Widget(title="Address")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address address;
    @Widget(title="Include out of stocks products")
    private Boolean includeOutOfStock = Boolean.FALSE;
    @Widget(title="Stock location value")
    @Transient
    private BigDecimal stockLocationValue = BigDecimal.ZERO;
    @Widget(title="Direct order stock location")
    private Boolean directOrderLocation = Boolean.FALSE;
    @Widget(title="Usable on purchase order")
    private Boolean usableOnPurchaseOrder = Boolean.FALSE;
    @Widget(title="Usable on sale order")
    private Boolean usableOnSaleOrder = Boolean.FALSE;
    @Widget(title="Don't take in consideration for the stock computation")
    private Boolean isNotInCalculStock = Boolean.FALSE;
    @Widget(title="Don't take in consideration on MRP")
    private Boolean isNotInMrp = Boolean.FALSE;
    @Widget(title="Usable on production")
    private Boolean usableOnProduction = Boolean.FALSE;
    private Boolean isWorkshop = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public StockLocation() {
    }

    public StockLocation(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StockLocation getParentStockLocation() {
        return this.parentStockLocation;
    }

    public void setParentStockLocation(StockLocation parentStockLocation) {
        this.parentStockLocation = parentStockLocation;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public List<StockLocationLine> getStockLocationLineList() {
        return this.stockLocationLineList;
    }

    public void setStockLocationLineList(List<StockLocationLine> stockLocationLineList) {
        this.stockLocationLineList = stockLocationLineList;
    }

    public void addStockLocationLineListItem(StockLocationLine item) {
        if (this.getStockLocationLineList() == null) {
            this.setStockLocationLineList(new ArrayList());
        }
        this.getStockLocationLineList().add(item);
        item.setStockLocation(this);
    }

    public void removeStockLocationLineListItem(StockLocationLine item) {
        if (this.getStockLocationLineList() == null) {
            return;
        }
        this.getStockLocationLineList().remove(item);
    }

    public void clearStockLocationLineList() {
        if (this.getStockLocationLineList() != null) {
            this.getStockLocationLineList().clear();
        }
    }

    public List<StockLocationLine> getDetailsStockLocationLineList() {
        return this.detailsStockLocationLineList;
    }

    public void setDetailsStockLocationLineList(List<StockLocationLine> detailsStockLocationLineList) {
        this.detailsStockLocationLineList = detailsStockLocationLineList;
    }

    public void addDetailsStockLocationLineListItem(StockLocationLine item) {
        if (this.getDetailsStockLocationLineList() == null) {
            this.setDetailsStockLocationLineList(new ArrayList());
        }
        this.getDetailsStockLocationLineList().add(item);
        item.setDetailsStockLocation(this);
    }

    public void removeDetailsStockLocationLineListItem(StockLocationLine item) {
        if (this.getDetailsStockLocationLineList() == null) {
            return;
        }
        this.getDetailsStockLocationLineList().remove(item);
    }

    public void clearDetailsStockLocationLineList() {
        if (this.getDetailsStockLocationLineList() != null) {
            this.getDetailsStockLocationLineList().clear();
        }
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Boolean getIncludeOutOfStock() {
        return this.includeOutOfStock == null ? Boolean.FALSE : this.includeOutOfStock;
    }

    public void setIncludeOutOfStock(Boolean includeOutOfStock) {
        this.includeOutOfStock = includeOutOfStock;
    }

    public BigDecimal getStockLocationValue() {
        return this.stockLocationValue == null ? BigDecimal.ZERO : this.stockLocationValue;
    }

    public void setStockLocationValue(BigDecimal stockLocationValue) {
        this.stockLocationValue = stockLocationValue;
    }

    public Boolean getDirectOrderLocation() {
        return this.directOrderLocation == null ? Boolean.FALSE : this.directOrderLocation;
    }

    public void setDirectOrderLocation(Boolean directOrderLocation) {
        this.directOrderLocation = directOrderLocation;
    }

    public Boolean getUsableOnPurchaseOrder() {
        return this.usableOnPurchaseOrder == null ? Boolean.FALSE : this.usableOnPurchaseOrder;
    }

    public void setUsableOnPurchaseOrder(Boolean usableOnPurchaseOrder) {
        this.usableOnPurchaseOrder = usableOnPurchaseOrder;
    }

    public Boolean getUsableOnSaleOrder() {
        return this.usableOnSaleOrder == null ? Boolean.FALSE : this.usableOnSaleOrder;
    }

    public void setUsableOnSaleOrder(Boolean usableOnSaleOrder) {
        this.usableOnSaleOrder = usableOnSaleOrder;
    }

    public Boolean getIsNotInCalculStock() {
        return this.isNotInCalculStock == null ? Boolean.FALSE : this.isNotInCalculStock;
    }

    public void setIsNotInCalculStock(Boolean isNotInCalculStock) {
        this.isNotInCalculStock = isNotInCalculStock;
    }

    public Boolean getIsNotInMrp() {
        return this.isNotInMrp == null ? Boolean.FALSE : this.isNotInMrp;
    }

    public void setIsNotInMrp(Boolean isNotInMrp) {
        this.isNotInMrp = isNotInMrp;
    }

    public Boolean getUsableOnProduction() {
        return this.usableOnProduction == null ? Boolean.FALSE : this.usableOnProduction;
    }

    public void setUsableOnProduction(Boolean usableOnProduction) {
        this.usableOnProduction = usableOnProduction;
    }

    public Boolean getIsWorkshop() {
        return this.isWorkshop == null ? Boolean.FALSE : this.isWorkshop;
    }

    public void setIsWorkshop(Boolean isWorkshop) {
        this.isWorkshop = isWorkshop;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StockLocation)) {
            return false;
        }
        StockLocation other = (StockLocation)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("typeSelect", (Object)this.getTypeSelect()).add("includeOutOfStock", (Object)this.getIncludeOutOfStock()).add("stockLocationValue", (Object)this.getStockLocationValue()).add("directOrderLocation", (Object)this.getDirectOrderLocation()).add("usableOnPurchaseOrder", (Object)this.getUsableOnPurchaseOrder()).add("usableOnSaleOrder", (Object)this.getUsableOnSaleOrder()).add("isNotInCalculStock", (Object)this.getIsNotInCalculStock()).add("isNotInMrp", (Object)this.getIsNotInMrp()).add("usableOnProduction", (Object)this.getUsableOnProduction()).add("isWorkshop", (Object)this.getIsWorkshop()).omitNullValues().toString();
    }
}

