/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Permission;
import com.axelor.auth.db.Role;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaMenu;
import com.axelor.meta.db.MetaPermission;
import com.axelor.meta.db.MetaView;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Cacheable
@Table(name="AUTH_GROUP")
@Track(fields={@TrackField(name="code"), @TrackField(name="name"), @TrackField(name="navigation"), @TrackField(name="homeAction"), @TrackField(name="technicalStaff"), @TrackField(name="isClient"), @TrackField(name="isSupplier")})
public class Group
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="AUTH_GROUP_SEQ")
    @SequenceGenerator(name="AUTH_GROUP_SEQ", sequenceName="AUTH_GROUP_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @NotNull
    @Size(min=2)
    @Column(unique=true)
    private String code;
    @HashKey
    @NotNull
    @Size(min=2)
    @Column(unique=true)
    private String name;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roles;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Permission> permissions;
    @Widget(title="Permissions (fields)")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MetaPermission> metaPermissions;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="groups", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MetaMenu> menus;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="groups", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MetaView> views;
    @Widget(help="Specify whether the members of this group are technical staff.", massUpdate=true)
    private Boolean technicalStaff = Boolean.FALSE;
    @Widget(selection="select.user.navigation", massUpdate=true)
    private String navigation;
    @Widget(help="Default home action.", massUpdate=true)
    private String homeAction;
    @Widget(title="Client", massUpdate=true)
    private Boolean isClient = Boolean.FALSE;
    @Widget(title="Supplier", massUpdate=true)
    private Boolean isSupplier = Boolean.FALSE;

    public Group() {
    }

    public Group(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void addRole(Role item) {
        if (this.getRoles() == null) {
            this.setRoles(new HashSet());
        }
        this.getRoles().add(item);
    }

    public void removeRole(Role item) {
        if (this.getRoles() == null) {
            return;
        }
        this.getRoles().remove(item);
    }

    public void clearRoles() {
        if (this.getRoles() != null) {
            this.getRoles().clear();
        }
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Permission> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(Permission item) {
        if (this.getPermissions() == null) {
            this.setPermissions(new HashSet());
        }
        this.getPermissions().add(item);
    }

    public void removePermission(Permission item) {
        if (this.getPermissions() == null) {
            return;
        }
        this.getPermissions().remove(item);
    }

    public void clearPermissions() {
        if (this.getPermissions() != null) {
            this.getPermissions().clear();
        }
    }

    public Set<MetaPermission> getMetaPermissions() {
        return this.metaPermissions;
    }

    public void setMetaPermissions(Set<MetaPermission> metaPermissions) {
        this.metaPermissions = metaPermissions;
    }

    public void addMetaPermission(MetaPermission item) {
        if (this.getMetaPermissions() == null) {
            this.setMetaPermissions(new HashSet());
        }
        this.getMetaPermissions().add(item);
    }

    public void removeMetaPermission(MetaPermission item) {
        if (this.getMetaPermissions() == null) {
            return;
        }
        this.getMetaPermissions().remove(item);
    }

    public void clearMetaPermissions() {
        if (this.getMetaPermissions() != null) {
            this.getMetaPermissions().clear();
        }
    }

    public Set<MetaMenu> getMenus() {
        return this.menus;
    }

    public void setMenus(Set<MetaMenu> menus) {
        this.menus = menus;
    }

    public void addMenu(MetaMenu item) {
        if (this.getMenus() == null) {
            this.setMenus(new HashSet());
        }
        this.getMenus().add(item);
    }

    public void removeMenu(MetaMenu item) {
        if (this.getMenus() == null) {
            return;
        }
        this.getMenus().remove(item);
    }

    public void clearMenus() {
        if (this.getMenus() != null) {
            this.getMenus().clear();
        }
    }

    public Set<MetaView> getViews() {
        return this.views;
    }

    public void setViews(Set<MetaView> views) {
        this.views = views;
    }

    public void addView(MetaView item) {
        if (this.getViews() == null) {
            this.setViews(new HashSet());
        }
        this.getViews().add(item);
    }

    public void removeView(MetaView item) {
        if (this.getViews() == null) {
            return;
        }
        this.getViews().remove(item);
    }

    public void clearViews() {
        if (this.getViews() != null) {
            this.getViews().clear();
        }
    }

    public Boolean getTechnicalStaff() {
        return this.technicalStaff == null ? Boolean.FALSE : this.technicalStaff;
    }

    public void setTechnicalStaff(Boolean technicalStaff) {
        this.technicalStaff = technicalStaff;
    }

    public String getNavigation() {
        return this.navigation;
    }

    public void setNavigation(String navigation) {
        this.navigation = navigation;
    }

    public String getHomeAction() {
        return this.homeAction;
    }

    public void setHomeAction(String homeAction) {
        this.homeAction = homeAction;
    }

    public Boolean getIsClient() {
        return this.isClient == null ? Boolean.FALSE : this.isClient;
    }

    public void setIsClient(Boolean isClient) {
        this.isClient = isClient;
    }

    public Boolean getIsSupplier() {
        return this.isSupplier == null ? Boolean.FALSE : this.isSupplier;
    }

    public void setIsSupplier(Boolean isSupplier) {
        this.isSupplier = isSupplier;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        if (!Objects.equals(this.getCode(), other.getCode())) {
            return false;
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(69076575, this.getCode(), this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).add("technicalStaff", (Object)this.getTechnicalStaff()).add("navigation", (Object)this.getNavigation()).add("homeAction", (Object)this.getHomeAction()).add("isClient", (Object)this.getIsClient()).add("isSupplier", (Object)this.getIsSupplier()).omitNullValues().toString();
    }
}

