/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Cacheable
@Table(name="AUTH_PERMISSION")
@Track(fields={@TrackField(name="name"), @TrackField(name="object"), @TrackField(name="canRead"), @TrackField(name="canWrite"), @TrackField(name="canCreate"), @TrackField(name="canRemove"), @TrackField(name="canExport"), @TrackField(name="condition"), @TrackField(name="conditionParams")})
public class Permission
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="AUTH_PERMISSION_SEQ")
    @SequenceGenerator(name="AUTH_PERMISSION_SEQ", sequenceName="AUTH_PERMISSION_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(help="An unique permission name.")
    @NotNull
    @Column(unique=true)
    private String name;
    @Widget(help="Fully qualified object name or wild card package name.")
    @NotNull
    private String object;
    @Widget(title="Read", help="Whether to grant read access.")
    private Boolean canRead = Boolean.FALSE;
    @Widget(title="Write", help="Whether to grant write access.")
    private Boolean canWrite = Boolean.FALSE;
    @Widget(title="Create", help="Whether to grant create access.")
    private Boolean canCreate = Boolean.FALSE;
    @Widget(title="Remove", help="Whether to grant remove access.")
    private Boolean canRemove = Boolean.FALSE;
    @Widget(title="Export", help="Whether to grant export access.")
    private Boolean canExport = Boolean.FALSE;
    @Widget(help="Domain filter as condition.")
    @Size(max=1024)
    @Column(name="condition_value")
    private String condition;
    @Widget(help="Comma separated list of params for the condition.")
    private String conditionParams;

    public Permission() {
    }

    public Permission(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Boolean getCanRead() {
        return this.canRead == null ? Boolean.FALSE : this.canRead;
    }

    public void setCanRead(Boolean canRead) {
        this.canRead = canRead;
    }

    public Boolean getCanWrite() {
        return this.canWrite == null ? Boolean.FALSE : this.canWrite;
    }

    public void setCanWrite(Boolean canWrite) {
        this.canWrite = canWrite;
    }

    public Boolean getCanCreate() {
        return this.canCreate == null ? Boolean.FALSE : this.canCreate;
    }

    public void setCanCreate(Boolean canCreate) {
        this.canCreate = canCreate;
    }

    public Boolean getCanRemove() {
        return this.canRemove == null ? Boolean.FALSE : this.canRemove;
    }

    public void setCanRemove(Boolean canRemove) {
        this.canRemove = canRemove;
    }

    public Boolean getCanExport() {
        return this.canExport == null ? Boolean.FALSE : this.canExport;
    }

    public void setCanExport(Boolean canExport) {
        this.canExport = canExport;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getConditionParams() {
        return this.conditionParams;
    }

    public void setConditionParams(String conditionParams) {
        this.conditionParams = conditionParams;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(1475846639, this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("object", (Object)this.getObject()).add("canRead", (Object)this.getCanRead()).add("canWrite", (Object)this.getCanWrite()).add("canCreate", (Object)this.getCanCreate()).add("canRemove", (Object)this.getCanRemove()).add("canExport", (Object)this.getCanExport()).add("condition", (Object)this.getCondition()).add("conditionParams", (Object)this.getConditionParams()).omitNullValues().toString();
    }
}

