/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.team.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Role;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.TeamTopic;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="TEAM_TEAM", indexes={@Index(columnList="code")})
public class Team
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="TEAM_TEAM_SEQ")
    @SequenceGenerator(name="TEAM_TEAM_SEQ", sequenceName="TEAM_TEAM_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @NotNull
    @Column(unique=true)
    private String name;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Photo")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    private byte[] image;
    @Widget(title="Authorized roles")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roles;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<User> members;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="team", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TeamTopic> topics;
    @Widget(title="Code")
    private String code;
    @Widget(title="Type", selection="team.type.select")
    private String typeSelect;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Team() {
    }

    public Team(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void addRole(Role item) {
        if (this.getRoles() == null) {
            this.setRoles(new HashSet());
        }
        this.getRoles().add(item);
    }

    public void removeRole(Role item) {
        if (this.getRoles() == null) {
            return;
        }
        this.getRoles().remove(item);
    }

    public void clearRoles() {
        if (this.getRoles() != null) {
            this.getRoles().clear();
        }
    }

    public Set<User> getMembers() {
        return this.members;
    }

    public void setMembers(Set<User> members) {
        this.members = members;
    }

    public void addMember(User item) {
        if (this.getMembers() == null) {
            this.setMembers(new HashSet());
        }
        this.getMembers().add(item);
    }

    public void removeMember(User item) {
        if (this.getMembers() == null) {
            return;
        }
        this.getMembers().remove(item);
    }

    public void clearMembers() {
        if (this.getMembers() != null) {
            this.getMembers().clear();
        }
    }

    public List<TeamTopic> getTopics() {
        return this.topics;
    }

    public void setTopics(List<TeamTopic> topics) {
        this.topics = topics;
    }

    public void addTopic(TeamTopic item) {
        if (this.getTopics() == null) {
            this.setTopics(new ArrayList());
        }
        this.getTopics().add(item);
        item.setTeam(this);
    }

    public void removeTopic(TeamTopic item) {
        if (this.getTopics() == null) {
            return;
        }
        this.getTopics().remove(item);
    }

    public void clearTopics() {
        if (this.getTopics() != null) {
            this.getTopics().clear();
        }
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getTypeSelect() {
        return this.typeSelect;
    }

    public void setTypeSelect(String typeSelect) {
        this.typeSelect = typeSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Team)) {
            return false;
        }
        Team other = (Team)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(2602621, this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("typeSelect", (Object)this.getTypeSelect()).omitNullValues().toString();
    }
}

