/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.SharingSetting;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ICAL_CALENDAR", indexes={@Index(columnList="name"), @Index(columnList="user_id")})
public class ICalendar
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ICAL_CALENDAR_SEQ")
    @SequenceGenerator(name="ICAL_CALENDAR_SEQ", sequenceName="ICAL_CALENDAR_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="CID")
    private String cid;
    @Widget(title="Keep remote")
    private Boolean keepRemote = Boolean.FALSE;
    @Widget(title="User")
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Url")
    private String url;
    @Widget(title="Login")
    private String login;
    @Widget(title="Password")
    private String password;
    @Widget(title="Type", selection="icrm.calendar.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Advanced synchronization", selection="icalendar.synchronization.select")
    private String synchronizationSelect;
    @Widget(title="SSL")
    private Boolean isSslConnection = Boolean.FALSE;
    @Widget(title="Port")
    private Integer port = 80;
    @Widget(title="Valid")
    private Boolean isValid = Boolean.FALSE;
    @Widget(title="Last Synchronization")
    private LocalDateTime lastSynchronizationDateT;
    @Widget(title="Synchronization duration (week)")
    @Min(value=1L)
    private Integer synchronizationDuration = 1;
    @Widget(title="Sharing settings")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="calendar", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<SharingSetting> sharingSettingList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ICalendar() {
    }

    public ICalendar(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCid() {
        return this.cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public Boolean getKeepRemote() {
        return this.keepRemote == null ? Boolean.FALSE : this.keepRemote;
    }

    public void setKeepRemote(Boolean keepRemote) {
        this.keepRemote = keepRemote;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public String getSynchronizationSelect() {
        return this.synchronizationSelect;
    }

    public void setSynchronizationSelect(String synchronizationSelect) {
        this.synchronizationSelect = synchronizationSelect;
    }

    public Boolean getIsSslConnection() {
        return this.isSslConnection == null ? Boolean.FALSE : this.isSslConnection;
    }

    public void setIsSslConnection(Boolean isSslConnection) {
        this.isSslConnection = isSslConnection;
    }

    public Integer getPort() {
        return this.port == null ? 0 : this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Boolean getIsValid() {
        return this.isValid == null ? Boolean.FALSE : this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public LocalDateTime getLastSynchronizationDateT() {
        return this.lastSynchronizationDateT;
    }

    public void setLastSynchronizationDateT(LocalDateTime lastSynchronizationDateT) {
        this.lastSynchronizationDateT = lastSynchronizationDateT;
    }

    public Integer getSynchronizationDuration() {
        return this.synchronizationDuration == null ? 0 : this.synchronizationDuration;
    }

    public void setSynchronizationDuration(Integer synchronizationDuration) {
        this.synchronizationDuration = synchronizationDuration;
    }

    public List<SharingSetting> getSharingSettingList() {
        return this.sharingSettingList;
    }

    public void setSharingSettingList(List<SharingSetting> sharingSettingList) {
        this.sharingSettingList = sharingSettingList;
    }

    public void addSharingSettingListItem(SharingSetting item) {
        if (this.getSharingSettingList() == null) {
            this.setSharingSettingList(new ArrayList());
        }
        this.getSharingSettingList().add(item);
        item.setCalendar(this);
    }

    public void removeSharingSettingListItem(SharingSetting item) {
        if (this.getSharingSettingList() == null) {
            return;
        }
        this.getSharingSettingList().remove(item);
    }

    public void clearSharingSettingList() {
        if (this.getSharingSettingList() != null) {
            this.getSharingSettingList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ICalendar)) {
            return false;
        }
        ICalendar other = (ICalendar)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("cid", (Object)this.getCid()).add("keepRemote", (Object)this.getKeepRemote()).add("url", (Object)this.getUrl()).add("login", (Object)this.getLogin()).add("password", (Object)this.getPassword()).add("typeSelect", (Object)this.getTypeSelect()).add("synchronizationSelect", (Object)this.getSynchronizationSelect()).add("isSslConnection", (Object)this.getIsSslConnection()).add("port", (Object)this.getPort()).add("isValid", (Object)this.getIsValid()).omitNullValues().toString();
    }
}

