/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.stock.db.FreightCarrierCustomerAccountNumber;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STOCK_STOCK_CONFIG", indexes={@Index(columnList="receipt_default_stock_location"), @Index(columnList="pickup_default_stock_location"), @Index(columnList="quality_control_default_stock_location"), @Index(columnList="customer_virtual_stock_location"), @Index(columnList="supplier_virtual_stock_location"), @Index(columnList="inventory_virtual_stock_location"), @Index(columnList="customs_mass_unit"), @Index(columnList="planned_stock_move_message_template"), @Index(columnList="real_stock_move_message_template"), @Index(columnList="logistical_form_message_template"), @Index(columnList="signatory_user"), @Index(columnList="stock_rule_message_template"), @Index(columnList="direct_order_stock_location"), @Index(columnList="production_virtual_stock_location"), @Index(columnList="waste_stock_location"), @Index(columnList="component_default_stock_location"), @Index(columnList="finished_products_default_stock_location")})
@Track(fields={@TrackField(name="company", on={TrackEvent.UPDATE}), @TrackField(name="receiptDefaultStockLocation", on={TrackEvent.UPDATE}), @TrackField(name="pickupDefaultStockLocation", on={TrackEvent.UPDATE}), @TrackField(name="qualityControlDefaultStockLocation", on={TrackEvent.UPDATE}), @TrackField(name="customerVirtualStockLocation", on={TrackEvent.UPDATE}), @TrackField(name="supplierVirtualStockLocation", on={TrackEvent.UPDATE}), @TrackField(name="inventoryVirtualStockLocation", on={TrackEvent.UPDATE}), @TrackField(name="customsMassUnit", on={TrackEvent.UPDATE}), @TrackField(name="realizeStockMovesUponParcelPalletCollection", on={TrackEvent.UPDATE}), @TrackField(name="plannedStockMoveAutomaticMail", on={TrackEvent.UPDATE}), @TrackField(name="realStockMoveAutomaticMail", on={TrackEvent.UPDATE}), @TrackField(name="plannedStockMoveMessageTemplate", on={TrackEvent.UPDATE}), @TrackField(name="realStockMoveMessageTemplate", on={TrackEvent.UPDATE}), @TrackField(name="conformityCertificateTitle", on={TrackEvent.UPDATE}), @TrackField(name="conformityCertificateDescription", on={TrackEvent.UPDATE}), @TrackField(name="signatoryUser", on={TrackEvent.UPDATE}), @TrackField(name="displayTrackNbrOnPickingPrinting", on={TrackEvent.UPDATE}), @TrackField(name="displayBarcodeOnPickingPrinting", on={TrackEvent.UPDATE}), @TrackField(name="displayCustomerCodeOnPickingPrinting", on={TrackEvent.UPDATE}), @TrackField(name="displayPartnerSeqOnPrinting", on={TrackEvent.UPDATE}), @TrackField(name="displayLineDetailsOnPrinting", on={TrackEvent.UPDATE}), @TrackField(name="isWithReturnSurplus", on={TrackEvent.UPDATE}), @TrackField(name="isWithBackorder", on={TrackEvent.UPDATE}), @TrackField(name="pickingOrderPrintingDetailed", on={TrackEvent.UPDATE}), @TrackField(name="isDisplaySaleValueInPrinting", on={TrackEvent.UPDATE}), @TrackField(name="isDisplayAccountingValueInPrinting", on={TrackEvent.UPDATE}), @TrackField(name="isDisplayAgPriceInPrinting", on={TrackEvent.UPDATE}), @TrackField(name="stockValuationTypeSelect", on={TrackEvent.UPDATE}), @TrackField(name="displayTrackNbrOnCertificateOfConformityPrinting", on={TrackEvent.UPDATE}), @TrackField(name="displayExtRefOnCertificateOfConformityPrinting", on={TrackEvent.UPDATE}), @TrackField(name="directOrderStockLocation", on={TrackEvent.UPDATE}), @TrackField(name="productionVirtualStockLocation", on={TrackEvent.UPDATE}), @TrackField(name="wasteStockLocation", on={TrackEvent.UPDATE}), @TrackField(name="componentDefaultStockLocation", on={TrackEvent.UPDATE}), @TrackField(name="finishedProductsDefaultStockLocation", on={TrackEvent.UPDATE})})
public class StockConfig
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_STOCK_CONFIG_SEQ")
    @SequenceGenerator(name="STOCK_STOCK_CONFIG_SEQ", sequenceName="STOCK_STOCK_CONFIG_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Company")
    @NotNull
    @JoinColumn(unique=true)
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Receipt default stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation receiptDefaultStockLocation;
    @Widget(title="Pickup default stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation pickupDefaultStockLocation;
    @Widget(title="Quality control default stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation qualityControlDefaultStockLocation;
    @Widget(title="Customer virtual stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation customerVirtualStockLocation;
    @Widget(title="Supplier virtual stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation supplierVirtualStockLocation;
    @Widget(title="Inventory virtual stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation inventoryVirtualStockLocation;
    @Widget(title="Unit of mass")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit customsMassUnit;
    @Widget(title="Realize stock moves upon parcel/pallet collection")
    private Boolean realizeStockMovesUponParcelPalletCollection = Boolean.FALSE;
    @Widget(title="Send email when planning stock move")
    private Boolean plannedStockMoveAutomaticMail = Boolean.FALSE;
    @Widget(title="Send email on stock move realization")
    private Boolean realStockMoveAutomaticMail = Boolean.FALSE;
    @Widget(title="Message template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template plannedStockMoveMessageTemplate;
    @Widget(title="Message template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template realStockMoveMessageTemplate;
    @Widget(title="Send email when saving logistical form")
    private Boolean logisticalFormAutomaticEmail = Boolean.FALSE;
    @Widget(title="Message template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template logisticalFormMessageTemplate;
    @Widget(title="Customer account numbers to carriers")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="stockConfig", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<FreightCarrierCustomerAccountNumber> freightCarrierCustomerAccountNumberList;
    @Widget(title="Certificate of conformity title", translatable=true)
    private String conformityCertificateTitle;
    @Widget(title="Text in certificate of conformity", translatable=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String conformityCertificateDescription;
    @Widget(title="Default signatory user")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User signatoryUser;
    @Widget(title="Display tracking number details on Picking printing")
    private Boolean displayTrackNbrOnPickingPrinting = Boolean.TRUE;
    @Widget(title="Display barcode on Picking printing")
    private Boolean displayBarcodeOnPickingPrinting = Boolean.TRUE;
    @Widget(title="Display customer code on picking printing")
    private Boolean displayCustomerCodeOnPickingPrinting = Boolean.TRUE;
    @Widget(title="Display partner sequence on printing")
    private Boolean displayPartnerSeqOnPrinting = Boolean.TRUE;
    @Widget(title="Display line details on printing")
    private Boolean displayLineDetailsOnPrinting = Boolean.TRUE;
    @Widget(title="Return Surplus")
    private Boolean isWithReturnSurplus = Boolean.FALSE;
    @Widget(title="Manage backorder")
    private Boolean isWithBackorder = Boolean.FALSE;
    @Widget(title="Picking order printing detailed")
    private Boolean pickingOrderPrintingDetailed = Boolean.TRUE;
    @Widget(title="Display sale value in location financial data printing")
    private Boolean isDisplaySaleValueInPrinting = Boolean.TRUE;
    @Widget(title="Display accounting value in location financial data printing")
    private Boolean isDisplayAccountingValueInPrinting = Boolean.TRUE;
    @Widget(title="Display average price in printing")
    private Boolean isDisplayAgPriceInPrinting = Boolean.TRUE;
    @Widget(title="Display purchase value in location financial data printing")
    private Boolean isDisplayPurchaseValueInPrinting = Boolean.TRUE;
    @Widget(title="Stock location value on form view", selection="stock.stock.location.value.type")
    private Integer stockValuationTypeSelect = 0;
    @Widget(title="Display tracking number details on certificate of conformity printing")
    private Boolean displayTrackNbrOnCertificateOfConformityPrinting = Boolean.TRUE;
    @Widget(title="Display external ref. on certificate of conformity printing")
    private Boolean displayExtRefOnCertificateOfConformityPrinting = Boolean.TRUE;
    @Widget(title="Message template for stock rules")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template stockRuleMessageTemplate;
    @Widget(title="Display product code on printing")
    private Boolean displayProductCodeOnPrinting = Boolean.TRUE;
    @Widget(title="Display price on printing")
    private Boolean displayPriceOnPrinting = Boolean.TRUE;
    @Widget(title="Display order reference and order date")
    private Boolean displayOrderReferenceAndOrderDate = Boolean.TRUE;
    @Widget(title="Direct order default stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation directOrderStockLocation;
    @Widget(title="Production virtual stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation productionVirtualStockLocation;
    @Widget(title="Waste stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation wasteStockLocation;
    @Widget(title="Components default stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation componentDefaultStockLocation;
    @Widget(title="Finished products default stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation finishedProductsDefaultStockLocation;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public StockConfig() {
    }

    public StockConfig(Boolean displayBarcodeOnPickingPrinting) {
        this.displayBarcodeOnPickingPrinting = displayBarcodeOnPickingPrinting;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public StockLocation getReceiptDefaultStockLocation() {
        return this.receiptDefaultStockLocation;
    }

    public void setReceiptDefaultStockLocation(StockLocation receiptDefaultStockLocation) {
        this.receiptDefaultStockLocation = receiptDefaultStockLocation;
    }

    public StockLocation getPickupDefaultStockLocation() {
        return this.pickupDefaultStockLocation;
    }

    public void setPickupDefaultStockLocation(StockLocation pickupDefaultStockLocation) {
        this.pickupDefaultStockLocation = pickupDefaultStockLocation;
    }

    public StockLocation getQualityControlDefaultStockLocation() {
        return this.qualityControlDefaultStockLocation;
    }

    public void setQualityControlDefaultStockLocation(StockLocation qualityControlDefaultStockLocation) {
        this.qualityControlDefaultStockLocation = qualityControlDefaultStockLocation;
    }

    public StockLocation getCustomerVirtualStockLocation() {
        return this.customerVirtualStockLocation;
    }

    public void setCustomerVirtualStockLocation(StockLocation customerVirtualStockLocation) {
        this.customerVirtualStockLocation = customerVirtualStockLocation;
    }

    public StockLocation getSupplierVirtualStockLocation() {
        return this.supplierVirtualStockLocation;
    }

    public void setSupplierVirtualStockLocation(StockLocation supplierVirtualStockLocation) {
        this.supplierVirtualStockLocation = supplierVirtualStockLocation;
    }

    public StockLocation getInventoryVirtualStockLocation() {
        return this.inventoryVirtualStockLocation;
    }

    public void setInventoryVirtualStockLocation(StockLocation inventoryVirtualStockLocation) {
        this.inventoryVirtualStockLocation = inventoryVirtualStockLocation;
    }

    public Unit getCustomsMassUnit() {
        return this.customsMassUnit;
    }

    public void setCustomsMassUnit(Unit customsMassUnit) {
        this.customsMassUnit = customsMassUnit;
    }

    public Boolean getRealizeStockMovesUponParcelPalletCollection() {
        return this.realizeStockMovesUponParcelPalletCollection == null ? Boolean.FALSE : this.realizeStockMovesUponParcelPalletCollection;
    }

    public void setRealizeStockMovesUponParcelPalletCollection(Boolean realizeStockMovesUponParcelPalletCollection) {
        this.realizeStockMovesUponParcelPalletCollection = realizeStockMovesUponParcelPalletCollection;
    }

    public Boolean getPlannedStockMoveAutomaticMail() {
        return this.plannedStockMoveAutomaticMail == null ? Boolean.FALSE : this.plannedStockMoveAutomaticMail;
    }

    public void setPlannedStockMoveAutomaticMail(Boolean plannedStockMoveAutomaticMail) {
        this.plannedStockMoveAutomaticMail = plannedStockMoveAutomaticMail;
    }

    public Boolean getRealStockMoveAutomaticMail() {
        return this.realStockMoveAutomaticMail == null ? Boolean.FALSE : this.realStockMoveAutomaticMail;
    }

    public void setRealStockMoveAutomaticMail(Boolean realStockMoveAutomaticMail) {
        this.realStockMoveAutomaticMail = realStockMoveAutomaticMail;
    }

    public Template getPlannedStockMoveMessageTemplate() {
        return this.plannedStockMoveMessageTemplate;
    }

    public void setPlannedStockMoveMessageTemplate(Template plannedStockMoveMessageTemplate) {
        this.plannedStockMoveMessageTemplate = plannedStockMoveMessageTemplate;
    }

    public Template getRealStockMoveMessageTemplate() {
        return this.realStockMoveMessageTemplate;
    }

    public void setRealStockMoveMessageTemplate(Template realStockMoveMessageTemplate) {
        this.realStockMoveMessageTemplate = realStockMoveMessageTemplate;
    }

    public Boolean getLogisticalFormAutomaticEmail() {
        return this.logisticalFormAutomaticEmail == null ? Boolean.FALSE : this.logisticalFormAutomaticEmail;
    }

    public void setLogisticalFormAutomaticEmail(Boolean logisticalFormAutomaticEmail) {
        this.logisticalFormAutomaticEmail = logisticalFormAutomaticEmail;
    }

    public Template getLogisticalFormMessageTemplate() {
        return this.logisticalFormMessageTemplate;
    }

    public void setLogisticalFormMessageTemplate(Template logisticalFormMessageTemplate) {
        this.logisticalFormMessageTemplate = logisticalFormMessageTemplate;
    }

    public List<FreightCarrierCustomerAccountNumber> getFreightCarrierCustomerAccountNumberList() {
        return this.freightCarrierCustomerAccountNumberList;
    }

    public void setFreightCarrierCustomerAccountNumberList(List<FreightCarrierCustomerAccountNumber> freightCarrierCustomerAccountNumberList) {
        this.freightCarrierCustomerAccountNumberList = freightCarrierCustomerAccountNumberList;
    }

    public void addFreightCarrierCustomerAccountNumberListItem(FreightCarrierCustomerAccountNumber item) {
        if (this.getFreightCarrierCustomerAccountNumberList() == null) {
            this.setFreightCarrierCustomerAccountNumberList(new ArrayList());
        }
        this.getFreightCarrierCustomerAccountNumberList().add(item);
        item.setStockConfig(this);
    }

    public void removeFreightCarrierCustomerAccountNumberListItem(FreightCarrierCustomerAccountNumber item) {
        if (this.getFreightCarrierCustomerAccountNumberList() == null) {
            return;
        }
        this.getFreightCarrierCustomerAccountNumberList().remove(item);
    }

    public void clearFreightCarrierCustomerAccountNumberList() {
        if (this.getFreightCarrierCustomerAccountNumberList() != null) {
            this.getFreightCarrierCustomerAccountNumberList().clear();
        }
    }

    public String getConformityCertificateTitle() {
        return this.conformityCertificateTitle;
    }

    public void setConformityCertificateTitle(String conformityCertificateTitle) {
        this.conformityCertificateTitle = conformityCertificateTitle;
    }

    public String getConformityCertificateDescription() {
        return this.conformityCertificateDescription;
    }

    public void setConformityCertificateDescription(String conformityCertificateDescription) {
        this.conformityCertificateDescription = conformityCertificateDescription;
    }

    public User getSignatoryUser() {
        return this.signatoryUser;
    }

    public void setSignatoryUser(User signatoryUser) {
        this.signatoryUser = signatoryUser;
    }

    public Boolean getDisplayTrackNbrOnPickingPrinting() {
        return this.displayTrackNbrOnPickingPrinting == null ? Boolean.FALSE : this.displayTrackNbrOnPickingPrinting;
    }

    public void setDisplayTrackNbrOnPickingPrinting(Boolean displayTrackNbrOnPickingPrinting) {
        this.displayTrackNbrOnPickingPrinting = displayTrackNbrOnPickingPrinting;
    }

    public Boolean getDisplayBarcodeOnPickingPrinting() {
        return this.displayBarcodeOnPickingPrinting == null ? Boolean.FALSE : this.displayBarcodeOnPickingPrinting;
    }

    public void setDisplayBarcodeOnPickingPrinting(Boolean displayBarcodeOnPickingPrinting) {
        this.displayBarcodeOnPickingPrinting = displayBarcodeOnPickingPrinting;
    }

    public Boolean getDisplayCustomerCodeOnPickingPrinting() {
        return this.displayCustomerCodeOnPickingPrinting == null ? Boolean.FALSE : this.displayCustomerCodeOnPickingPrinting;
    }

    public void setDisplayCustomerCodeOnPickingPrinting(Boolean displayCustomerCodeOnPickingPrinting) {
        this.displayCustomerCodeOnPickingPrinting = displayCustomerCodeOnPickingPrinting;
    }

    public Boolean getDisplayPartnerSeqOnPrinting() {
        return this.displayPartnerSeqOnPrinting == null ? Boolean.FALSE : this.displayPartnerSeqOnPrinting;
    }

    public void setDisplayPartnerSeqOnPrinting(Boolean displayPartnerSeqOnPrinting) {
        this.displayPartnerSeqOnPrinting = displayPartnerSeqOnPrinting;
    }

    public Boolean getDisplayLineDetailsOnPrinting() {
        return this.displayLineDetailsOnPrinting == null ? Boolean.FALSE : this.displayLineDetailsOnPrinting;
    }

    public void setDisplayLineDetailsOnPrinting(Boolean displayLineDetailsOnPrinting) {
        this.displayLineDetailsOnPrinting = displayLineDetailsOnPrinting;
    }

    public Boolean getIsWithReturnSurplus() {
        return this.isWithReturnSurplus == null ? Boolean.FALSE : this.isWithReturnSurplus;
    }

    public void setIsWithReturnSurplus(Boolean isWithReturnSurplus) {
        this.isWithReturnSurplus = isWithReturnSurplus;
    }

    public Boolean getIsWithBackorder() {
        return this.isWithBackorder == null ? Boolean.FALSE : this.isWithBackorder;
    }

    public void setIsWithBackorder(Boolean isWithBackorder) {
        this.isWithBackorder = isWithBackorder;
    }

    public Boolean getPickingOrderPrintingDetailed() {
        return this.pickingOrderPrintingDetailed == null ? Boolean.FALSE : this.pickingOrderPrintingDetailed;
    }

    public void setPickingOrderPrintingDetailed(Boolean pickingOrderPrintingDetailed) {
        this.pickingOrderPrintingDetailed = pickingOrderPrintingDetailed;
    }

    public Boolean getIsDisplaySaleValueInPrinting() {
        return this.isDisplaySaleValueInPrinting == null ? Boolean.FALSE : this.isDisplaySaleValueInPrinting;
    }

    public void setIsDisplaySaleValueInPrinting(Boolean isDisplaySaleValueInPrinting) {
        this.isDisplaySaleValueInPrinting = isDisplaySaleValueInPrinting;
    }

    public Boolean getIsDisplayAccountingValueInPrinting() {
        return this.isDisplayAccountingValueInPrinting == null ? Boolean.FALSE : this.isDisplayAccountingValueInPrinting;
    }

    public void setIsDisplayAccountingValueInPrinting(Boolean isDisplayAccountingValueInPrinting) {
        this.isDisplayAccountingValueInPrinting = isDisplayAccountingValueInPrinting;
    }

    public Boolean getIsDisplayAgPriceInPrinting() {
        return this.isDisplayAgPriceInPrinting == null ? Boolean.FALSE : this.isDisplayAgPriceInPrinting;
    }

    public void setIsDisplayAgPriceInPrinting(Boolean isDisplayAgPriceInPrinting) {
        this.isDisplayAgPriceInPrinting = isDisplayAgPriceInPrinting;
    }

    public Boolean getIsDisplayPurchaseValueInPrinting() {
        return this.isDisplayPurchaseValueInPrinting == null ? Boolean.FALSE : this.isDisplayPurchaseValueInPrinting;
    }

    public void setIsDisplayPurchaseValueInPrinting(Boolean isDisplayPurchaseValueInPrinting) {
        this.isDisplayPurchaseValueInPrinting = isDisplayPurchaseValueInPrinting;
    }

    public Integer getStockValuationTypeSelect() {
        return this.stockValuationTypeSelect == null ? 0 : this.stockValuationTypeSelect;
    }

    public void setStockValuationTypeSelect(Integer stockValuationTypeSelect) {
        this.stockValuationTypeSelect = stockValuationTypeSelect;
    }

    public Boolean getDisplayTrackNbrOnCertificateOfConformityPrinting() {
        return this.displayTrackNbrOnCertificateOfConformityPrinting == null ? Boolean.FALSE : this.displayTrackNbrOnCertificateOfConformityPrinting;
    }

    public void setDisplayTrackNbrOnCertificateOfConformityPrinting(Boolean displayTrackNbrOnCertificateOfConformityPrinting) {
        this.displayTrackNbrOnCertificateOfConformityPrinting = displayTrackNbrOnCertificateOfConformityPrinting;
    }

    public Boolean getDisplayExtRefOnCertificateOfConformityPrinting() {
        return this.displayExtRefOnCertificateOfConformityPrinting == null ? Boolean.FALSE : this.displayExtRefOnCertificateOfConformityPrinting;
    }

    public void setDisplayExtRefOnCertificateOfConformityPrinting(Boolean displayExtRefOnCertificateOfConformityPrinting) {
        this.displayExtRefOnCertificateOfConformityPrinting = displayExtRefOnCertificateOfConformityPrinting;
    }

    public Template getStockRuleMessageTemplate() {
        return this.stockRuleMessageTemplate;
    }

    public void setStockRuleMessageTemplate(Template stockRuleMessageTemplate) {
        this.stockRuleMessageTemplate = stockRuleMessageTemplate;
    }

    public Boolean getDisplayProductCodeOnPrinting() {
        return this.displayProductCodeOnPrinting == null ? Boolean.FALSE : this.displayProductCodeOnPrinting;
    }

    public void setDisplayProductCodeOnPrinting(Boolean displayProductCodeOnPrinting) {
        this.displayProductCodeOnPrinting = displayProductCodeOnPrinting;
    }

    public Boolean getDisplayPriceOnPrinting() {
        return this.displayPriceOnPrinting == null ? Boolean.FALSE : this.displayPriceOnPrinting;
    }

    public void setDisplayPriceOnPrinting(Boolean displayPriceOnPrinting) {
        this.displayPriceOnPrinting = displayPriceOnPrinting;
    }

    public Boolean getDisplayOrderReferenceAndOrderDate() {
        return this.displayOrderReferenceAndOrderDate == null ? Boolean.FALSE : this.displayOrderReferenceAndOrderDate;
    }

    public void setDisplayOrderReferenceAndOrderDate(Boolean displayOrderReferenceAndOrderDate) {
        this.displayOrderReferenceAndOrderDate = displayOrderReferenceAndOrderDate;
    }

    public StockLocation getDirectOrderStockLocation() {
        return this.directOrderStockLocation;
    }

    public void setDirectOrderStockLocation(StockLocation directOrderStockLocation) {
        this.directOrderStockLocation = directOrderStockLocation;
    }

    public StockLocation getProductionVirtualStockLocation() {
        return this.productionVirtualStockLocation;
    }

    public void setProductionVirtualStockLocation(StockLocation productionVirtualStockLocation) {
        this.productionVirtualStockLocation = productionVirtualStockLocation;
    }

    public StockLocation getWasteStockLocation() {
        return this.wasteStockLocation;
    }

    public void setWasteStockLocation(StockLocation wasteStockLocation) {
        this.wasteStockLocation = wasteStockLocation;
    }

    public StockLocation getComponentDefaultStockLocation() {
        return this.componentDefaultStockLocation;
    }

    public void setComponentDefaultStockLocation(StockLocation componentDefaultStockLocation) {
        this.componentDefaultStockLocation = componentDefaultStockLocation;
    }

    public StockLocation getFinishedProductsDefaultStockLocation() {
        return this.finishedProductsDefaultStockLocation;
    }

    public void setFinishedProductsDefaultStockLocation(StockLocation finishedProductsDefaultStockLocation) {
        this.finishedProductsDefaultStockLocation = finishedProductsDefaultStockLocation;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StockConfig)) {
            return false;
        }
        StockConfig other = (StockConfig)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCompany(), other.getCompany());
    }

    public int hashCode() {
        return Objects.hash(34399704, this.getCompany());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("realizeStockMovesUponParcelPalletCollection", (Object)this.getRealizeStockMovesUponParcelPalletCollection()).add("plannedStockMoveAutomaticMail", (Object)this.getPlannedStockMoveAutomaticMail()).add("realStockMoveAutomaticMail", (Object)this.getRealStockMoveAutomaticMail()).add("logisticalFormAutomaticEmail", (Object)this.getLogisticalFormAutomaticEmail()).add("conformityCertificateTitle", (Object)this.getConformityCertificateTitle()).add("displayTrackNbrOnPickingPrinting", (Object)this.getDisplayTrackNbrOnPickingPrinting()).add("displayBarcodeOnPickingPrinting", (Object)this.getDisplayBarcodeOnPickingPrinting()).add("displayCustomerCodeOnPickingPrinting", (Object)this.getDisplayCustomerCodeOnPickingPrinting()).add("displayPartnerSeqOnPrinting", (Object)this.getDisplayPartnerSeqOnPrinting()).add("displayLineDetailsOnPrinting", (Object)this.getDisplayLineDetailsOnPrinting()).add("isWithReturnSurplus", (Object)this.getIsWithReturnSurplus()).omitNullValues().toString();
    }
}

