/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web;

import com.axelor.app.AppSettings;
import com.axelor.app.internal.AppLogger;
import com.axelor.meta.loader.ViewWatcher;
import com.axelor.web.AppServletModule;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.SessionCookieConfig;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.guice.GuiceResourceFactory;
import org.jboss.resteasy.plugins.guice.ModuleProcessor;
import org.jboss.resteasy.plugins.server.servlet.ListenerBootstrap;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class AppContextListener
extends GuiceServletContextListener {
    private ResteasyDeployment deployment;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        AppLogger.install();
        super.contextInitialized(servletContextEvent);
        ServletContext context = servletContextEvent.getServletContext();
        ListenerBootstrap config = new ListenerBootstrap(context);
        final Injector injector = (Injector)context.getAttribute(Injector.class.getName());
        SessionCookieConfig cookieConfig = context.getSessionCookieConfig();
        cookieConfig.setHttpOnly(true);
        cookieConfig.setSecure(AppSettings.get().getBoolean("session.cookie.secure", false));
        this.deployment = config.createDeployment();
        ResteasyProviderFactory providerFactory = ResteasyProviderFactory.getInstance();
        ResourceMethodRegistry registry = new ResourceMethodRegistry(providerFactory){

            public void addPerRequestResource(Class clazz) {
                Binding binding = injector.getBinding(clazz);
                if (binding == null) {
                    super.addPerRequestResource(clazz);
                } else {
                    super.addResourceFactory((ResourceFactory)new GuiceResourceFactory(binding.getProvider(), clazz));
                }
            }
        };
        SynchronousDispatcher dispatcher = new SynchronousDispatcher(providerFactory, registry);
        this.deployment.setProviderFactory(providerFactory);
        this.deployment.setAsyncJobServiceEnabled(false);
        this.deployment.setDispatcher((Dispatcher)dispatcher);
        this.deployment.start();
        context.setAttribute(ResteasyProviderFactory.class.getName(), (Object)providerFactory);
        context.setAttribute(Dispatcher.class.getName(), (Object)dispatcher);
        context.setAttribute(Registry.class.getName(), (Object)registry);
        ModuleProcessor processor = new ModuleProcessor((Registry)registry, providerFactory);
        Injector current = injector;
        while (current != null) {
            processor.processInjector(current);
            current = injector.getParent();
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ViewWatcher.getInstance().stop();
        this.deployment.stop();
        super.contextDestroyed(servletContextEvent);
        AppLogger.uninstall();
    }

    protected Injector getInjector() {
        return Guice.createInjector((Module[])new Module[]{new AppServletModule()});
    }
}

