/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web;

import com.axelor.app.AppSettings;
import com.axelor.db.search.SearchService;
import com.axelor.db.tenants.TenantModule;
import com.axelor.event.Event;
import com.axelor.events.ShutdownEvent;
import com.axelor.events.StartupEvent;
import com.axelor.meta.loader.ModuleManager;
import com.axelor.quartz.JobRunner;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AppInitializer
extends HttpServlet {
    private static final long serialVersionUID = -2493577642638670615L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AppInitializer.class);
    @Inject
    private ModuleManager moduleManager;
    @Inject
    private JobRunner jobRunner;
    @Inject
    private SearchService searchService;
    @Inject
    private Event<StartupEvent> startupEvent;
    @Inject
    private Event<ShutdownEvent> shutdownEvent;

    public void init() throws ServletException {
        LOGGER.info("Initializing...");
        try {
            this.moduleManager.initialize(false, AppSettings.get().getBoolean("data.import.demo-data", true));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (this.searchService.isEnabled()) {
            try {
                this.searchService.createIndex(false);
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            if (this.jobRunner.isEnabled()) {
                if (TenantModule.isEnabled()) {
                    LOGGER.info("Scheduler is not supported in multi-tenant mode.");
                } else {
                    this.jobRunner.start();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        this.startupEvent.fire((Object)new StartupEvent());
        LOGGER.info("Ready to serve...");
    }

    public void destroy() {
        try {
            this.shutdownEvent.fire((Object)new ShutdownEvent());
            this.jobRunner.stop();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

