/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web;

import com.axelor.app.AppSettings;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

@Singleton
public final class AppSessionListener
implements HttpSessionListener {
    private final int timeout;
    private static final Map<String, HttpSession> sessions = new ConcurrentHashMap<String, HttpSession>();

    @Inject
    public AppSessionListener(AppSettings settings) {
        this.timeout = settings.getInt("session.timeout", 60);
    }

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        sessions.put(session.getId(), session);
        session.setMaxInactiveInterval(this.timeout * 60);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        sessions.remove(session.getId());
    }

    public static Set<String> getActiveSessions() {
        return sessions.keySet();
    }

    public static HttpSession getSession(String id) {
        return sessions.get(id);
    }
}

