/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.internal;

import com.axelor.meta.MetaScanner;
import com.axelor.web.StaticResourceProvider;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;

public final class StaticResources {
    private static final StaticResources INSTANCE = new StaticResources();
    private Set<String> styles;
    private Set<String> scripts;

    private StaticResources() {
        ArrayList resources = new ArrayList();
        MetaScanner.findSubTypesOf(StaticResourceProvider.class).find().stream().map(clazz -> {
            try {
                return (StaticResourceProvider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid static resource provider: " + clazz, e);
            }
        }).forEach(provider -> provider.register(resources));
        this.styles = resources.stream().filter(res -> res.endsWith(".css")).collect(Collectors.toSet());
        this.scripts = resources.stream().filter(res -> res.endsWith(".js")).collect(Collectors.toSet());
    }

    public static Set<String> getStyles() {
        return StaticResources.INSTANCE.styles;
    }

    public static Set<String> getScripts() {
        return StaticResources.INSTANCE.scripts;
    }
}

