/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.service;

import com.axelor.mail.web.MailController;
import com.axelor.meta.ActionExecutor;
import com.axelor.meta.schema.views.MenuItem;
import com.axelor.meta.service.MetaService;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Response;
import com.axelor.team.web.TaskController;
import com.axelor.web.service.AbstractService;
import com.google.inject.servlet.RequestScoped;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@RequestScoped
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/action")
public class ActionService
extends AbstractService {
    @Inject
    private MetaService service;
    @Inject
    private TaskController teamController;
    @Inject
    private MailController mailController;
    @Inject
    private ActionExecutor actionExecutor;

    @GET
    @Path(value="menu/all")
    public Response all() {
        Response response = new Response();
        try {
            response.setData((Object)this.service.getMenus(false));
            response.setStatus(Response.STATUS_SUCCESS);
        }
        catch (Exception e) {
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error(e.getMessage(), (Throwable)e);
            }
            response.setException((Throwable)e);
        }
        return response;
    }

    @GET
    @Path(value="menu/tags")
    public Response tags() {
        return this.tags(false, Collections.emptyList());
    }

    @POST
    @Path(value="menu/tags")
    public Response tags(TagRequest request) {
        return this.tags(true, request.getNames());
    }

    private Response tags(boolean inNamesOnly, List<String> names) {
        ActionResponse response = new ActionResponse();
        ArrayList tags = new ArrayList();
        try {
            for (MenuItem item : this.service.getMenus(true, inNamesOnly, names)) {
                HashMap<String, String> tag = new HashMap<String, String>();
                tag.put("name", item.getName());
                tag.put("tag", item.getTag());
                tag.put("tagStyle", item.getTagStyle());
                tags.add(tag);
            }
            response.setValue("tags", tags);
            response.setStatus(Response.STATUS_SUCCESS);
            this.mailController.countMail(null, response);
            this.teamController.countTasks(null, response);
        }
        catch (Exception e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
            response.setException((Throwable)e);
        }
        return response;
    }

    @POST
    public Response execute(ActionRequest request) {
        return this.actionExecutor.execute(request);
    }

    @POST
    @Path(value="{action}")
    public Response execute(@PathParam(value="action") String action, ActionRequest request) {
        request.setAction(action);
        return this.actionExecutor.execute(request);
    }

    private static class TagRequest {
        private List<String> names;

        private TagRequest() {
        }

        public List<String> getNames() {
            return this.names;
        }
    }
}

