/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.service;

import com.axelor.common.FileUtils;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.schema.actions.ActionExport;
import com.axelor.web.service.AbstractService;
import com.google.inject.persist.Transactional;
import com.google.inject.servlet.RequestScoped;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@RequestScoped
@Path(value="/files")
public class FileService
extends AbstractService {
    @Inject
    private MetaFiles files;

    @GET
    @Path(value="data-export/{name:.*}")
    public Response exportFile(@PathParam(value="name") String name) {
        File file = FileUtils.getFile((File)ActionExport.getExportPath(), (String)name, (String[])new String[0]);
        if (!file.isFile()) {
            throw new IllegalArgumentException(new FileNotFoundException(name));
        }
        return Response.ok((Object)file, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE).header("Content-Disposition", (Object)("attachment; filename=\"" + file.getName() + "\"")).header("Content-Transfer-Encoding", (Object)"binary").build();
    }

    @GET
    @Path(value="report/{link:.*}")
    public Response reportFile(@PathParam(value="link") String link, @QueryParam(value="name") String name) {
        java.nio.file.Path file = MetaFiles.findTempFile((String)link);
        if (file == null || !file.toFile().isFile()) {
            throw new IllegalArgumentException(new FileNotFoundException(name));
        }
        MediaType type = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        if (name.endsWith(".pdf")) {
            type = new MediaType("application", "pdf");
        }
        if (name.endsWith(".html")) {
            type = new MediaType("text", "html");
        }
        if (name.endsWith(".png")) {
            type = new MediaType("image", "png");
        }
        if (name.endsWith(".jpg")) {
            type = new MediaType("image", "jpg");
        }
        if (name.endsWith(".svg")) {
            type = new MediaType("image", "svg+xml");
        }
        if (name.endsWith(".gif")) {
            type = new MediaType("image", "gif");
        }
        if (name.endsWith(".webp")) {
            type = new MediaType("image", "webp");
        }
        String fileName = name == null ? file.toFile().getName() : name;
        Response.ResponseBuilder builder = Response.ok((Object)file.toFile(), (MediaType)type);
        if (type != MediaType.APPLICATION_OCTET_STREAM_TYPE) {
            return builder.header("Content-Disposition", (Object)("inline; filename=\"" + fileName + "\"")).build();
        }
        return builder.header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\"")).header("Content-Transfer-Encoding", (Object)"binary").build();
    }

    @DELETE
    @Path(value="upload/{fileId}")
    @Produces(value={"application/json"})
    public Response clean(@PathParam(value="fileId") String fileId) {
        try {
            this.files.clean(fileId);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="upload")
    @Produces(value={"application/json"})
    @Consumes(value={"application/octet-stream"})
    @Transactional
    public Response upload(@HeaderParam(value="X-File-Id") String fileId, @HeaderParam(value="X-File-Name") String fileName, @HeaderParam(value="X-File-Type") String fileType, @HeaderParam(value="X-File-Size") Long fileSize, @HeaderParam(value="X-File-Offset") Long fileOffset, InputStream stream) {
        if (fileName == null || fileSize == null || fileOffset == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (fileId == null && fileOffset == 0L) {
            fileId = UUID.randomUUID().toString();
        }
        if (fileId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        HashMap<String, String> data = new HashMap<String, String>();
        try {
            fileName = URLDecoder.decode(fileName, "UTF-8");
            MetaFiles.checkPath((String)fileName);
            MetaFiles.checkType((String)fileType);
            File file = this.files.upload(stream, fileOffset.longValue(), fileSize.longValue(), fileId);
            MetaFiles.checkType((File)file);
            if (Files.size(file.toPath()) == fileSize) {
                MetaFile meta = new MetaFile();
                meta.setFileName(fileName);
                meta.setFileType(fileType);
                this.files.upload(file, meta);
                return Response.ok((Object)meta).build();
            }
        }
        catch (IllegalArgumentException e) {
            data.put("error", e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(data).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            data.put("error", e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(data).build();
        }
        if (fileOffset == 0L) {
            data.put("fileId", fileId);
        }
        return Response.ok(data).build();
    }
}

