/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.tags;

import com.axelor.app.AppSettings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public abstract class AbstractTag
extends SimpleTagSupport {
    private String src;
    private boolean production = AppSettings.get().isProduction();
    protected static final Pattern dirPattern = Pattern.compile("^[\\./]*");

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    private boolean exists(String path) {
        try {
            return this.getResource(path) != null;
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            return false;
        }
    }

    protected URL getResource(String path) throws MalformedURLException {
        Matcher matcher = dirPattern.matcher(path);
        String resource = matcher.find() ? matcher.replaceFirst("/") : path;
        PageContext ctx = (PageContext)this.getJspContext();
        return ctx.getServletContext().getResource(resource);
    }

    protected List<String> getScripts() throws IOException {
        return Arrays.asList(this.src);
    }

    protected abstract void doTag(String var1) throws IOException;

    private boolean gzipSupported() {
        PageContext context = (PageContext)this.getJspContext();
        HttpServletRequest req = (HttpServletRequest)context.getRequest();
        String encodings = req.getHeader("Accept-Encoding");
        return encodings != null && encodings.toLowerCase().contains("gzip");
    }

    public void doTag() throws JspException, IOException {
        List<String> scripts;
        if (this.production) {
            String gzipped = this.src.replaceAll("^([\\./]*)(?:js|css)\\/(.*)\\.(js|css)$", "$1dist/$2.gzip.$3");
            if (this.exists(gzipped) && this.gzipSupported()) {
                this.doTag(gzipped);
                return;
            }
            String minified = this.src.replaceAll("^([\\./]*)(?:js|css)\\/(.*)\\.(js|css)$", "$1dist/$2.min.$3");
            if (this.exists(minified)) {
                this.doTag(minified);
                return;
            }
        }
        if ((scripts = this.getScripts()) == null || scripts.isEmpty()) {
            return;
        }
        for (String script : scripts) {
            this.doTag(script);
        }
    }
}

