/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.App;
import com.axelor.apps.client.portal.db.OnlinePaymentMethod;
import com.axelor.db.EntityHelper;
import com.axelor.db.Model;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_APP_PORTAL")
@Track(fields={@TrackField(name="manageSaleOrders", on={TrackEvent.UPDATE}), @TrackField(name="manageInvoices", on={TrackEvent.UPDATE}), @TrackField(name="manageTickets", on={TrackEvent.UPDATE}), @TrackField(name="manageProjects", on={TrackEvent.UPDATE}), @TrackField(name="manageDelivery", on={TrackEvent.UPDATE}), @TrackField(name="canConfirmOnline", on={TrackEvent.UPDATE}), @TrackField(name="canPayOnline", on={TrackEvent.UPDATE}), @TrackField(name="portalSelect", on={TrackEvent.UPDATE})})
public class AppPortal
extends App {
    @Widget(title="Manage sale orders")
    private Boolean manageSaleOrders = Boolean.TRUE;
    @Widget(title="Manage invoices")
    private Boolean manageInvoices = Boolean.TRUE;
    @Widget(title="Manage tickets")
    private Boolean manageTickets = Boolean.TRUE;
    @Widget(title="Manage projects")
    private Boolean manageProjects = Boolean.TRUE;
    @Widget(title="Manage delivery")
    private Boolean manageDelivery = Boolean.TRUE;
    @Widget(title="Can confirm online")
    private Boolean canConfirmOnline = Boolean.TRUE;
    @Widget(title="Display product catalog")
    private Boolean showCatalog = Boolean.TRUE;
    @Widget(title="Can pay online")
    private Boolean canPayOnline = Boolean.FALSE;
    @Widget(title="Online payment methods")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<OnlinePaymentMethod> onlinePaymentMethodSet;
    @Widget(title="Portal", selection="clientportal.extern.or.intern")
    private Integer portalSelect = 1;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Boolean getManageSaleOrders() {
        return this.manageSaleOrders == null ? Boolean.FALSE : this.manageSaleOrders;
    }

    public void setManageSaleOrders(Boolean manageSaleOrders) {
        this.manageSaleOrders = manageSaleOrders;
    }

    public Boolean getManageInvoices() {
        return this.manageInvoices == null ? Boolean.FALSE : this.manageInvoices;
    }

    public void setManageInvoices(Boolean manageInvoices) {
        this.manageInvoices = manageInvoices;
    }

    public Boolean getManageTickets() {
        return this.manageTickets == null ? Boolean.FALSE : this.manageTickets;
    }

    public void setManageTickets(Boolean manageTickets) {
        this.manageTickets = manageTickets;
    }

    public Boolean getManageProjects() {
        return this.manageProjects == null ? Boolean.FALSE : this.manageProjects;
    }

    public void setManageProjects(Boolean manageProjects) {
        this.manageProjects = manageProjects;
    }

    public Boolean getManageDelivery() {
        return this.manageDelivery == null ? Boolean.FALSE : this.manageDelivery;
    }

    public void setManageDelivery(Boolean manageDelivery) {
        this.manageDelivery = manageDelivery;
    }

    public Boolean getCanConfirmOnline() {
        return this.canConfirmOnline == null ? Boolean.FALSE : this.canConfirmOnline;
    }

    public void setCanConfirmOnline(Boolean canConfirmOnline) {
        this.canConfirmOnline = canConfirmOnline;
    }

    public Boolean getShowCatalog() {
        return this.showCatalog == null ? Boolean.FALSE : this.showCatalog;
    }

    public void setShowCatalog(Boolean showCatalog) {
        this.showCatalog = showCatalog;
    }

    public Boolean getCanPayOnline() {
        return this.canPayOnline == null ? Boolean.FALSE : this.canPayOnline;
    }

    public void setCanPayOnline(Boolean canPayOnline) {
        this.canPayOnline = canPayOnline;
    }

    public Set<OnlinePaymentMethod> getOnlinePaymentMethodSet() {
        return this.onlinePaymentMethodSet;
    }

    public void setOnlinePaymentMethodSet(Set<OnlinePaymentMethod> onlinePaymentMethodSet) {
        this.onlinePaymentMethodSet = onlinePaymentMethodSet;
    }

    public void addOnlinePaymentMethodSetItem(OnlinePaymentMethod item) {
        if (this.getOnlinePaymentMethodSet() == null) {
            this.setOnlinePaymentMethodSet(new HashSet<OnlinePaymentMethod>());
        }
        this.getOnlinePaymentMethodSet().add(item);
    }

    public void removeOnlinePaymentMethodSetItem(OnlinePaymentMethod item) {
        if (this.getOnlinePaymentMethodSet() == null) {
            return;
        }
        this.getOnlinePaymentMethodSet().remove((Object)item);
    }

    public void clearOnlinePaymentMethodSet() {
        if (this.getOnlinePaymentMethodSet() != null) {
            this.getOnlinePaymentMethodSet().clear();
        }
    }

    public Integer getPortalSelect() {
        return this.portalSelect == null ? 0 : this.portalSelect;
    }

    public void setPortalSelect(Integer portalSelect) {
        this.portalSelect = portalSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        return EntityHelper.equals((Model)((Object)this), (Object)obj);
    }

    public int hashCode() {
        return EntityHelper.hashCode((Model)((Object)this));
    }

    public String toString() {
        return EntityHelper.toString((Model)((Object)this));
    }
}

