/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.portal.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.helpdesk.db.Ticket;
import com.axelor.apps.helpdesk.db.repo.TicketRepository;
import com.axelor.apps.portal.service.ClientViewService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.auth.db.User;
import com.axelor.db.JpaSecurity;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.filter.Filter;
import com.axelor.rpc.filter.JPQLFilter;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientViewServiceImpl
implements ClientViewService {
    protected SaleOrderRepository saleOrderRepo;
    protected StockMoveRepository stockMoveRepo;
    protected ProjectRepository projectRepo;
    protected TicketRepository ticketRepo;
    protected InvoiceRepository invoiceRepo;
    protected TeamTaskRepository teamTaskRepo;
    protected JpaSecurity security;
    protected static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    static final String CLIENT_PORTAL_NO_DATE = "None";

    @Inject
    public ClientViewServiceImpl(SaleOrderRepository saleOrderRepo, StockMoveRepository stockMoveRepo, ProjectRepository projectRepo, TicketRepository ticketRepo, InvoiceRepository invoiceRepo, TeamTaskRepository teamTaskRepo, JpaSecurity jpaSecurity) {
        this.saleOrderRepo = saleOrderRepo;
        this.stockMoveRepo = stockMoveRepo;
        this.projectRepo = projectRepo;
        this.ticketRepo = ticketRepo;
        this.invoiceRepo = invoiceRepo;
        this.teamTaskRepo = teamTaskRepo;
        this.security = jpaSecurity;
    }

    @Override
    public User getClientUser() {
        return ((UserService)Beans.get(UserService.class)).getUser();
    }

    @Override
    public Map<String, Object> updateClientViewIndicators() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        User user = this.getClientUser();
        map.put("$ordersInProgress", this.getOrdersInProgressIndicator(user));
        map.put("$myQuotation", this.getQuotationsIndicator(user));
        map.put("$lastOrder", this.getLastOrderIndicator(user));
        map.put("$lastDelivery", this.getLastDeliveryIndicator(user));
        map.put("$nextDelivery", this.getNextDeliveryIndicator(user));
        map.put("$plannedDeliveries", this.getPlannedDeliveriesIndicator(user));
        map.put("$myReversions", this.getReversionsIndicator(user));
        map.put("$overdueInvoices", this.getOverdueInvoicesIndicator(user));
        map.put("$awaitingInvoices", this.getAwaitingInvoicesIndicator(user));
        map.put("$totalRemaining", this.getTotalRemainingIndicator(user));
        map.put("$myRefund", this.getRefundIndicator(user));
        map.put("$customerTickets", this.getCustomerTicketsIndicator(user));
        map.put("$companyTickets", this.getCompanyTicketsIndicator(user));
        map.put("$resolvedTickets", this.getResolvedTicketsIndicator(user));
        map.put("$lateTickets", this.getLateTicketsIndicator(user));
        map.put("$totalProjects", this.getTotalProjectsIndicator(user));
        map.put("$newTasks", this.getNewTasksIndicator(user));
        map.put("$tasksInProgress", this.getTasksInProgressIndicator(user));
        map.put("$tasksDue", this.getTasksDueIndicator(user));
        return map;
    }

    protected Integer getOrdersInProgressIndicator(User user) {
        List<Filter> filters = this.getOrdersInProgressOfUser(user);
        List saleOrderList = Filter.and(filters).build(SaleOrder.class).fetch();
        return !saleOrderList.isEmpty() ? saleOrderList.size() : 0;
    }

    protected Integer getQuotationsIndicator(User user) {
        List<Filter> filters = this.getQuotationsOfUser(user);
        List saleOrderList = Filter.and(filters).build(SaleOrder.class).fetch();
        return !saleOrderList.isEmpty() ? saleOrderList.size() : 0;
    }

    protected String getLastOrderIndicator(User user) {
        List<Filter> filters = this.getLastOrderOfUser(user);
        SaleOrder saleOrder = (SaleOrder)((Object)Filter.and(filters).build(SaleOrder.class).order("-confirmationDateTime").fetchOne());
        if (saleOrder == null) {
            return I18n.get((String)CLIENT_PORTAL_NO_DATE);
        }
        return saleOrder.getConfirmationDateTime() != null ? saleOrder.getConfirmationDateTime().format(DATE_FORMATTER) : I18n.get((String)CLIENT_PORTAL_NO_DATE);
    }

    protected String getLastDeliveryIndicator(User user) {
        List<Filter> filters = this.getLastDeliveryOfUser(user);
        StockMove stockMove = (StockMove)((Object)Filter.and(filters).build(StockMove.class).order("-realDate").fetchOne());
        if (stockMove == null) {
            return I18n.get((String)CLIENT_PORTAL_NO_DATE);
        }
        return stockMove.getRealDate() != null ? stockMove.getRealDate().format(DATE_FORMATTER) : I18n.get((String)CLIENT_PORTAL_NO_DATE);
    }

    protected String getNextDeliveryIndicator(User user) {
        List<Filter> filters = this.getNextDeliveryOfUser(user);
        StockMove stockMove = (StockMove)((Object)Filter.and(filters).build(StockMove.class).order("estimatedDate").fetchOne());
        if (stockMove == null) {
            return I18n.get((String)CLIENT_PORTAL_NO_DATE);
        }
        return stockMove.getEstimatedDate() != null ? stockMove.getEstimatedDate().format(DATE_FORMATTER) : I18n.get((String)CLIENT_PORTAL_NO_DATE);
    }

    protected Integer getPlannedDeliveriesIndicator(User user) {
        List<Filter> filters = this.getPlannedDeliveriesOfUser(user);
        List stockMoveList = Filter.and(filters).build(StockMove.class).fetch();
        return !stockMoveList.isEmpty() ? stockMoveList.size() : 0;
    }

    protected Integer getReversionsIndicator(User user) {
        List<Filter> filters = this.getReversionsOfUser(user);
        List stockMoveList = Filter.and(filters).build(StockMove.class).fetch();
        return !stockMoveList.isEmpty() ? stockMoveList.size() : 0;
    }

    protected Integer getOverdueInvoicesIndicator(User user) {
        List<Filter> filters = this.getOverdueInvoicesOfUser(user);
        List invoiceList = Filter.and(filters).build(Invoice.class).fetch();
        return !invoiceList.isEmpty() ? invoiceList.size() : 0;
    }

    protected Integer getAwaitingInvoicesIndicator(User user) {
        List<Filter> filters = this.getAwaitingInvoicesOfUser(user);
        List invoiceList = Filter.and(filters).build(Invoice.class).fetch();
        return !invoiceList.isEmpty() ? invoiceList.size() : 0;
    }

    protected String getTotalRemainingIndicator(User user) {
        List<Filter> filters = this.getTotalRemainingOfUser(user);
        List invoiceList = Filter.and(filters).build(Invoice.class).fetch();
        if (!invoiceList.isEmpty()) {
            BigDecimal total = invoiceList.stream().map(Invoice::getAmountRemaining).reduce((x, y) -> x.add((BigDecimal)y)).orElse(BigDecimal.ZERO);
            return total.toString() + ((Invoice)((Object)invoiceList.get(0))).getCurrency().getSymbol();
        }
        return BigDecimal.ZERO.toString();
    }

    protected Integer getRefundIndicator(User user) {
        List<Filter> filters = this.getRefundOfUser(user);
        List invoiceList = Filter.and(filters).build(Invoice.class).fetch();
        return !invoiceList.isEmpty() ? invoiceList.size() : 0;
    }

    protected Integer getCustomerTicketsIndicator(User user) {
        List<Filter> filters = this.getTicketsOfUser(user);
        List ticketList = Filter.and(filters).build(Ticket.class).fetch();
        return !ticketList.isEmpty() ? ticketList.size() : 0;
    }

    protected Integer getCompanyTicketsIndicator(User user) {
        List<Filter> filters = this.getCompanyTicketsOfUser(user);
        List ticketList = Filter.and(filters).build(Ticket.class).fetch();
        return !ticketList.isEmpty() ? ticketList.size() : 0;
    }

    protected Integer getResolvedTicketsIndicator(User user) {
        List<Filter> filters = this.getResolvedTicketsOfUser(user);
        List ticketList = Filter.and(filters).build(Ticket.class).fetch();
        return !ticketList.isEmpty() ? ticketList.size() : 0;
    }

    protected Object getLateTicketsIndicator(User user) {
        List<Filter> filters = this.getLateTicketsOfUser(user);
        List ticketList = Filter.and(filters).build(Ticket.class).fetch();
        return !ticketList.isEmpty() ? ticketList.size() : 0;
    }

    protected Integer getTotalProjectsIndicator(User user) {
        List<Filter> filters = this.getTotalProjectsOfUser(user);
        List projectList = Filter.and(filters).build(Project.class).fetch();
        return !projectList.isEmpty() ? projectList.size() : 0;
    }

    protected Integer getNewTasksIndicator(User user) {
        List<Filter> filters = this.getNewTasksOfUser(user);
        List teamTaskList = Filter.and(filters).build(TeamTask.class).fetch();
        return !teamTaskList.isEmpty() ? teamTaskList.size() : 0;
    }

    protected Integer getTasksInProgressIndicator(User user) {
        List<Filter> filters = this.getTasksInProgressOfUser(user);
        List teamTaskList = Filter.and(filters).build(TeamTask.class).fetch();
        return !teamTaskList.isEmpty() ? teamTaskList.size() : 0;
    }

    protected Integer getTasksDueIndicator(User user) {
        List<Filter> filters = this.getTasksDueOfUser(user);
        List teamTaskList = Filter.and(filters).build(TeamTask.class).fetch();
        return !teamTaskList.isEmpty() ? teamTaskList.size() : 0;
    }

    @Override
    public List<Filter> getOrdersInProgressOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, SaleOrder.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.clientPartner.id = " + user.getPartner().getId() + " AND self.statusSelect = " + 3, new Object[0]);
        if (user.getActiveCompany() != null) {
            filter = Filter.and((Filter)filter, (Filter)new JPQLFilter(" self.company.id = " + user.getActiveCompany().getId(), new Object[0]), (Filter[])new Filter[0]);
        }
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getQuotationsOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, SaleOrder.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.clientPartner.id = " + user.getPartner().getId() + " AND self.statusSelect IN (" + 1 + "," + 2 + ")", new Object[0]);
        if (user.getActiveCompany() != null) {
            filter = Filter.and((Filter)filter, (Filter)new JPQLFilter(" self.company.id = " + user.getActiveCompany().getId(), new Object[0]), (Filter[])new Filter[0]);
        }
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getLastOrderOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, SaleOrder.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.clientPartner.id = " + user.getPartner().getId() + " AND self.statusSelect = " + 4, new Object[0]);
        if (user.getActiveCompany() != null) {
            filter = Filter.and((Filter)filter, (Filter)new JPQLFilter(" self.company.id = " + user.getActiveCompany().getId(), new Object[0]), (Filter[])new Filter[0]);
        }
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getLastDeliveryOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, StockMove.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.partner.id = " + user.getPartner().getId() + " AND self.typeSelect = " + 2 + " AND self.statusSelect = " + 3 + " AND self.isReversion != true", new Object[0]);
        if (user.getActiveCompany() != null) {
            filter = Filter.and((Filter)filter, (Filter)new JPQLFilter(" self.company.id = " + user.getActiveCompany().getId(), new Object[0]), (Filter[])new Filter[0]);
        }
        if (filterFromPermission != null) {
            filter = Filter.and((Filter)filter, (Filter)filterFromPermission, (Filter[])new Filter[0]);
        }
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getNextDeliveryOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, StockMove.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.partner.id = " + user.getPartner().getId() + " AND self.typeSelect = " + 2 + " AND self.statusSelect = " + 2 + " AND self.isReversion != true", new Object[0]);
        if (user.getActiveCompany() != null) {
            filter = Filter.and((Filter)filter, (Filter)new JPQLFilter(" self.company.id = " + user.getActiveCompany().getId(), new Object[0]), (Filter[])new Filter[0]);
        }
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    private void addPermissionFilter(List<Filter> filters, Filter filterFromPermission) {
        if (filterFromPermission != null) {
            filters.add(filterFromPermission);
        }
    }

    @Override
    public List<Filter> getPlannedDeliveriesOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, StockMove.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.partner.id = " + user.getPartner().getId() + " AND self.typeSelect = " + 2 + " AND self.statusSelect = " + 2 + " AND self.isReversion != true", new Object[0]);
        if (user.getActiveCompany() != null) {
            filter = Filter.and((Filter)filter, (Filter)new JPQLFilter(" self.company.id = " + user.getActiveCompany().getId(), new Object[0]), (Filter[])new Filter[0]);
        }
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getReversionsOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, StockMove.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.partner.id = " + user.getPartner().getId() + " AND self.typeSelect = " + 2 + " AND self.isReversion = true", new Object[0]);
        if (user.getActiveCompany() != null) {
            filter = Filter.and((Filter)filter, (Filter)new JPQLFilter(" self.company.id = " + user.getActiveCompany().getId(), new Object[0]), (Filter[])new Filter[0]);
        }
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getOverdueInvoicesOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, Invoice.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.partner.id = " + user.getPartner().getId() + " AND self.dueDate < current_date()  AND self.amountRemaining != 0 AND self.statusSelect != " + 1 + " AND self.statusSelect != " + 4, new Object[0]);
        if (user.getActiveCompany() != null) {
            filter = Filter.and((Filter)filter, (Filter)new JPQLFilter(" self.company.id = " + user.getActiveCompany().getId(), new Object[0]), (Filter[])new Filter[0]);
        }
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getAwaitingInvoicesOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, Invoice.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.partner.id = " + user.getPartner().getId() + " AND self.amountRemaining != 0 AND self.statusSelect != " + 1 + " AND self.statusSelect != " + 4, new Object[0]);
        if (user.getActiveCompany() != null) {
            filter = Filter.and((Filter)filter, (Filter)new JPQLFilter(" self.company.id = " + user.getActiveCompany().getId(), new Object[0]), (Filter[])new Filter[0]);
        }
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getTotalRemainingOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, Invoice.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.partner.id = " + user.getPartner().getId() + " AND self.amountRemaining != 0 AND self.statusSelect != " + 1 + " AND self.statusSelect != " + 4, new Object[0]);
        if (user.getActiveCompany() != null) {
            filter = Filter.and((Filter)filter, (Filter)new JPQLFilter(" self.company.id = " + user.getActiveCompany().getId(), new Object[0]), (Filter[])new Filter[0]);
        }
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getRefundOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, Invoice.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.partner.id = " + user.getPartner().getId() + " AND self.operationTypeSelect = " + 4, new Object[0]);
        if (user.getActiveCompany() != null) {
            filter = Filter.and((Filter)filter, (Filter)new JPQLFilter(" self.company.id = " + user.getActiveCompany().getId(), new Object[0]), (Filter[])new Filter[0]);
        }
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getTicketsOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, Ticket.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.customer.id = " + user.getPartner().getId() + " AND self.assignedToUser.id = " + user.getId(), new Object[0]);
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getCompanyTicketsOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, Ticket.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.customer.id = " + user.getPartner().getId() + " AND self.assignedToUser.id = " + user.getActiveCompany().getId(), new Object[0]);
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getResolvedTicketsOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, Ticket.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.customer.id = " + user.getPartner().getId() + " AND self.assignedToUser.id = " + user.getId() + " AND self.statusSelect IN (" + 2 + ", " + 3 + ")", new Object[0]);
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getLateTicketsOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, Ticket.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.customer.id = " + user.getPartner().getId() + " AND self.assignedToUser.id = " + user.getId() + " AND ((self.endDateT != null AND self.endDateT > self.deadlineDateT)  OR (self.endDateT = null and self.deadlineDateT < current_date() ) )", new Object[0]);
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getTotalProjectsOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, Project.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.isProject = true AND self.clientPartner.id = " + user.getPartner().getId() + " AND self.statusSelect != " + ProjectRepository.STATE_CANCELED, new Object[0]);
        if (user.getActiveCompany() != null) {
            filter = Filter.and((Filter)filter, (Filter)new JPQLFilter(" self.company.id = " + user.getActiveCompany().getId(), new Object[0]), (Filter[])new Filter[0]);
        }
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getNewTasksOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, TeamTask.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.status = 'new'  AND self.typeSelect = 'task' AND self.project.clientPartner.id = " + user.getPartner().getId(), new Object[0]);
        if (user.getActiveCompany() != null) {
            filter = Filter.and((Filter)filter, (Filter)new JPQLFilter(" self.project.company.id = " + user.getActiveCompany().getId(), new Object[0]), (Filter[])new Filter[0]);
        }
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getTasksInProgressOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, TeamTask.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.status = 'in-progress' AND self.typeSelect = 'task' AND self.project.clientPartner.id = " + user.getPartner().getId(), new Object[0]);
        if (user.getActiveCompany() != null) {
            filter = Filter.and((Filter)filter, (Filter)new JPQLFilter(" self.project.company.id = " + user.getActiveCompany().getId(), new Object[0]), (Filter[])new Filter[0]);
        }
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }

    @Override
    public List<Filter> getTasksDueOfUser(User user) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter filterFromPermission = this.security.getFilter(JpaSecurity.CAN_READ, TeamTask.class, new Long[0]);
        JPQLFilter filter = new JPQLFilter("self.status IN ('in-progress','new') AND self.project.clientPartner.id = " + user.getPartner().getId() + " AND self.typeSelect = '" + "task" + "' AND self.taskEndDate  < current_date() ", new Object[0]);
        if (user.getActiveCompany() != null) {
            filter = Filter.and((Filter)filter, (Filter)new JPQLFilter(" self.project.company.id = " + user.getActiveCompany().getId(), new Object[0]), (Filter[])new Filter[0]);
        }
        filters.add((Filter)filter);
        this.addPermissionFilter(filters, filterFromPermission);
        return filters;
    }
}

