/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db;

import com.axelor.apps.bankpayment.db.BankOrderEconomicReason;
import com.axelor.apps.bankpayment.db.BankOrderFileFormatCountry;
import com.axelor.apps.base.db.Country;
import com.axelor.apps.base.db.Currency;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BANKPAYMENT_BANK_ORDER_FILE_FORMAT", indexes={@Index(columnList="name"), @Index(columnList="currency"), @Index(name="idx_bankpayment_bank_order_file_format_economic_reason", columnList="bank_order_economic_reason"), @Index(columnList="receiver_country")})
public class BankOrderFileFormat
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BANKPAYMENT_BANK_ORDER_FILE_FORMAT_SEQ")
    @SequenceGenerator(name="BANKPAYMENT_BANK_ORDER_FILE_FORMAT_SEQ", sequenceName="BANKPAYMENT_BANK_ORDER_FILE_FORMAT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Order Type", selection="bankpayment.bank.order.type.select")
    private Integer orderTypeSelect = 0;
    @Widget(title="File format", selection="bankpayment.order.file.format.select")
    private String orderFileFormatSelect;
    @Widget(title="Name")
    private String name;
    @Widget(title="Description", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="File generation supported")
    private Boolean fileGenerationSupported = Boolean.FALSE;
    @Widget(title="Accepted Bank Details Identifiers", selection="base.bank.bank.details.type.select")
    private String bankDetailsTypeSelect;
    @Widget(title="Use iban only")
    private Boolean ibanOnly = Boolean.FALSE;
    @Widget(title="Default Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Allow orders with a transfer currency different from bank details currency")
    private Boolean allowOrderCurrDiffFromBankDetails = Boolean.FALSE;
    @Widget(title="Qualifying of date")
    private String qualifyingOfDate;
    @Widget(title="Qualifying of amount", selection="bankpayment.bank.order.ff.qualifying.amount.select")
    private String qualifyingOfAmountSelect = "T";
    @Widget(title="Multidate")
    private Boolean isMultiDate = Boolean.FALSE;
    @Widget(title="Multicurrency")
    private Boolean isMultiCurrency = Boolean.FALSE;
    @Widget(title="Order debit type", selection="bankpayment.order.debit.type.select")
    @Column(nullable=true)
    private Integer orderDebitTypeSelect;
    @Widget(title="Display additional information")
    private Boolean displayAdditionnalInformations = Boolean.FALSE;
    @Widget(title="Display economic reason")
    private Boolean displayBankOrderEconomicReason = Boolean.FALSE;
    @Widget(title="Default economic reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankOrderEconomicReason bankOrderEconomicReason;
    @Widget(title="Display receiver country")
    private Boolean displayReceiverCountry = Boolean.FALSE;
    @Widget(title="Default receiver country")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Country receiverCountry;
    @Widget(title="Display payment mode")
    private Boolean displayPaymentModeSelect = Boolean.FALSE;
    @Widget(title="Default payment Mode", selection="bankpayment.bank.order.line.payment.mode.select")
    private Integer paymentModeSelect = 0;
    @Widget(title="Display fees imputation")
    private Boolean displayFeesImputationModeSelect = Boolean.FALSE;
    @Widget(title="Default fees imputation", selection="bankpayment.bank.order.line.fees.imputation.mode.select")
    private Integer feesImputationModeSelect = 0;
    @Widget(title="Display further information")
    private Boolean displayFurtherInformations = Boolean.FALSE;
    @Widget(title="Display receiver address")
    private Boolean displayReceiverAddress = Boolean.FALSE;
    @Widget(title="Config. per country")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="bankOrderFileFormat", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BankOrderFileFormatCountry> bankOrderFileFormatCountryList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public BankOrderFileFormat() {
    }

    public BankOrderFileFormat(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getOrderTypeSelect() {
        return this.orderTypeSelect == null ? 0 : this.orderTypeSelect;
    }

    public void setOrderTypeSelect(Integer orderTypeSelect) {
        this.orderTypeSelect = orderTypeSelect;
    }

    public String getOrderFileFormatSelect() {
        return this.orderFileFormatSelect;
    }

    public void setOrderFileFormatSelect(String orderFileFormatSelect) {
        this.orderFileFormatSelect = orderFileFormatSelect;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getFileGenerationSupported() {
        return this.fileGenerationSupported == null ? Boolean.FALSE : this.fileGenerationSupported;
    }

    public void setFileGenerationSupported(Boolean fileGenerationSupported) {
        this.fileGenerationSupported = fileGenerationSupported;
    }

    public String getBankDetailsTypeSelect() {
        return this.bankDetailsTypeSelect;
    }

    public void setBankDetailsTypeSelect(String bankDetailsTypeSelect) {
        this.bankDetailsTypeSelect = bankDetailsTypeSelect;
    }

    public Boolean getIbanOnly() {
        return this.ibanOnly == null ? Boolean.FALSE : this.ibanOnly;
    }

    public void setIbanOnly(Boolean ibanOnly) {
        this.ibanOnly = ibanOnly;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public Boolean getAllowOrderCurrDiffFromBankDetails() {
        return this.allowOrderCurrDiffFromBankDetails == null ? Boolean.FALSE : this.allowOrderCurrDiffFromBankDetails;
    }

    public void setAllowOrderCurrDiffFromBankDetails(Boolean allowOrderCurrDiffFromBankDetails) {
        this.allowOrderCurrDiffFromBankDetails = allowOrderCurrDiffFromBankDetails;
    }

    public String getQualifyingOfDate() {
        return this.qualifyingOfDate;
    }

    public void setQualifyingOfDate(String qualifyingOfDate) {
        this.qualifyingOfDate = qualifyingOfDate;
    }

    public String getQualifyingOfAmountSelect() {
        return this.qualifyingOfAmountSelect;
    }

    public void setQualifyingOfAmountSelect(String qualifyingOfAmountSelect) {
        this.qualifyingOfAmountSelect = qualifyingOfAmountSelect;
    }

    public Boolean getIsMultiDate() {
        return this.isMultiDate == null ? Boolean.FALSE : this.isMultiDate;
    }

    public void setIsMultiDate(Boolean isMultiDate) {
        this.isMultiDate = isMultiDate;
    }

    public Boolean getIsMultiCurrency() {
        return this.isMultiCurrency == null ? Boolean.FALSE : this.isMultiCurrency;
    }

    public void setIsMultiCurrency(Boolean isMultiCurrency) {
        this.isMultiCurrency = isMultiCurrency;
    }

    public Integer getOrderDebitTypeSelect() {
        return this.orderDebitTypeSelect;
    }

    public void setOrderDebitTypeSelect(Integer orderDebitTypeSelect) {
        this.orderDebitTypeSelect = orderDebitTypeSelect;
    }

    public Boolean getDisplayAdditionnalInformations() {
        return this.displayAdditionnalInformations == null ? Boolean.FALSE : this.displayAdditionnalInformations;
    }

    public void setDisplayAdditionnalInformations(Boolean displayAdditionnalInformations) {
        this.displayAdditionnalInformations = displayAdditionnalInformations;
    }

    public Boolean getDisplayBankOrderEconomicReason() {
        return this.displayBankOrderEconomicReason == null ? Boolean.FALSE : this.displayBankOrderEconomicReason;
    }

    public void setDisplayBankOrderEconomicReason(Boolean displayBankOrderEconomicReason) {
        this.displayBankOrderEconomicReason = displayBankOrderEconomicReason;
    }

    public BankOrderEconomicReason getBankOrderEconomicReason() {
        return this.bankOrderEconomicReason;
    }

    public void setBankOrderEconomicReason(BankOrderEconomicReason bankOrderEconomicReason) {
        this.bankOrderEconomicReason = bankOrderEconomicReason;
    }

    public Boolean getDisplayReceiverCountry() {
        return this.displayReceiverCountry == null ? Boolean.FALSE : this.displayReceiverCountry;
    }

    public void setDisplayReceiverCountry(Boolean displayReceiverCountry) {
        this.displayReceiverCountry = displayReceiverCountry;
    }

    public Country getReceiverCountry() {
        return this.receiverCountry;
    }

    public void setReceiverCountry(Country receiverCountry) {
        this.receiverCountry = receiverCountry;
    }

    public Boolean getDisplayPaymentModeSelect() {
        return this.displayPaymentModeSelect == null ? Boolean.FALSE : this.displayPaymentModeSelect;
    }

    public void setDisplayPaymentModeSelect(Boolean displayPaymentModeSelect) {
        this.displayPaymentModeSelect = displayPaymentModeSelect;
    }

    public Integer getPaymentModeSelect() {
        return this.paymentModeSelect == null ? 0 : this.paymentModeSelect;
    }

    public void setPaymentModeSelect(Integer paymentModeSelect) {
        this.paymentModeSelect = paymentModeSelect;
    }

    public Boolean getDisplayFeesImputationModeSelect() {
        return this.displayFeesImputationModeSelect == null ? Boolean.FALSE : this.displayFeesImputationModeSelect;
    }

    public void setDisplayFeesImputationModeSelect(Boolean displayFeesImputationModeSelect) {
        this.displayFeesImputationModeSelect = displayFeesImputationModeSelect;
    }

    public Integer getFeesImputationModeSelect() {
        return this.feesImputationModeSelect == null ? 0 : this.feesImputationModeSelect;
    }

    public void setFeesImputationModeSelect(Integer feesImputationModeSelect) {
        this.feesImputationModeSelect = feesImputationModeSelect;
    }

    public Boolean getDisplayFurtherInformations() {
        return this.displayFurtherInformations == null ? Boolean.FALSE : this.displayFurtherInformations;
    }

    public void setDisplayFurtherInformations(Boolean displayFurtherInformations) {
        this.displayFurtherInformations = displayFurtherInformations;
    }

    public Boolean getDisplayReceiverAddress() {
        return this.displayReceiverAddress == null ? Boolean.FALSE : this.displayReceiverAddress;
    }

    public void setDisplayReceiverAddress(Boolean displayReceiverAddress) {
        this.displayReceiverAddress = displayReceiverAddress;
    }

    public List<BankOrderFileFormatCountry> getBankOrderFileFormatCountryList() {
        return this.bankOrderFileFormatCountryList;
    }

    public void setBankOrderFileFormatCountryList(List<BankOrderFileFormatCountry> bankOrderFileFormatCountryList) {
        this.bankOrderFileFormatCountryList = bankOrderFileFormatCountryList;
    }

    public void addBankOrderFileFormatCountryListItem(BankOrderFileFormatCountry item) {
        if (this.getBankOrderFileFormatCountryList() == null) {
            this.setBankOrderFileFormatCountryList(new ArrayList<BankOrderFileFormatCountry>());
        }
        this.getBankOrderFileFormatCountryList().add(item);
        item.setBankOrderFileFormat(this);
    }

    public void removeBankOrderFileFormatCountryListItem(BankOrderFileFormatCountry item) {
        if (this.getBankOrderFileFormatCountryList() == null) {
            return;
        }
        this.getBankOrderFileFormatCountryList().remove((Object)item);
    }

    public void clearBankOrderFileFormatCountryList() {
        if (this.getBankOrderFileFormatCountryList() != null) {
            this.getBankOrderFileFormatCountryList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BankOrderFileFormat)) {
            return false;
        }
        BankOrderFileFormat other = (BankOrderFileFormat)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("orderTypeSelect", (Object)this.getOrderTypeSelect()).add("orderFileFormatSelect", (Object)this.getOrderFileFormatSelect()).add("name", (Object)this.getName()).add("fileGenerationSupported", (Object)this.getFileGenerationSupported()).add("bankDetailsTypeSelect", (Object)this.getBankDetailsTypeSelect()).add("ibanOnly", (Object)this.getIbanOnly()).add("allowOrderCurrDiffFromBankDetails", (Object)this.getAllowOrderCurrDiffFromBankDetails()).add("qualifyingOfDate", (Object)this.getQualifyingOfDate()).add("qualifyingOfAmountSelect", (Object)this.getQualifyingOfAmountSelect()).add("isMultiDate", (Object)this.getIsMultiDate()).add("isMultiCurrency", (Object)this.getIsMultiCurrency()).omitNullValues().toString();
    }
}

