/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db;

import com.axelor.apps.bankpayment.db.BankOrderFileFormat;
import com.axelor.apps.base.db.Country;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BANKPAYMENT_BANK_ORDER_FILE_FORMAT_COUNTRY", indexes={@Index(columnList="bank_order_file_format"), @Index(columnList="country")})
public class BankOrderFileFormatCountry
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BANKPAYMENT_BANK_ORDER_FILE_FORMAT_COUNTRY_SEQ")
    @SequenceGenerator(name="BANKPAYMENT_BANK_ORDER_FILE_FORMAT_COUNTRY_SEQ", sequenceName="BANKPAYMENT_BANK_ORDER_FILE_FORMAT_COUNTRY_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Bank order file format")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankOrderFileFormat bankOrderFileFormat;
    @Widget(title="Country")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Country country;
    @Widget(title="Receiver address required")
    private Boolean receiverAddressRequired = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BankOrderFileFormat getBankOrderFileFormat() {
        return this.bankOrderFileFormat;
    }

    public void setBankOrderFileFormat(BankOrderFileFormat bankOrderFileFormat) {
        this.bankOrderFileFormat = bankOrderFileFormat;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public Boolean getReceiverAddressRequired() {
        return this.receiverAddressRequired == null ? Boolean.FALSE : this.receiverAddressRequired;
    }

    public void setReceiverAddressRequired(Boolean receiverAddressRequired) {
        this.receiverAddressRequired = receiverAddressRequired;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BankOrderFileFormatCountry)) {
            return false;
        }
        BankOrderFileFormatCountry other = (BankOrderFileFormatCountry)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("receiverAddressRequired", (Object)this.getReceiverAddressRequired()).omitNullValues().toString();
    }
}

