/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db;

import com.axelor.apps.bankpayment.db.BankStatementFileFormat;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.message.db.Template;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BANKPAYMENT_BANK_PAYMENT_BATCH", indexes={@Index(columnList="company"), @Index(columnList="template")})
public class BankPaymentBatch
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BANKPAYMENT_BANK_PAYMENT_BATCH_SEQ")
    @SequenceGenerator(name="BANKPAYMENT_BANK_PAYMENT_BATCH_SEQ", sequenceName="BANKPAYMENT_BANK_PAYMENT_BATCH_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Code")
    @NameColumn
    @Column(unique=true)
    private String code;
    @Widget(title="Action", selection="bank.payment.batch.action.select")
    @NotNull
    private Integer actionSelect = 0;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Batchs")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="bankPaymentBatch", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Batch> batchList;
    @Widget(title="Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template template;
    @Widget(title="Number of days to take into account to alert")
    private Integer daysNbr = 0;
    @Widget(title="Ebics partners")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<EbicsPartner> ebicsPartnerSet;
    @Widget(title="Bank statement file formats")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<BankStatementFileFormat> bankStatementFileFormatSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public BankPaymentBatch() {
    }

    public BankPaymentBatch(String code) {
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getActionSelect() {
        return this.actionSelect == null ? 0 : this.actionSelect;
    }

    public void setActionSelect(Integer actionSelect) {
        this.actionSelect = actionSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Batch> getBatchList() {
        return this.batchList;
    }

    public void setBatchList(List<Batch> batchList) {
        this.batchList = batchList;
    }

    public void addBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            this.setBatchList(new ArrayList<Batch>());
        }
        this.getBatchList().add(item);
        item.setBankPaymentBatch(this);
    }

    public void removeBatchListItem(Batch item) {
        if (this.getBatchList() == null) {
            return;
        }
        this.getBatchList().remove((Object)item);
    }

    public void clearBatchList() {
        if (this.getBatchList() != null) {
            this.getBatchList().clear();
        }
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public Integer getDaysNbr() {
        return this.daysNbr == null ? 0 : this.daysNbr;
    }

    public void setDaysNbr(Integer daysNbr) {
        this.daysNbr = daysNbr;
    }

    public Set<EbicsPartner> getEbicsPartnerSet() {
        return this.ebicsPartnerSet;
    }

    public void setEbicsPartnerSet(Set<EbicsPartner> ebicsPartnerSet) {
        this.ebicsPartnerSet = ebicsPartnerSet;
    }

    public void addEbicsPartnerSetItem(EbicsPartner item) {
        if (this.getEbicsPartnerSet() == null) {
            this.setEbicsPartnerSet(new HashSet<EbicsPartner>());
        }
        this.getEbicsPartnerSet().add(item);
    }

    public void removeEbicsPartnerSetItem(EbicsPartner item) {
        if (this.getEbicsPartnerSet() == null) {
            return;
        }
        this.getEbicsPartnerSet().remove((Object)item);
    }

    public void clearEbicsPartnerSet() {
        if (this.getEbicsPartnerSet() != null) {
            this.getEbicsPartnerSet().clear();
        }
    }

    public Set<BankStatementFileFormat> getBankStatementFileFormatSet() {
        return this.bankStatementFileFormatSet;
    }

    public void setBankStatementFileFormatSet(Set<BankStatementFileFormat> bankStatementFileFormatSet) {
        this.bankStatementFileFormatSet = bankStatementFileFormatSet;
    }

    public void addBankStatementFileFormatSetItem(BankStatementFileFormat item) {
        if (this.getBankStatementFileFormatSet() == null) {
            this.setBankStatementFileFormatSet(new HashSet<BankStatementFileFormat>());
        }
        this.getBankStatementFileFormatSet().add(item);
    }

    public void removeBankStatementFileFormatSetItem(BankStatementFileFormat item) {
        if (this.getBankStatementFileFormatSet() == null) {
            return;
        }
        this.getBankStatementFileFormatSet().remove((Object)item);
    }

    public void clearBankStatementFileFormatSet() {
        if (this.getBankStatementFileFormatSet() != null) {
            this.getBankStatementFileFormatSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BankPaymentBatch)) {
            return false;
        }
        BankPaymentBatch other = (BankPaymentBatch)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(-598069936, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("actionSelect", (Object)this.getActionSelect()).add("daysNbr", (Object)this.getDaysNbr()).omitNullValues().toString();
    }
}

